package com.zjsgfa.project.zjsgfa.domain;

import lombok.Data;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.zjsgfa.framework.aspectj.lang.annotation.Excel;
import com.zjsgfa.framework.web.domain.BaseEntity;

/**
 * 设计-分段施工措施对象 sj_fdsgcs
 * 
 * @author ruoyi
 * @date 2025-08-06
 */
@Data
public class SjFdsgcs extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** 主键 */
    private Long id;

    /** 井号 */
    @Excel(name = "井号")
    private String jh;

    /** 开次 */
    @Excel(name = "开次")
    private String kc;

    /** 一趟钻情况 */
    @Excel(name = "一趟钻情况")
    private String tzqk;

    /** 井段情况 */
    @Excel(name = "井段情况")
    private String jdqk;

    /** 轨迹分析 */
    @Excel(name = "轨迹分析")
    private String gjfx;

    /** 轨迹优化 */
    @Excel(name = "轨迹优化")
    private String gjyh;

    /** 地层压力 */
    @Excel(name = "地层压力")
    private String dcyl;

    /** 主要风险 */
    @Excel(name = "主要风险")
    private String zyfx;

    /** 风险管控措施 */
    @Excel(name = "风险管控措施")
    private String fxgkcs;
    //钻具组合
    private String zjzh;
    //钻具组合注意事项
    private String zjzhzysx;


    private String zjycs;
    private String zjgccs;
    public void setId(Long id)
    {
        this.id = id;
    }

    public Long getId() 
    {
        return id;
    }

    public void setJh(String jh) 
    {
        this.jh = jh;
    }

    public String getJh() 
    {
        return jh;
    }

    public void setKc(String kc) 
    {
        this.kc = kc;
    }

    public String getKc() 
    {
        return kc;
    }

    public void setTzqk(String tzqk) 
    {
        this.tzqk = tzqk;
    }

    public String getTzqk() 
    {
        return tzqk;
    }

    public void setJdqk(String jdqk) 
    {
        this.jdqk = jdqk;
    }

    public String getJdqk() 
    {
        return jdqk;
    }

    public void setGjfx(String gjfx) 
    {
        this.gjfx = gjfx;
    }

    public String getGjfx() 
    {
        return gjfx;
    }

    public void setGjyh(String gjyh) 
    {
        this.gjyh = gjyh;
    }

    public String getGjyh() 
    {
        return gjyh;
    }

    public void setDcyl(String dcyl) 
    {
        this.dcyl = dcyl;
    }

    public String getDcyl() 
    {
        return dcyl;
    }

    public void setZyfx(String zyfx) 
    {
        this.zyfx = zyfx;
    }

    public String getZyfx() 
    {
        return zyfx;
    }

    public void setFxgkcs(String fxgkcs) 
    {
        this.fxgkcs = fxgkcs;
    }

    public String getFxgkcs() 
    {
        return fxgkcs;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this,ToStringStyle.MULTI_LINE_STYLE)
            .append("id", getId())
            .append("jh", getJh())
            .append("kc", getKc())
            .append("tzqk", getTzqk())
            .append("jdqk", getJdqk())
            .append("gjfx", getGjfx())
            .append("gjyh", getGjyh())
            .append("dcyl", getDcyl())
            .append("zyfx", getZyfx())
            .append("fxgkcs", getFxgkcs())
            .toString();
    }
}
