package com.zjsgfa.project.zjsgfa.domain;

import java.util.Date;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.zjsgfa.framework.aspectj.lang.annotation.Excel;
import com.zjsgfa.framework.web.domain.BaseEntity;

/**
 * 地质分层对象 sj_dzfc
 * 
 * @author ruoyi
 * @date 2025-07-07
 */
@Data
public class SjDzfc extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** 主键 */
    private Long id;

    /** 界 */
    @Excel(name = "界")
    private String dcJ;

    /** 系 */
    @Excel(name = "系")
    private String dcX;

    /** 统 */
    @Excel(name = "统")
    private String dcT;

    /** 组 */
    @Excel(name = "组")
    private String dcZ;

    /** 段 */
    @Excel(name = "段")
    private String dcD;

    /** 设计井号 */
    @Excel(name = "设计井号")
    private String sjjh;

    /** 底垂深 */
    @Excel(name = "底垂深")
    private Double sjdcs;

    /** 接触关系 */
    @Excel(name = "接触关系")
    private String sjjcgx;

    /** 厚度 */
    @Excel(name = "厚度")
    private Double sjhd;

    /** 断点深度 */
    @Excel(name = "断点深度")
    private Double sjddsd;

    /** 依据井号1 */
    @Excel(name = "依据井号1")
    private String yjjh1;

    /** 依据底深1 */
    @Excel(name = "依据底深1")
    private Double yjdcs1;

    /** 接触关系1 */
    @Excel(name = "接触关系1")
    private String yjjcgx1;

    /** 含油井段1 */
    @Excel(name = "含油井段1")
    private String yjhyjd1;

    /** 断点深度1 */
    @Excel(name = "断点深度1")
    private Double yjddsd1;

    //设计井岩性提示
    private String sjyxts;

    /** 依据井号2 */
    @Excel(name = "依据井号2")
    private String yjjh2;

    /** 依据底深2 */
    @Excel(name = "依据底深2")
    private Double yjdcs2;

    /** 接触关系2 */
    @Excel(name = "接触关系2")
    private String yjjcgx2;

    /** 含油井段2 */
    @Excel(name = "含油井段2")
    private String yjhyjd2;

    /** 断点深度2 */
    @Excel(name = "断点深度2")
    private Double yjddsd2;

    /** 创建人 */
    @Excel(name = "创建人")
    private String createdBy;

    /**
     * 依据井岩性提示1
     */
    private String yjyxts1;
    /**
     * 依据井岩性提示2
     */
    private String yjyxts2;

    private String[] jhs;


    /** 创建时间 */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "创建时间", width = 30, dateFormat = "yyyy-MM-dd")
    private Date createdTime;

    public void setId(Long id) 
    {
        this.id = id;
    }

    public Long getId() 
    {
        return id;
    }

    public void setDcJ(String dcJ) 
    {
        this.dcJ = dcJ;
    }

    public String getDcJ() 
    {
        return dcJ;
    }

    public void setDcX(String dcX) 
    {
        this.dcX = dcX;
    }

    public String getDcX() 
    {
        return dcX;
    }

    public void setDcT(String dcT) 
    {
        this.dcT = dcT;
    }

    public String getDcT() 
    {
        return dcT;
    }

    public void setDcZ(String dcZ) 
    {
        this.dcZ = dcZ;
    }

    public String getDcZ() 
    {
        return dcZ;
    }

    public void setDcD(String dcD) 
    {
        this.dcD = dcD;
    }

    public String getDcD() 
    {
        return dcD;
    }

    public void setSjjh(String sjjh) 
    {
        this.sjjh = sjjh;
    }

    public String getSjjh() 
    {
        return sjjh;
    }

    public void setSjdcs(Double sjdcs) 
    {
        this.sjdcs = sjdcs;
    }

    public Double getSjdcs() 
    {
        return sjdcs;
    }

    public void setSjjcgx(String sjjcgx) 
    {
        this.sjjcgx = sjjcgx;
    }

    public String getSjjcgx() 
    {
        return sjjcgx;
    }

    public void setSjhd(Double sjhd) 
    {
        this.sjhd = sjhd;
    }

    public Double getSjhd() 
    {
        return sjhd;
    }

    public void setSjddsd(Double sjddsd) 
    {
        this.sjddsd = sjddsd;
    }

    public Double getSjddsd() 
    {
        return sjddsd;
    }

    public void setYjjh1(String yjjh1) 
    {
        this.yjjh1 = yjjh1;
    }

    public String getYjjh1() 
    {
        return yjjh1;
    }

    public void setYjdcs1(Double yjdcs1) 
    {
        this.yjdcs1 = yjdcs1;
    }

    public Double getYjdcs1() 
    {
        return yjdcs1;
    }

    public void setYjjcgx1(String yjjcgx1) 
    {
        this.yjjcgx1 = yjjcgx1;
    }

    public String getYjjcgx1() 
    {
        return yjjcgx1;
    }

    public void setYjhyjd1(String yjhyjd1) 
    {
        this.yjhyjd1 = yjhyjd1;
    }

    public String getYjhyjd1() 
    {
        return yjhyjd1;
    }

    public void setYjddsd1(Double yjddsd1) 
    {
        this.yjddsd1 = yjddsd1;
    }

    public Double getYjddsd1() 
    {
        return yjddsd1;
    }

    public void setYjjh2(String yjjh2) 
    {
        this.yjjh2 = yjjh2;
    }

    public String getYjjh2() 
    {
        return yjjh2;
    }

    public void setYjdcs2(Double yjdcs2) 
    {
        this.yjdcs2 = yjdcs2;
    }

    public Double getYjdcs2() 
    {
        return yjdcs2;
    }

    public void setYjjcgx2(String yjjcgx2) 
    {
        this.yjjcgx2 = yjjcgx2;
    }

    public String getYjjcgx2() 
    {
        return yjjcgx2;
    }

    public void setYjhyjd2(String yjhyjd2) 
    {
        this.yjhyjd2 = yjhyjd2;
    }

    public String getYjhyjd2() 
    {
        return yjhyjd2;
    }

    public void setYjddsd2(Double yjddsd2) 
    {
        this.yjddsd2 = yjddsd2;
    }

    public Double getYjddsd2() 
    {
        return yjddsd2;
    }

    public void setCreatedBy(String createdBy) 
    {
        this.createdBy = createdBy;
    }

    public String getCreatedBy() 
    {
        return createdBy;
    }

    public void setCreatedTime(Date createdTime) 
    {
        this.createdTime = createdTime;
    }

    public Date getCreatedTime() 
    {
        return createdTime;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this,ToStringStyle.MULTI_LINE_STYLE)
            .append("id", getId())
            .append("dcJ", getDcJ())
            .append("dcX", getDcX())
            .append("dcT", getDcT())
            .append("dcZ", getDcZ())
            .append("dcD", getDcD())
            .append("sjjh", getSjjh())
            .append("sjdcs", getSjdcs())
            .append("sjjcgx", getSjjcgx())
            .append("sjhd", getSjhd())
            .append("sjddsd", getSjddsd())
            .append("yjjh1", getYjjh1())
            .append("yjdcs1", getYjdcs1())
            .append("yjjcgx1", getYjjcgx1())
            .append("yjhyjd1", getYjhyjd1())
            .append("yjddsd1", getYjddsd1())
            .append("yjjh2", getYjjh2())
            .append("yjdcs2", getYjdcs2())
            .append("yjjcgx2", getYjjcgx2())
            .append("yjhyjd2", getYjhyjd2())
            .append("yjddsd2", getYjddsd2())
            .append("createdBy", getCreatedBy())
            .append("createdTime", getCreatedTime())
            .append("updateBy", getUpdateBy())
            .append("updateTime", getUpdateTime())
            .toString();
    }
}
