package com.zjsgfa.project.zjsgfa.domain;

import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.zjsgfa.framework.aspectj.lang.annotation.Excel;
import com.zjsgfa.framework.web.domain.BaseEntity;

/**
 * 常量-风险识别字典对象 cl_fxsb
 * 
 * @author ruoyi
 * @date 2025-08-13
 */
public class ClFxsb extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** 主键 */
    private Long id;

    /** 风险类别 */
    @Excel(name = "风险类别")
    private String fxlb;

    /** 风险因素 */
    @Excel(name = "风险因素")
    private String fxys;

    /** 后果危害 */
    @Excel(name = "后果危害")
    private String hgwh;

    /** 风险描述 */
    @Excel(name = "风险描述")
    private String fxms;

    /** 判断条件 */
    @Excel(name = "判断条件")
    private String pdtj;

    /** 关键参数模板 */
    @Excel(name = "关键参数模板")
    private String gjcsmb;

    /** 工程技术措施 */
    @Excel(name = "工程技术措施")
    private String gcjscs;

    /** 钻井液措施 */
    @Excel(name = "钻井液措施")
    private String zjycs;

    /** 井控措施 */
    @Excel(name = "井控措施")
    private String jkcs;

    /** 管理措施 */
    @Excel(name = "管理措施")
    private String glcs;

    /** 特殊工具 */
    @Excel(name = "特殊工具")
    private String tsgj;

    public void setId(Long id) 
    {
        this.id = id;
    }

    public Long getId() 
    {
        return id;
    }

    public void setFxlb(String fxlb) 
    {
        this.fxlb = fxlb;
    }

    public String getFxlb() 
    {
        return fxlb;
    }

    public void setFxys(String fxys) 
    {
        this.fxys = fxys;
    }

    public String getFxys() 
    {
        return fxys;
    }

    public void setHgwh(String hgwh) 
    {
        this.hgwh = hgwh;
    }

    public String getHgwh() 
    {
        return hgwh;
    }

    public void setFxms(String fxms) 
    {
        this.fxms = fxms;
    }

    public String getFxms() 
    {
        return fxms;
    }

    public void setPdtj(String pdtj) 
    {
        this.pdtj = pdtj;
    }

    public String getPdtj() 
    {
        return pdtj;
    }

    public void setGjcsmb(String gjcsmb) 
    {
        this.gjcsmb = gjcsmb;
    }

    public String getGjcsmb() 
    {
        return gjcsmb;
    }

    public void setGcjscs(String gcjscs) 
    {
        this.gcjscs = gcjscs;
    }

    public String getGcjscs() 
    {
        return gcjscs;
    }

    public void setZjycs(String zjycs) 
    {
        this.zjycs = zjycs;
    }

    public String getZjycs() 
    {
        return zjycs;
    }

    public void setJkcs(String jkcs) 
    {
        this.jkcs = jkcs;
    }

    public String getJkcs() 
    {
        return jkcs;
    }

    public void setGlcs(String glcs) 
    {
        this.glcs = glcs;
    }

    public String getGlcs() 
    {
        return glcs;
    }

    public void setTsgj(String tsgj) 
    {
        this.tsgj = tsgj;
    }

    public String getTsgj() 
    {
        return tsgj;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this,ToStringStyle.MULTI_LINE_STYLE)
            .append("id", getId())
            .append("fxlb", getFxlb())
            .append("fxys", getFxys())
            .append("hgwh", getHgwh())
            .append("fxms", getFxms())
            .append("pdtj", getPdtj())
            .append("gjcsmb", getGjcsmb())
            .append("gcjscs", getGcjscs())
            .append("zjycs", getZjycs())
            .append("jkcs", getJkcs())
            .append("glcs", getGlcs())
            .append("tsgj", getTsgj())
            .toString();
    }
}
