package com.zjsgfa.project.zjsgfa.controller;

import java.util.List;
import javax.servlet.http.HttpServletResponse;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.zjsgfa.framework.aspectj.lang.annotation.Log;
import com.zjsgfa.framework.aspectj.lang.enums.BusinessType;
import com.zjsgfa.project.zjsgfa.domain.SjZtgjsj;
import com.zjsgfa.project.zjsgfa.service.ISjZtgjsjService;
import com.zjsgfa.framework.web.controller.BaseController;
import com.zjsgfa.framework.web.domain.AjaxResult;
import com.zjsgfa.common.utils.poi.ExcelUtil;
import com.zjsgfa.framework.web.page.TableDataInfo;

/**
 * 设计-钻头关键数据分析Controller
 * 
 * @author ruoyi
 * @date 2025-07-22
 */
@RestController
@RequestMapping("/system/sjZtgjsj")
public class SjZtgjsjController extends BaseController
{
    @Autowired
    private ISjZtgjsjService sjZtgjsjService;

    /**
     * 查询设计-钻头关键数据分析列表
     */
    //@PreAuthorize("@ss.hasPermi('system:sjZtgjsj:list')")
    @GetMapping("/list")
    public TableDataInfo list(SjZtgjsj sjZtgjsj)
    {
//        startPage();
        List<SjZtgjsj> list = sjZtgjsjService.selectSjZtgjsjList(sjZtgjsj);
        return getDataTable(list);
    }

    /**
     * 导出设计-钻头关键数据分析列表
     */
    //@PreAuthorize("@ss.hasPermi('system:sjZtgjsj:export')")
    @Log(title = "设计-钻头关键数据分析", businessType = BusinessType.EXPORT)
    @PostMapping("/export")
    public void export(HttpServletResponse response, SjZtgjsj sjZtgjsj)
    {
        List<SjZtgjsj> list = sjZtgjsjService.selectSjZtgjsjList(sjZtgjsj);
        ExcelUtil<SjZtgjsj> util = new ExcelUtil<SjZtgjsj>(SjZtgjsj.class);
        util.exportExcel(response, list, "设计-钻头关键数据分析数据");
    }

    /**
     * 获取设计-钻头关键数据分析详细信息
     */
    //@PreAuthorize("@ss.hasPermi('system:sjZtgjsj:query')")
    @GetMapping(value = "/{id}")
    public AjaxResult getInfo(@PathVariable("id") Long id)
    {
        return success(sjZtgjsjService.selectSjZtgjsjById(id));
    }

    /**
     * 新增设计-钻头关键数据分析
     */
    //@PreAuthorize("@ss.hasPermi('system:sjZtgjsj:add')")
    @Log(title = "设计-钻头关键数据分析", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody SjZtgjsj sjZtgjsj)
    {
        return toAjax(sjZtgjsjService.insertSjZtgjsj(sjZtgjsj));
    }

    /**
     * 修改设计-钻头关键数据分析
     */
    //@PreAuthorize("@ss.hasPermi('system:sjZtgjsj:edit')")
    @Log(title = "设计-钻头关键数据分析", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody SjZtgjsj sjZtgjsj)
    {
        return toAjax(sjZtgjsjService.updateSjZtgjsj(sjZtgjsj));
    }

    /**
     * 删除设计-钻头关键数据分析
     */
    //@PreAuthorize("@ss.hasPermi('system:sjZtgjsj:remove')")
    @Log(title = "设计-钻头关键数据分析", businessType = BusinessType.DELETE)
	@DeleteMapping("/{ids}")
    public AjaxResult remove(@PathVariable Long[] ids)
    {
        return toAjax(sjZtgjsjService.deleteSjZtgjsjByIds(ids));
    }
}
