package com.zjsgfa.project.zjsgfa.controller;

import java.util.List;
import javax.servlet.http.HttpServletResponse;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.zjsgfa.framework.aspectj.lang.annotation.Log;
import com.zjsgfa.framework.aspectj.lang.enums.BusinessType;
import com.zjsgfa.project.zjsgfa.domain.SjZlyqZbyq;
import com.zjsgfa.project.zjsgfa.service.ISjZlyqZbyqService;
import com.zjsgfa.framework.web.controller.BaseController;
import com.zjsgfa.framework.web.domain.AjaxResult;
import com.zjsgfa.common.utils.poi.ExcelUtil;
import com.zjsgfa.framework.web.page.TableDataInfo;

/**
 * 设计信息-中靶要求-定向井Controller
 * 
 * @author ruoyi
 * @date 2025-07-17
 */
@RestController
@RequestMapping("/system/sjZlyqZbyq")
public class SjZlyqZbyqController extends BaseController
{
    @Autowired
    private ISjZlyqZbyqService sjZlyqZbyqService;

    /**
     * 查询设计信息-中靶要求-定向井列表
     */
    //@PreAuthorize("@ss.hasPermi('system:sjZlyqZbyq:list')")
    @GetMapping("/list")
    public TableDataInfo list(SjZlyqZbyq sjZlyqZbyq)
    {
//        startPage();
        List<SjZlyqZbyq> list = sjZlyqZbyqService.selectSjZlyqZbyqList(sjZlyqZbyq);
        return getDataTable(list);
    }

    /**
     * 导出设计信息-中靶要求-定向井列表
     */
    //@PreAuthorize("@ss.hasPermi('system:sjZlyqZbyq:export')")
    @Log(title = "设计信息-中靶要求-定向井", businessType = BusinessType.EXPORT)
    @PostMapping("/export")
    public void export(HttpServletResponse response, SjZlyqZbyq sjZlyqZbyq)
    {
        List<SjZlyqZbyq> list = sjZlyqZbyqService.selectSjZlyqZbyqList(sjZlyqZbyq);
        ExcelUtil<SjZlyqZbyq> util = new ExcelUtil<SjZlyqZbyq>(SjZlyqZbyq.class);
        util.exportExcel(response, list, "设计信息-中靶要求-定向井数据");
    }

    /**
     * 获取设计信息-中靶要求-定向井详细信息
     */
    //@PreAuthorize("@ss.hasPermi('system:sjZlyqZbyq:query')")
    @GetMapping(value = "/{id}")
    public AjaxResult getInfo(@PathVariable("id") Long id)
    {
        return success(sjZlyqZbyqService.selectSjZlyqZbyqById(id));
    }

    /**
     * 新增设计信息-中靶要求-定向井
     */
    //@PreAuthorize("@ss.hasPermi('system:sjZlyqZbyq:add')")
    @Log(title = "设计信息-中靶要求-定向井", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody SjZlyqZbyq sjZlyqZbyq)
    {
        return toAjax(sjZlyqZbyqService.insertSjZlyqZbyq(sjZlyqZbyq));
    }

    /**
     * 修改设计信息-中靶要求-定向井
     */
    //@PreAuthorize("@ss.hasPermi('system:sjZlyqZbyq:edit')")
    @Log(title = "设计信息-中靶要求-定向井", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody SjZlyqZbyq sjZlyqZbyq)
    {
        return toAjax(sjZlyqZbyqService.updateSjZlyqZbyq(sjZlyqZbyq));
    }

    /**
     * 删除设计信息-中靶要求-定向井
     */
    //@PreAuthorize("@ss.hasPermi('system:sjZlyqZbyq:remove')")
    @Log(title = "设计信息-中靶要求-定向井", businessType = BusinessType.DELETE)
	@DeleteMapping("/{ids}")
    public AjaxResult remove(@PathVariable Long[] ids)
    {
        return toAjax(sjZlyqZbyqService.deleteSjZlyqZbyqByIds(ids));
    }
}
