package com.zjsgfa.project.zjsgfa.controller;

import java.util.List;
import javax.servlet.http.HttpServletResponse;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.zjsgfa.framework.aspectj.lang.annotation.Log;
import com.zjsgfa.framework.aspectj.lang.enums.BusinessType;
import com.zjsgfa.project.zjsgfa.domain.SjZjyCljl;
import com.zjsgfa.project.zjsgfa.service.ISjZjyCljlService;
import com.zjsgfa.framework.web.controller.BaseController;
import com.zjsgfa.framework.web.domain.AjaxResult;
import com.zjsgfa.common.utils.poi.ExcelUtil;
import com.zjsgfa.framework.web.page.TableDataInfo;

/**
 * 设计信息-钻井液材料加量Controller
 * 
 * @author ruoyi
 * @date 2025-07-17
 */
@RestController
@RequestMapping("/system/sjZjyCljl")
public class SjZjyCljlController extends BaseController
{
    @Autowired
    private ISjZjyCljlService sjZjyCljlService;

    /**
     * 查询设计信息-钻井液材料加量列表
     */
    //@PreAuthorize("@ss.hasPermi('system:sjZjyCljl:list')")
    @GetMapping("/list")
    public TableDataInfo list(SjZjyCljl sjZjyCljl)
    {
//        startPage();
        List<SjZjyCljl> list = sjZjyCljlService.selectSjZjyCljlList(sjZjyCljl);
        return getDataTable(list);
    }

    /**
     * 导出设计信息-钻井液材料加量列表
     */
    //@PreAuthorize("@ss.hasPermi('system:sjZjyCljl:export')")
    @Log(title = "设计信息-钻井液材料加量", businessType = BusinessType.EXPORT)
    @PostMapping("/export")
    public void export(HttpServletResponse response, SjZjyCljl sjZjyCljl)
    {
        List<SjZjyCljl> list = sjZjyCljlService.selectSjZjyCljlList(sjZjyCljl);
        ExcelUtil<SjZjyCljl> util = new ExcelUtil<SjZjyCljl>(SjZjyCljl.class);
        util.exportExcel(response, list, "设计信息-钻井液材料加量数据");
    }

    /**
     * 获取设计信息-钻井液材料加量详细信息
     */
    //@PreAuthorize("@ss.hasPermi('system:sjZjyCljl:query')")
    @GetMapping(value = "/{id}")
    public AjaxResult getInfo(@PathVariable("id") Long id)
    {
        return success(sjZjyCljlService.selectSjZjyCljlById(id));
    }

    /**
     * 新增设计信息-钻井液材料加量
     */
    //@PreAuthorize("@ss.hasPermi('system:sjZjyCljl:add')")
    @Log(title = "设计信息-钻井液材料加量", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody SjZjyCljl sjZjyCljl)
    {
        return toAjax(sjZjyCljlService.insertSjZjyCljl(sjZjyCljl));
    }

    /**
     * 修改设计信息-钻井液材料加量
     */
    //@PreAuthorize("@ss.hasPermi('system:sjZjyCljl:edit')")
    @Log(title = "设计信息-钻井液材料加量", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody SjZjyCljl sjZjyCljl)
    {
        return toAjax(sjZjyCljlService.updateSjZjyCljl(sjZjyCljl));
    }

    /**
     * 删除设计信息-钻井液材料加量
     */
    //@PreAuthorize("@ss.hasPermi('system:sjZjyCljl:remove')")
    @Log(title = "设计信息-钻井液材料加量", businessType = BusinessType.DELETE)
	@DeleteMapping("/{ids}")
    public AjaxResult remove(@PathVariable Long[] ids)
    {
        return toAjax(sjZjyCljlService.deleteSjZjyCljlByIds(ids));
    }
}
