package com.zjsgfa.project.zjsgfa.controller;

import java.util.List;
import javax.servlet.http.HttpServletResponse;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.zjsgfa.framework.aspectj.lang.annotation.Log;
import com.zjsgfa.framework.aspectj.lang.enums.BusinessType;
import com.zjsgfa.project.zjsgfa.domain.SjTgTgqdjh;
import com.zjsgfa.project.zjsgfa.service.ISjTgTgqdjhService;
import com.zjsgfa.framework.web.controller.BaseController;
import com.zjsgfa.framework.web.domain.AjaxResult;
import com.zjsgfa.common.utils.poi.ExcelUtil;
import com.zjsgfa.framework.web.page.TableDataInfo;

/**
 * 设计信息-套管柱强度校核Controller
 * 
 * @author ruoyi
 * @date 2025-07-17
 */
@RestController
@RequestMapping("/system/sjTgTgqdjh")
public class SjTgTgqdjhController extends BaseController
{
    @Autowired
    private ISjTgTgqdjhService sjTgTgqdjhService;

    /**
     * 查询设计信息-套管柱强度校核列表
     */
    ////@PreAuthorize("@ss.hasPermi('system:sjTgTgqdjh:list')")
    @GetMapping("/list")
    public TableDataInfo list(SjTgTgqdjh sjTgTgqdjh)
    {
//        startPage();
        List<SjTgTgqdjh> list = sjTgTgqdjhService.selectSjTgTgqdjhList(sjTgTgqdjh);
        return getDataTable(list);
    }

    /**
     * 导出设计信息-套管柱强度校核列表
     */
    ////@PreAuthorize("@ss.hasPermi('system:sjTgTgqdjh:export')")
    @Log(title = "设计信息-套管柱强度校核", businessType = BusinessType.EXPORT)
    @PostMapping("/export")
    public void export(HttpServletResponse response, SjTgTgqdjh sjTgTgqdjh)
    {
        List<SjTgTgqdjh> list = sjTgTgqdjhService.selectSjTgTgqdjhList(sjTgTgqdjh);
        ExcelUtil<SjTgTgqdjh> util = new ExcelUtil<SjTgTgqdjh>(SjTgTgqdjh.class);
        util.exportExcel(response, list, "设计信息-套管柱强度校核数据");
    }

    /**
     * 获取设计信息-套管柱强度校核详细信息
     */
    ////@PreAuthorize("@ss.hasPermi('system:sjTgTgqdjh:query')")
    @GetMapping(value = "/{id}")
    public AjaxResult getInfo(@PathVariable("id") Long id)
    {
        return success(sjTgTgqdjhService.selectSjTgTgqdjhById(id));
    }

    /**
     * 新增设计信息-套管柱强度校核
     */
    ////@PreAuthorize("@ss.hasPermi('system:sjTgTgqdjh:add')")
    @Log(title = "设计信息-套管柱强度校核", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody SjTgTgqdjh sjTgTgqdjh)
    {
        return toAjax(sjTgTgqdjhService.insertSjTgTgqdjh(sjTgTgqdjh));
    }

    /**
     * 修改设计信息-套管柱强度校核
     */
    ////@PreAuthorize("@ss.hasPermi('system:sjTgTgqdjh:edit')")
    @Log(title = "设计信息-套管柱强度校核", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody SjTgTgqdjh sjTgTgqdjh)
    {
        return toAjax(sjTgTgqdjhService.updateSjTgTgqdjh(sjTgTgqdjh));
    }

    /**
     * 删除设计信息-套管柱强度校核
     */
    ////@PreAuthorize("@ss.hasPermi('system:sjTgTgqdjh:remove')")
    @Log(title = "设计信息-套管柱强度校核", businessType = BusinessType.DELETE)
	@DeleteMapping("/{ids}")
    public AjaxResult remove(@PathVariable Long[] ids)
    {
        return toAjax(sjTgTgqdjhService.deleteSjTgTgqdjhByIds(ids));
    }
}
