package com.zjsgfa.project.zjsgfa.controller;

import java.util.List;
import javax.servlet.http.HttpServletResponse;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.zjsgfa.framework.aspectj.lang.annotation.Log;
import com.zjsgfa.framework.aspectj.lang.enums.BusinessType;
import com.zjsgfa.project.zjsgfa.domain.SjSggyZjzhcs;
import com.zjsgfa.project.zjsgfa.service.ISjSggyZjzhcsService;
import com.zjsgfa.framework.web.controller.BaseController;
import com.zjsgfa.framework.web.domain.AjaxResult;
import com.zjsgfa.common.utils.poi.ExcelUtil;
import com.zjsgfa.framework.web.page.TableDataInfo;

/**
 * 设计-钻具组合参数Controller
 * 
 * @author ruoyi
 * @date 2025-08-18
 */
@RestController
@RequestMapping("/system/sjSggyZjzhcs")
public class SjSggyZjzhcsController extends BaseController
{
    @Autowired
    private ISjSggyZjzhcsService sjSggyZjzhcsService;

    /**
     * 查询设计-钻具组合参数列表
     */
    //@PreAuthorize("@ss.hasPermi('system:sjSggyZjzhcs:list')")
    @GetMapping("/list")
    public TableDataInfo list(SjSggyZjzhcs sjSggyZjzhcs)
    {
        startPage();
        List<SjSggyZjzhcs> list = sjSggyZjzhcsService.selectSjSggyZjzhcsList(sjSggyZjzhcs);
        return getDataTable(list);
    }

    /**
     * 导出设计-钻具组合参数列表
     */
    //@PreAuthorize("@ss.hasPermi('system:sjSggyZjzhcs:export')")
    @Log(title = "设计-钻具组合参数", businessType = BusinessType.EXPORT)
    @PostMapping("/export")
    public void export(HttpServletResponse response, SjSggyZjzhcs sjSggyZjzhcs)
    {
        List<SjSggyZjzhcs> list = sjSggyZjzhcsService.selectSjSggyZjzhcsList(sjSggyZjzhcs);
        ExcelUtil<SjSggyZjzhcs> util = new ExcelUtil<SjSggyZjzhcs>(SjSggyZjzhcs.class);
        util.exportExcel(response, list, "设计-钻具组合参数数据");
    }

    /**
     * 获取设计-钻具组合参数详细信息
     */
    //@PreAuthorize("@ss.hasPermi('system:sjSggyZjzhcs:query')")
    @GetMapping(value = "/{id}")
    public AjaxResult getInfo(@PathVariable("id") Long id)
    {
        return success(sjSggyZjzhcsService.selectSjSggyZjzhcsById(id));
    }

    /**
     * 新增设计-钻具组合参数
     */
    //@PreAuthorize("@ss.hasPermi('system:sjSggyZjzhcs:add')")
    @Log(title = "设计-钻具组合参数", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody SjSggyZjzhcs sjSggyZjzhcs)
    {
        return toAjax(sjSggyZjzhcsService.insertSjSggyZjzhcs(sjSggyZjzhcs));
    }

    /**
     * 修改设计-钻具组合参数
     */
    //@PreAuthorize("@ss.hasPermi('system:sjSggyZjzhcs:edit')")
    @Log(title = "设计-钻具组合参数", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody SjSggyZjzhcs sjSggyZjzhcs)
    {
        return toAjax(sjSggyZjzhcsService.updateSjSggyZjzhcs(sjSggyZjzhcs));
    }

    /**
     * 删除设计-钻具组合参数
     */
    //@PreAuthorize("@ss.hasPermi('system:sjSggyZjzhcs:remove')")
    @Log(title = "设计-钻具组合参数", businessType = BusinessType.DELETE)
	@DeleteMapping("/{ids}")
    public AjaxResult remove(@PathVariable Long[] ids)
    {
        return toAjax(sjSggyZjzhcsService.deleteSjSggyZjzhcsByIds(ids));
    }
}
