package com.zjsgfa.project.zjsgfa.controller;

import java.util.Map;
import javax.servlet.http.HttpServletResponse;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.zjsgfa.framework.aspectj.lang.annotation.Log;
import com.zjsgfa.framework.aspectj.lang.enums.BusinessType;
import com.zjsgfa.project.zjsgfa.domain.SjSggyZjyFdxnb;
import com.zjsgfa.project.zjsgfa.service.ISjSggyZjyFdxnbService;
import com.zjsgfa.framework.web.controller.BaseController;
import com.zjsgfa.framework.web.domain.AjaxResult;

/**
 * 设计信息-施工概要-分段钻井液性能设计Controller
 * 
 * @author ruoyi
 * @date 2025-08-20
 */
@RestController
@RequestMapping("/system/sjSggyZjyFdxnb")
public class SjSggyZjyFdxnbController extends BaseController
{
    @Autowired
    private ISjSggyZjyFdxnbService sjSggyZjyFdxnbService;

    /**
     * 查询设计信息-施工概要-分段钻井液性能设计列表
     */
   //@PreAuthorize("@ss.hasPermi('system:sjSggyZjyFdxnb:list')")
    @GetMapping("/list")
    public AjaxResult list(SjSggyZjyFdxnb sjSggyZjyFdxnb)
    {
//        startPage();
        Map<String, Object> list = sjSggyZjyFdxnbService.selectSjSggyZjyFdxnbList(sjSggyZjyFdxnb);
        return AjaxResult.success(list);
    }

    /**
     * 导出设计信息-施工概要-分段钻井液性能设计列表
     */
   //@PreAuthorize("@ss.hasPermi('system:sjSggyZjyFdxnb:export')")
    @Log(title = "设计信息-施工概要-分段钻井液性能设计", businessType = BusinessType.EXPORT)
    @PostMapping("/export")
    public void export(HttpServletResponse response, SjSggyZjyFdxnb sjSggyZjyFdxnb)
    {
//        List<SjSggyZjyFdxnb> list = sjSggyZjyFdxnbService.selectSjSggyZjyFdxnbList(sjSggyZjyFdxnb);
//        ExcelUtil<SjSggyZjyFdxnb> util = new ExcelUtil<SjSggyZjyFdxnb>(SjSggyZjyFdxnb.class);
//        util.exportExcel(response, list, "设计信息-施工概要-分段钻井液性能设计数据");
    }

    /**
     * 获取设计信息-施工概要-分段钻井液性能设计详细信息
     */
   //@PreAuthorize("@ss.hasPermi('system:sjSggyZjyFdxnb:query')")
    @GetMapping(value = "/{id}")
    public AjaxResult getInfo(@PathVariable("id") Long id)
    {
        return success(sjSggyZjyFdxnbService.selectSjSggyZjyFdxnbById(id));
    }

    /**
     * 新增设计信息-施工概要-分段钻井液性能设计
     */
   //@PreAuthorize("@ss.hasPermi('system:sjSggyZjyFdxnb:add')")
    @Log(title = "设计信息-施工概要-分段钻井液性能设计", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody SjSggyZjyFdxnb sjSggyZjyFdxnb)
    {
        return toAjax(sjSggyZjyFdxnbService.insertSjSggyZjyFdxnb(sjSggyZjyFdxnb));
    }

    /**
     * 修改设计信息-施工概要-分段钻井液性能设计
     */
   //@PreAuthorize("@ss.hasPermi('system:sjSggyZjyFdxnb:edit')")
    @Log(title = "设计信息-施工概要-分段钻井液性能设计", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody SjSggyZjyFdxnb sjSggyZjyFdxnb)
    {
        return toAjax(sjSggyZjyFdxnbService.updateSjSggyZjyFdxnb(sjSggyZjyFdxnb));
    }

    /**
     * 删除设计信息-施工概要-分段钻井液性能设计
     */
   //@PreAuthorize("@ss.hasPermi('system:sjSggyZjyFdxnb:remove')")
    @Log(title = "设计信息-施工概要-分段钻井液性能设计", businessType = BusinessType.DELETE)
	@DeleteMapping("/{ids}")
    public AjaxResult remove(@PathVariable Long[] ids)
    {
        return toAjax(sjSggyZjyFdxnbService.deleteSjSggyZjyFdxnbByIds(ids));
    }
}
