package com.zjsgfa.project.zjsgfa.controller;

import java.util.List;
import javax.servlet.http.HttpServletResponse;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.zjsgfa.framework.aspectj.lang.annotation.Log;
import com.zjsgfa.framework.aspectj.lang.enums.BusinessType;
import com.zjsgfa.project.zjsgfa.domain.SjSggyZjyFdsj;
import com.zjsgfa.project.zjsgfa.service.ISjSggyZjyFdsjService;
import com.zjsgfa.framework.web.controller.BaseController;
import com.zjsgfa.framework.web.domain.AjaxResult;
import com.zjsgfa.common.utils.poi.ExcelUtil;
import com.zjsgfa.framework.web.page.TableDataInfo;

/**
 * 设计信息-施工概要-分段钻井液设计Controller
 * 
 * @author ruoyi
 * @date 2025-08-20
 */
@RestController
@RequestMapping("/system/sjSggyZjyFdsj")
public class SjSggyZjyFdsjController extends BaseController
{
    @Autowired
    private ISjSggyZjyFdsjService sjSggyZjyFdsjService;

    /**
     * 查询设计信息-施工概要-分段钻井液设计列表
     */
    //@PreAuthorize("@ss.hasPermi('system:sjSggyZjyFdsj:list')")
    @GetMapping("/list")
    public TableDataInfo list(SjSggyZjyFdsj sjSggyZjyFdsj)
    {
        startPage();
        List<SjSggyZjyFdsj> list = sjSggyZjyFdsjService.selectSjSggyZjyFdsjList(sjSggyZjyFdsj);
        return getDataTable(list);
    }

    /**
     * 导出设计信息-施工概要-分段钻井液设计列表
     */
    //@PreAuthorize("@ss.hasPermi('system:sjSggyZjyFdsj:export')")
    @Log(title = "设计信息-施工概要-分段钻井液设计", businessType = BusinessType.EXPORT)
    @PostMapping("/export")
    public void export(HttpServletResponse response, SjSggyZjyFdsj sjSggyZjyFdsj)
    {
        List<SjSggyZjyFdsj> list = sjSggyZjyFdsjService.selectSjSggyZjyFdsjList(sjSggyZjyFdsj);
        ExcelUtil<SjSggyZjyFdsj> util = new ExcelUtil<SjSggyZjyFdsj>(SjSggyZjyFdsj.class);
        util.exportExcel(response, list, "设计信息-施工概要-分段钻井液设计数据");
    }

    /**
     * 获取设计信息-施工概要-分段钻井液设计详细信息
     */
    //@PreAuthorize("@ss.hasPermi('system:sjSggyZjyFdsj:query')")
    @GetMapping(value = "/{id}")
    public AjaxResult getInfo(@PathVariable("id") Long id)
    {
        return success(sjSggyZjyFdsjService.selectSjSggyZjyFdsjById(id));
    }

    /**
     * 新增设计信息-施工概要-分段钻井液设计
     */
    //@PreAuthorize("@ss.hasPermi('system:sjSggyZjyFdsj:add')")
    @Log(title = "设计信息-施工概要-分段钻井液设计", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody SjSggyZjyFdsj sjSggyZjyFdsj)
    {
        return toAjax(sjSggyZjyFdsjService.insertSjSggyZjyFdsj(sjSggyZjyFdsj));
    }

    /**
     * 修改设计信息-施工概要-分段钻井液设计
     */
    //@PreAuthorize("@ss.hasPermi('system:sjSggyZjyFdsj:edit')")
    @Log(title = "设计信息-施工概要-分段钻井液设计", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody SjSggyZjyFdsj sjSggyZjyFdsj)
    {
        return toAjax(sjSggyZjyFdsjService.updateSjSggyZjyFdsj(sjSggyZjyFdsj));
    }

    /**
     * 删除设计信息-施工概要-分段钻井液设计
     */
    //@PreAuthorize("@ss.hasPermi('system:sjSggyZjyFdsj:remove')")
    @Log(title = "设计信息-施工概要-分段钻井液设计", businessType = BusinessType.DELETE)
	@DeleteMapping("/{ids}")
    public AjaxResult remove(@PathVariable Long[] ids)
    {
        return toAjax(sjSggyZjyFdsjService.deleteSjSggyZjyFdsjByIds(ids));
    }
}
