package com.zjsgfa.project.zjsgfa.controller;

import java.util.List;
import javax.servlet.http.HttpServletResponse;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.zjsgfa.framework.aspectj.lang.annotation.Log;
import com.zjsgfa.framework.aspectj.lang.enums.BusinessType;
import com.zjsgfa.project.zjsgfa.domain.SjLjtjzt;
import com.zjsgfa.project.zjsgfa.service.ISjLjtjztService;
import com.zjsgfa.framework.web.controller.BaseController;
import com.zjsgfa.framework.web.domain.AjaxResult;
import com.zjsgfa.common.utils.poi.ExcelUtil;
import com.zjsgfa.framework.web.page.TableDataInfo;

/**
 * 设计-邻井推荐钻头Controller
 * 
 * @author ruoyi
 * @date 2025-08-18
 */
@RestController
@RequestMapping("/system/sjLjtjzt")
public class SjLjtjztController extends BaseController
{
    @Autowired
    private ISjLjtjztService sjLjtjztService;

    /**
     * 查询设计-邻井推荐钻头列表
     */
    //@PreAuthorize("@ss.hasPermi('system:sjLjtjzt:list')")
    @GetMapping("/list")
    public TableDataInfo list(SjLjtjzt sjLjtjzt)
    {
        startPage();
        List<SjLjtjzt> list = sjLjtjztService.selectSjLjtjztList(sjLjtjzt);
        return getDataTable(list);
    }

    /**
     * 导出设计-邻井推荐钻头列表
     */
    //@PreAuthorize("@ss.hasPermi('system:sjLjtjzt:export')")
    @Log(title = "设计-邻井推荐钻头", businessType = BusinessType.EXPORT)
    @PostMapping("/export")
    public void export(HttpServletResponse response, SjLjtjzt sjLjtjzt)
    {
        List<SjLjtjzt> list = sjLjtjztService.selectSjLjtjztList(sjLjtjzt);
        ExcelUtil<SjLjtjzt> util = new ExcelUtil<SjLjtjzt>(SjLjtjzt.class);
        util.exportExcel(response, list, "设计-邻井推荐钻头数据");
    }

    /**
     * 获取设计-邻井推荐钻头详细信息
     */
    //@PreAuthorize("@ss.hasPermi('system:sjLjtjzt:query')")
    @GetMapping(value = "/{id}")
    public AjaxResult getInfo(@PathVariable("id") Long id)
    {
        return success(sjLjtjztService.selectSjLjtjztById(id));
    }

    /**
     * 新增设计-邻井推荐钻头
     */
    //@PreAuthorize("@ss.hasPermi('system:sjLjtjzt:add')")
    @Log(title = "设计-邻井推荐钻头", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody SjLjtjzt sjLjtjzt)
    {
        return toAjax(sjLjtjztService.insertSjLjtjzt(sjLjtjzt));
    }

    /**
     * 修改设计-邻井推荐钻头
     */
    //@PreAuthorize("@ss.hasPermi('system:sjLjtjzt:edit')")
    @Log(title = "设计-邻井推荐钻头", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody SjLjtjzt sjLjtjzt)
    {
        return toAjax(sjLjtjztService.updateSjLjtjzt(sjLjtjzt));
    }

    /**
     * 删除设计-邻井推荐钻头
     */
    //@PreAuthorize("@ss.hasPermi('system:sjLjtjzt:remove')")
    @Log(title = "设计-邻井推荐钻头", businessType = BusinessType.DELETE)
	@DeleteMapping("/{ids}")
    public AjaxResult remove(@PathVariable Long[] ids)
    {
        return toAjax(sjLjtjztService.deleteSjLjtjztByIds(ids));
    }
}
