package com.zjsgfa.project.zjsgfa.controller;

import java.util.List;
import javax.servlet.http.HttpServletResponse;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.zjsgfa.framework.aspectj.lang.annotation.Log;
import com.zjsgfa.framework.aspectj.lang.enums.BusinessType;
import com.zjsgfa.project.zjsgfa.domain.SjJygjgdsj;
import com.zjsgfa.project.zjsgfa.service.ISjJygjgdsjService;
import com.zjsgfa.framework.web.controller.BaseController;
import com.zjsgfa.framework.web.domain.AjaxResult;
import com.zjsgfa.common.utils.poi.ExcelUtil;
import com.zjsgfa.framework.web.page.TableDataInfo;

/**
 * 设计-轨道设计Controller
 * 
 * @author ruoyi
 * @date 2025-08-14
 */
@RestController
@RequestMapping("/system/sjJygjgdsj")
public class SjJygjgdsjController extends BaseController
{
    @Autowired
    private ISjJygjgdsjService sjJygjgdsjService;

    /**
     * 查询设计-轨道设计列表
     */
   //@PreAuthorize("@ss.hasPermi('system:sjJygjgdsj:list')")
    @GetMapping("/list")
    public TableDataInfo list(SjJygjgdsj sjJygjgdsj)
    {
//        startPage();
        List<SjJygjgdsj> list = sjJygjgdsjService.selectSjJygjgdsjList(sjJygjgdsj);
        return getDataTable(list);
    }

    /**
     * 导出设计-轨道设计列表
     */
   //@PreAuthorize("@ss.hasPermi('system:sjJygjgdsj:export')")
    @Log(title = "设计-轨道设计", businessType = BusinessType.EXPORT)
    @PostMapping("/export")
    public void export(HttpServletResponse response, SjJygjgdsj sjJygjgdsj)
    {
        List<SjJygjgdsj> list = sjJygjgdsjService.selectSjJygjgdsjList(sjJygjgdsj);
        ExcelUtil<SjJygjgdsj> util = new ExcelUtil<SjJygjgdsj>(SjJygjgdsj.class);
        util.exportExcel(response, list, "设计-轨道设计数据");
    }

    /**
     * 获取设计-轨道设计详细信息
     */
   //@PreAuthorize("@ss.hasPermi('system:sjJygjgdsj:query')")
    @GetMapping(value = "/{id}")
    public AjaxResult getInfo(@PathVariable("id") Long id)
    {
        return success(sjJygjgdsjService.selectSjJygjgdsjById(id));
    }

    /**
     * 新增设计-轨道设计
     */
   //@PreAuthorize("@ss.hasPermi('system:sjJygjgdsj:add')")
    @Log(title = "设计-轨道设计", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody SjJygjgdsj sjJygjgdsj)
    {
        return toAjax(sjJygjgdsjService.insertSjJygjgdsj(sjJygjgdsj));
    }

    /**
     * 修改设计-轨道设计
     */
   //@PreAuthorize("@ss.hasPermi('system:sjJygjgdsj:edit')")
    @Log(title = "设计-轨道设计", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody SjJygjgdsj sjJygjgdsj)
    {
        return toAjax(sjJygjgdsjService.updateSjJygjgdsj(sjJygjgdsj));
    }

    /**
     * 删除设计-轨道设计
     */
   //@PreAuthorize("@ss.hasPermi('system:sjJygjgdsj:remove')")
    @Log(title = "设计-轨道设计", businessType = BusinessType.DELETE)
	@DeleteMapping("/{ids}")
    public AjaxResult remove(@PathVariable Long[] ids)
    {
        return toAjax(sjJygjgdsjService.deleteSjJygjgdsjByIds(ids));
    }
}
