package com.zjsgfa.project.zjsgfa.controller;

import java.util.List;
import javax.servlet.http.HttpServletResponse;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.zjsgfa.framework.aspectj.lang.annotation.Log;
import com.zjsgfa.framework.aspectj.lang.enums.BusinessType;
import com.zjsgfa.project.zjsgfa.domain.SjGztz;
import com.zjsgfa.project.zjsgfa.service.ISjGztzService;
import com.zjsgfa.framework.web.controller.BaseController;
import com.zjsgfa.framework.web.domain.AjaxResult;
import com.zjsgfa.common.utils.poi.ExcelUtil;
import com.zjsgfa.framework.web.page.TableDataInfo;

/**
 * 设计信息-构造特征Controller
 * 
 * @author ruoyi
 * @date 2025-07-22
 */
@RestController
@RequestMapping("/system/sjGztz")
public class SjGztzController extends BaseController
{
    @Autowired
    private ISjGztzService sjGztzService;

    /**
     * 查询设计信息-构造特征列表
     */
    //@PreAuthorize("@ss.hasPermi('system:sjGztz:list')")
    @GetMapping("/list")
    public TableDataInfo list(SjGztz sjGztz)
    {
        startPage();
        List<SjGztz> list = sjGztzService.selectSjGztzList(sjGztz);
        return getDataTable(list);
    }

    /**
     * 导出设计信息-构造特征列表
     */
    //@PreAuthorize("@ss.hasPermi('system:sjGztz:export')")
    @Log(title = "设计信息-构造特征", businessType = BusinessType.EXPORT)
    @PostMapping("/export")
    public void export(HttpServletResponse response, SjGztz sjGztz)
    {
        List<SjGztz> list = sjGztzService.selectSjGztzList(sjGztz);
        ExcelUtil<SjGztz> util = new ExcelUtil<SjGztz>(SjGztz.class);
        util.exportExcel(response, list, "设计信息-构造特征数据");
    }

    /**
     * 获取设计信息-构造特征详细信息
     */
    //@PreAuthorize("@ss.hasPermi('system:sjGztz:query')")
    @GetMapping(value = "/{id}")
    public AjaxResult getInfo(@PathVariable("id") Long id)
    {
        return success(sjGztzService.selectSjGztzById(id));
    }

    /**
     * 新增设计信息-构造特征
     */
    //@PreAuthorize("@ss.hasPermi('system:sjGztz:add')")
    @Log(title = "设计信息-构造特征", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody SjGztz sjGztz)
    {
        return toAjax(sjGztzService.insertSjGztz(sjGztz));
    }

    /**
     * 修改设计信息-构造特征
     */
    //@PreAuthorize("@ss.hasPermi('system:sjGztz:edit')")
    @Log(title = "设计信息-构造特征", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody SjGztz sjGztz)
    {
        return toAjax(sjGztzService.updateSjGztz(sjGztz));
    }

    /**
     * 删除设计信息-构造特征
     */
    //@PreAuthorize("@ss.hasPermi('system:sjGztz:remove')")
    @Log(title = "设计信息-构造特征", businessType = BusinessType.DELETE)
	@DeleteMapping("/{ids}")
    public AjaxResult remove(@PathVariable Long[] ids)
    {
        return toAjax(sjGztzService.deleteSjGztzByIds(ids));
    }
}
