package com.zjsgfa.project.zjsgfa.controller;

import java.util.List;
import javax.servlet.http.HttpServletResponse;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.zjsgfa.framework.aspectj.lang.annotation.Log;
import com.zjsgfa.framework.aspectj.lang.enums.BusinessType;
import com.zjsgfa.project.zjsgfa.domain.SjFdsgcs;
import com.zjsgfa.project.zjsgfa.service.ISjFdsgcsService;
import com.zjsgfa.framework.web.controller.BaseController;
import com.zjsgfa.framework.web.domain.AjaxResult;
import com.zjsgfa.common.utils.poi.ExcelUtil;
import com.zjsgfa.framework.web.page.TableDataInfo;

/**
 * 设计-分段施工措施Controller
 * 
 * @author ruoyi
 * @date 2025-08-06
 */
@RestController
@RequestMapping("/system/sjFdsgcs")
public class SjFdsgcsController extends BaseController
{
    @Autowired
    private ISjFdsgcsService sjFdsgcsService;

    /**
     * 查询设计-分段施工措施列表
     */
    //@PreAuthorize("@ss.hasPermi('system:sjFdsgcs:list')")
    @GetMapping("/list")
    public TableDataInfo list(SjFdsgcs sjFdsgcs)
    {
//        startPage();
        List<SjFdsgcs> list = sjFdsgcsService.selectSjFdsgcsList(sjFdsgcs);
        return getDataTable(list);
    }
    @GetMapping("/getInfo")
    public AjaxResult getInfo(SjFdsgcs sjFdsgcs)
    {
//        startPage();
        List<SjFdsgcs> list = sjFdsgcsService.selectSjFdsgcsList(sjFdsgcs);
        if(list.size()>0){
            SjFdsgcs sjFdsgcs1 = list.get(0);
            return AjaxResult.success(sjFdsgcs1);
        }else {
            return AjaxResult.success(new SjFdsgcs());
        }
    }
    /**
     * 导出设计-分段施工措施列表
     */
    //@PreAuthorize("@ss.hasPermi('system:sjFdsgcs:export')")
    @Log(title = "设计-分段施工措施", businessType = BusinessType.EXPORT)
    @PostMapping("/export")
    public void export(HttpServletResponse response, SjFdsgcs sjFdsgcs)
    {
        List<SjFdsgcs> list = sjFdsgcsService.selectSjFdsgcsList(sjFdsgcs);
        ExcelUtil<SjFdsgcs> util = new ExcelUtil<SjFdsgcs>(SjFdsgcs.class);
        util.exportExcel(response, list, "设计-分段施工措施数据");
    }

    /**
     * 获取设计-分段施工措施详细信息
     */
    //@PreAuthorize("@ss.hasPermi('system:sjFdsgcs:query')")
    @GetMapping(value = "/{id}")
    public AjaxResult getInfo(@PathVariable("id") Long id)
    {
        return success(sjFdsgcsService.selectSjFdsgcsById(id));
    }

    /**
     * 新增设计-分段施工措施
     */
    //@PreAuthorize("@ss.hasPermi('system:sjFdsgcs:add')")
    @Log(title = "设计-分段施工措施", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody SjFdsgcs sjFdsgcs)
    {
        return toAjax(sjFdsgcsService.insertSjFdsgcs(sjFdsgcs));
    }

    /**
     * 修改设计-分段施工措施
     */
    //@PreAuthorize("@ss.hasPermi('system:sjFdsgcs:edit')")
    @Log(title = "设计-分段施工措施", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody SjFdsgcs sjFdsgcs)
    {
        return toAjax(sjFdsgcsService.updateSjFdsgcs(sjFdsgcs));
    }

    /**
     * 删除设计-分段施工措施
     */
    //@PreAuthorize("@ss.hasPermi('system:sjFdsgcs:remove')")
    @Log(title = "设计-分段施工措施", businessType = BusinessType.DELETE)
	@DeleteMapping("/{ids}")
    public AjaxResult remove(@PathVariable Long[] ids)
    {
        return toAjax(sjFdsgcsService.deleteSjFdsgcsByIds(ids));
    }


    @GetMapping("/jsfdsgcs")
    public void jsfdsgcs(SjFdsgcs sjFdsgcs)
    {
        sjFdsgcsService.jsfdsgcs(sjFdsgcs);
    }

}
