package com.zjsgfa.project.zjsgfa.controller;

import java.util.List;
import javax.servlet.http.HttpServletResponse;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.zjsgfa.framework.aspectj.lang.annotation.Log;
import com.zjsgfa.framework.aspectj.lang.enums.BusinessType;
import com.zjsgfa.project.zjsgfa.domain.SjDcfxDzfc;
import com.zjsgfa.project.zjsgfa.service.ISjDcfxDzfcService;
import com.zjsgfa.framework.web.controller.BaseController;
import com.zjsgfa.framework.web.domain.AjaxResult;
import com.zjsgfa.common.utils.poi.ExcelUtil;
import com.zjsgfa.framework.web.page.TableDataInfo;

/**
 * 设计-地层分析—地质分层Controller
 * 
 * @author ruoyi
 * @date 2025-07-28
 */
@RestController
@RequestMapping("/system/sjDcfxDzfc")
public class SjDcfxDzfcController extends BaseController
{
    @Autowired
    private ISjDcfxDzfcService sjDcfxDzfcService;

    /**
     * 查询设计-地层分析—地质分层列表
     */
    //@PreAuthorize("@ss.hasPermi('system:sjDcfxDzfc:list')")
    @GetMapping("/list")
    public TableDataInfo list(SjDcfxDzfc sjDcfxDzfc)
    {
//        startPage();
        List<SjDcfxDzfc> list = sjDcfxDzfcService.selectSjDcfxDzfcList(sjDcfxDzfc);
        return getDataTable(list);
    }

    /**
     * 导出设计-地层分析—地质分层列表
     */
    //@PreAuthorize("@ss.hasPermi('system:sjDcfxDzfc:export')")
    @Log(title = "设计-地层分析—地质分层", businessType = BusinessType.EXPORT)
    @PostMapping("/export")
    public void export(HttpServletResponse response, SjDcfxDzfc sjDcfxDzfc)
    {
        List<SjDcfxDzfc> list = sjDcfxDzfcService.selectSjDcfxDzfcList(sjDcfxDzfc);
        ExcelUtil<SjDcfxDzfc> util = new ExcelUtil<SjDcfxDzfc>(SjDcfxDzfc.class);
        util.exportExcel(response, list, "设计-地层分析—地质分层数据");
    }

    /**
     * 获取设计-地层分析—地质分层详细信息
     */
    //@PreAuthorize("@ss.hasPermi('system:sjDcfxDzfc:query')")
    @GetMapping(value = "/{id}")
    public AjaxResult getInfo(@PathVariable("id") Long id)
    {
        return success(sjDcfxDzfcService.selectSjDcfxDzfcById(id));
    }

    /**
     * 新增设计-地层分析—地质分层
     */
    //@PreAuthorize("@ss.hasPermi('system:sjDcfxDzfc:add')")
    @Log(title = "设计-地层分析—地质分层", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody SjDcfxDzfc sjDcfxDzfc)
    {
        return toAjax(sjDcfxDzfcService.insertSjDcfxDzfc(sjDcfxDzfc));
    }

    /**
     * 修改设计-地层分析—地质分层
     */
    //@PreAuthorize("@ss.hasPermi('system:sjDcfxDzfc:edit')")
    @Log(title = "设计-地层分析—地质分层", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody SjDcfxDzfc sjDcfxDzfc)
    {
        return toAjax(sjDcfxDzfcService.updateSjDcfxDzfc(sjDcfxDzfc));
    }

    /**
     * 删除设计-地层分析—地质分层
     */
    //@PreAuthorize("@ss.hasPermi('system:sjDcfxDzfc:remove')")
    @Log(title = "设计-地层分析—地质分层", businessType = BusinessType.DELETE)
	@DeleteMapping("/{ids}")
    public AjaxResult remove(@PathVariable Long[] ids)
    {
        return toAjax(sjDcfxDzfcService.deleteSjDcfxDzfcByIds(ids));
    }
}
