package com.zjsgfa.project.zjsgfa.controller;

import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.zjsgfa.framework.aspectj.lang.annotation.Log;
import com.zjsgfa.framework.aspectj.lang.enums.BusinessType;
import com.zjsgfa.project.zjsgfa.domain.JcxxHse;
import com.zjsgfa.project.zjsgfa.service.IJcxxHseService;
import com.zjsgfa.framework.web.controller.BaseController;
import com.zjsgfa.framework.web.domain.AjaxResult;
import com.zjsgfa.common.utils.poi.ExcelUtil;
import com.zjsgfa.framework.web.page.TableDataInfo;

/**
 * 基础信息-HSE专篇Controller
 * 
 * @author ruoyi
 * @date 2025-07-24
 */
@RestController
@RequestMapping("/system/jcxxHse")
public class JcxxHseController extends BaseController
{
    @Autowired
    private IJcxxHseService jcxxHseService;

    /**
     * 查询基础信息-HSE专篇列表
     */
    @PreAuthorize("@ss.hasPermi('system:jcxxHse:list')")
    @GetMapping("/list")
    public TableDataInfo list(JcxxHse jcxxHse)
    {
        startPage();
        List<JcxxHse> list = jcxxHseService.selectJcxxHseList(jcxxHse);
        return getDataTable(list);
    }

    /**
     * 导出基础信息-HSE专篇列表
     */
    @PreAuthorize("@ss.hasPermi('system:jcxxHse:export')")
    @Log(title = "基础信息-HSE专篇", businessType = BusinessType.EXPORT)
    @PostMapping("/export")
    public void export(HttpServletResponse response, JcxxHse jcxxHse)
    {
        List<JcxxHse> list = jcxxHseService.selectJcxxHseList(jcxxHse);
        ExcelUtil<JcxxHse> util = new ExcelUtil<JcxxHse>(JcxxHse.class);
        util.exportExcel(response, list, "基础信息-HSE专篇数据");
    }

    /**
     * 获取基础信息-HSE专篇详细信息
     */
    @PreAuthorize("@ss.hasPermi('system:jcxxHse:query')")
    @GetMapping(value = "/{id}")
    public AjaxResult getInfo(@PathVariable("id") Long id)
    {
        return success(jcxxHseService.selectJcxxHseById(id));
    }

    /**
     * 新增基础信息-HSE专篇
     */
    @PreAuthorize("@ss.hasPermi('system:jcxxHse:add')")
    @Log(title = "基础信息-HSE专篇", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody JcxxHse jcxxHse)
    {
        return toAjax(jcxxHseService.insertJcxxHse(jcxxHse));
    }

    /**
     * 修改基础信息-HSE专篇
     */
    @PreAuthorize("@ss.hasPermi('system:jcxxHse:edit')")
    @Log(title = "基础信息-HSE专篇", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody JcxxHse jcxxHse)
    {
        return toAjax(jcxxHseService.updateJcxxHse(jcxxHse));
    }

    /**
     * 删除基础信息-HSE专篇
     */
    @PreAuthorize("@ss.hasPermi('system:jcxxHse:remove')")
    @Log(title = "基础信息-HSE专篇", businessType = BusinessType.DELETE)
	@DeleteMapping("/{ids}")
    public AjaxResult remove(@PathVariable Long[] ids)
    {
        return toAjax(jcxxHseService.deleteJcxxHseByIds(ids));
    }
}
