package com.zjsgfa.project.zt.service;

import com.zjsgfa.project.zt.domain.Jsba;

import java.util.List;

/**
 * 地质简介基本数据Service接口
 * 
 * @author
 * @date 2025-07-10
 */
public interface IJsbaService 
{
    /**
     * 查询地质简介基本数据
     * 
     * @param jh 地质简介基本数据主键
     * @return 地质简介基本数据
     */
    public Jsba selectJsbaByJh(String jh);

    /**
     * 查询地质简介基本数据列表
     * 
     * @param jsba 地质简介基本数据
     * @return 地质简介基本数据集合
     */
    public List<Jsba> selectJsbaList(Jsba jsba);

    /**
     * 新增地质简介基本数据
     * 
     * @param jsba 地质简介基本数据
     * @return 结果
     */
    public int insertJsba(Jsba jsba);

    /**
     * 修改地质简介基本数据
     * 
     * @param jsba 地质简介基本数据
     * @return 结果
     */
    public int updateJsba(Jsba jsba);

    /**
     * 批量删除地质简介基本数据
     * 
     * @param jhs 需要删除的地质简介基本数据主键集合
     * @return 结果
     */
    public int deleteJsbaByJhs(String[] jhs);

    /**
     * 删除地质简介基本数据信息
     * 
     * @param jh 地质简介基本数据主键
     * @return 结果
     */
    public int deleteJsbaByJh(String jh);
}
