package com.zjsgfa.project.zt.mapper;

import java.util.List;

import com.zjsgfa.framework.aspectj.lang.annotation.DataSource;
import com.zjsgfa.framework.aspectj.lang.enums.DataSourceType;
import com.zjsgfa.project.zt.domain.CommonParam;
import com.zjsgfa.project.zt.domain.LjZtzhdf;

/**
 * 钻头综合得分Mapper接口
 * 
 * @author
 * @date 2025-06-29
 */
@DataSource(value = DataSourceType.MASTER)
public interface LjZtzhdfMapper 
{
    /**
     * 查询钻头综合得分
     * 
     * @param id 钻头综合得分主键
     * @return 钻头综合得分
     */
    public LjZtzhdf selectLjZtzhdfById(Long id);

    /**
     * 查询钻头综合得分列表
     * 
     * @param ljZtzhdf 钻头综合得分
     * @return 钻头综合得分集合
     */
    public List<LjZtzhdf> selectLjZtzhdfList(LjZtzhdf ljZtzhdf);

    /**
     * 新增钻头综合得分
     * 
     * @param ljZtzhdf 钻头综合得分
     * @return 结果
     */
    public int insertLjZtzhdf(LjZtzhdf ljZtzhdf);

    /**
     * 修改钻头综合得分
     * 
     * @param ljZtzhdf 钻头综合得分
     * @return 结果
     */
    public int updateLjZtzhdf(LjZtzhdf ljZtzhdf);

    /**
     * 删除钻头综合得分
     * 
     * @param id 钻头综合得分主键
     * @return 结果
     */
    public int deleteLjZtzhdfById(Long id);

    /**
     * 批量删除钻头综合得分
     * 
     * @param ids 需要删除的数据主键集合
     * @return 结果
     */
    public int deleteLjZtzhdfByIds(Long[] ids);

    int batchLjZtzhdf(List<LjZtzhdf> list);

    List<LjZtzhdf> selectLjZtzhdfListByCom(CommonParam param);

}
