package com.zjsgfa.project.zt.controller;

import cn.hutool.http.HttpRequest;
import com.google.gson.*;
import com.zjsgfa.common.utils.poi.ExcelUtil;
import com.zjsgfa.framework.web.domain.AjaxResult;
import com.zjsgfa.project.zt.domain.*;
import com.zjsgfa.project.zt.domain.vo.JsgaVo;
import com.zjsgfa.project.zt.service.DjdcService;
import org.apache.poi.ss.usermodel.*;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@RestController
@RequestMapping("/djdc")
public class DjdcController {




    @Autowired
    private DjdcService djdcService;


    @GetMapping("/getList")
    public AjaxResult getList(DjDcInfo info){
        return AjaxResult.success(djdcService.getList(info));
    }

    /**
     * 根据井号查询临井
     */
    @GetMapping("/ljListByJh")
    public AjaxResult ljListByJh(Ljinfo info){
        return AjaxResult.success(djdcService.ljListByJh(info));
    }





    /**
     * 获取井基础信息
     */
    @PostMapping("/api")
    public Object ff(@RequestBody CommonParam param) throws Exception{
        String path = param.getPath();
        Map<String,Object> map =new HashMap<>();
        switch (path) {
            case "getDjjcList":
                //获取钻头关键数据
                map.put("jh","井号");
                map.put("kc","开次");
                map.put("jd","井段");
                map.put("ztcc","钻头外径");
                map.put("ztxh","钻头型号");
                map.put("pz","喷嘴");
                map.put("mxqk","磨损情况");
                map.put("qzyy","起钻原因");
                map.put("cw","层位");
                map.put("zjymd","钻井液密度");
                map.put("lgby","泵压");
                map.put("pl","排量");
                map.put("jc","进尺");
                map.put("jxzs","机械钻速");
                map.put("zb","指标");
                List<Djjc> djjcList = djdcService.getDjjcList(param);
                AjaxResult success = AjaxResult.success(djjcList, map);
//                Gson gson = new GsonBuilder().setPrettyPrinting().create();

                // 将实体对象转换为JSON字符串
//                String json = gson.toJson(success);
//                String convert = JsonToMarkdown.convert(json);
//                System.out.println(convert);
                return success;

            case "getZqshfxList":
                //获取邻井周期分析
                map.put("jh","井号");
                map.put("kc","开次");
                map.put("jtm","井筒名");
                map.put("ksjs","开始井深");
                map.put("js","结束井深");
                map.put("jc","进尺");
                map.put("cw","到达层位");
                map.put("zjzq","钻进实际周期");
                map.put("zjycsl","钻进异常周期");
                map.put("zjsczq","钻进生产周期");
                map.put("zjsl","钻进速率");
                map.put("zwzq","中完实际周期");

                map.put("wjsczq","完井（中完）生产周期");
                map.put("wjycsl","完井异常周期");
                map.put("zjycms","钻井异常描述");
                map.put("wjycms","中完（完井异常描述）");
                return AjaxResult.success( djdcService.getZqshfxList(param),map);
            case "getZjzhfxList":
                //获取钻具组合分析
                map.put("jh","井号");
                map.put("kc","开次");
                map.put("jd","井段");
                map.put("jc","进尺");
                map.put("zjzhmx","钻具组合模型");
                map.put("tsgj","特殊工具");
                map.put("zjzh","钻具组合明细");
                map.put("zb","时效");
                return AjaxResult.success( djdcService.getZjzhfxList(param),map);
            case "getLjjwList":
                //获取邻近井位
                map.put("jh","井号");
                map.put("jx","井型");
                map.put("jb","井别");
                map.put("wjjs","井深");
                map.put("wjczjs","垂深");
                map.put("wzcw","完钻层位");
                map.put("kc","总开次");
                map.put("zjzq","钻井周期");
                map.put("wjzq","完井周期");
                map.put("jkhzb","井口横坐标");
                map.put("jkzzb","井口纵坐标");
                map.put("jkhjl","井口横距离");
                map.put("jkzjl","井口纵距离");
                map.put("jdhzb","井底横坐标");
                map.put("jdzzb","井底纵坐标");
                map.put("jkjl","井口距离");
                map.put("jdjl","井底距离");
                map.put("jdzjl","井底纵距离");
                map.put("jdhjl","井底横距离");
                AjaxResult result = djdcService.getLjjwList(param);

// 从 AjaxResult 中提取数据并转换为 List<Ljjw>
                Object data = result.get("data"); // 或者使用 result.getData()，取决于 AjaxResult 的具体实现
                List<Ljjw> ljjwList = (List<Ljjw>) data;
                String md = listToMarkdownTable(ljjwList);

                return md;
//                return AjaxResult.success("",md,map);
            case "getLjjwList2":
                //获取邻近井位
                map.put("jh","井号");
                map.put("jx","井型");
                map.put("jb","井别");
                map.put("wjjs","井深");
                map.put("wjczjs","垂深");
                map.put("wzcw","完钻层位");
                map.put("kc","总开次");
                map.put("zjzq","钻井周期");
                map.put("wjzq","完井周期");
                map.put("jkhzb","井口横坐标");
                map.put("jkzzb","井口纵坐标");
                map.put("jkhjl","井口横距离");
                map.put("jkzjl","井口纵距离");
                map.put("jdhzb","井底横坐标");
                map.put("jdzzb","井底纵坐标");
                map.put("jkjl","井口距离");
                map.put("jdjl","井底距离");
                map.put("jdzjl","井底纵距离");
                map.put("jdhjl","井底横距离");
//                List<Ljjw> ljjwList2= djdcService.getLjjwList(param);
                return djdcService.getLjjwList(param);
            case "getJsqaList":
                //获取复杂情况
                map.put("jh","井号");
                map.put("fzbh","复杂编号");
                map.put("fzqk","复杂情况");
                map.put("fsrq","事故时间－发生");
                map.put("fssj","事故时间－发生");
                map.put("jcrq","事故时间－解除");
                map.put("jcsj","事故时间－解除");
                map.put("sssj","事故时间－损失");
                map.put("fsjgjyy","发生经过");
                map.put("clgk","处理概况");
                map.put("zjjjss","直接损失");
                map.put("js","井深");
                return AjaxResult.success( djdcService.getJsqaList(param),map);
            case "getDjZtfxList":
                //获取钻头分析
                map.put("kc","开次");
                map.put("ztxh","钻头型号");
                map.put("cc","外径");
                map.put("ztsl","钻头数量（钻头使用频次）");
                map.put("ytzl","一趟钻率");
                map.put("etzl","二趟钻率");
//                map.put("stzl","三趟钻率");
//                map.put("sitzl","四趟钻率");
//                map.put("wtzl","五趟钻率");
                map.put("jcZw","进尺中位数");
                map.put("jcMax","进尺最大值");
                map.put("jxzsZw","机械钻速中位数");
                map.put("jxzsMax","机械钻速最大值");
                map.put("qsjsZw","起出井深中位数");
                return AjaxResult.success( djdcService.getDjZtfxList(param),map);
            case "calZtzhdf":
                //计算钻头综合得分和实钻分析结果
                return AjaxResult.success( djdcService.calZtzhdf(param));
            case  "getzhzhdfList":
                //获取钻头综合得分
                map.put("kc","开次");
                map.put("ztxh","钻头型号");
                map.put("cc","钻头尺寸");
                map.put("jcdf","进尺得分");
                map.put("jsdf","机速得分");
                map.put("zbdf","指标得分");
                map.put("sldf","数量得分");
                map.put("zhdf","综合得分");
                return AjaxResult.success( djdcService.getzhzhdfList(param),map);
            case  "getszfxjgList":
                //获取实钻分析结果
                map.put("gnmk","功能模块");
                map.put("fxfw","分析范围");
                map.put("fxdx","分析对象");
                map.put("fxxy","分析现象");
                map.put("fxjl","分析结论");
                map.put("scfx","输出方向");
                map.put("yxyj","优选依据");
                map.put("zyjy","最优建议");
                map.put("qcyj","其次建议");
                map.put("tjpf","推荐评分");
                map.put("xxcs","详细参数");
                return AjaxResult.success( djdcService.getszfxjgList(param),map);
            case  "getZtzhzzdfList":
                //获取钻头最终得分
                map.put("kc","开次");
                map.put("ztxh","钻头型号");
                map.put("cc","钻头尺寸");
                map.put("jcdf","进尺得分");
                map.put("jsdf","机速得分");
//                map.put("zbdf","指标得分");
//                map.put("sldf","数量得分");
                map.put("zhdf","综合得分");
                return AjaxResult.success( djdcService.getZtzhzzdfList(param),map);
            case  "getDzfcList":
                //获取地质分成
                return AjaxResult.success( djdcService.getDzfcList2(param),map);
            case  "getFdcsList":
                //获取分段方案参数
                return AjaxResult.success( djdcService.getFdcsList(param));
            case  "getKjsjList":
                //获取
                return AjaxResult.success( djdcService.getKjsjList(param));
            case  "getZsjList":
                //获取注水井
                return AjaxResult.success( djdcService.getZsjList(param));
            case  "getGzbjList":
                //获取高指标井
                return AjaxResult.success( djdcService.getGzbjList(param));
            case  "getJsgaList":
                //获取高指标井
                return AjaxResult.success( djdcService.getJsgaList(param));
            default:
                return AjaxResult.success();
        }
    }


    /**
     * 导出地质简介基本数据列表
     */
//    @PreAuthorize("@ss.hasPermi('system:jsba:export')")
//    @Log(title = "地质简介基本数据", businessType = BusinessType.EXPORT)
    @PostMapping("/export")
    public void export(HttpServletResponse response, CommonParam param) throws Exception {

        String path = param.getExportPath();
        switch (path) {
            case "exportLjjw":
                //导出邻井查询
                AjaxResult result = djdcService.getLjjwList(param);
                Object data = result.get("data");
                List<Ljjw> ljjwList = (List<Ljjw>) data;
                ExcelUtil<Ljjw> util = new ExcelUtil<Ljjw>(Ljjw.class);
                util.exportExcel(response, ljjwList, "Sheet1");
                break;
            case "exportZqshfx":
                //导出周期分析
                List<DjZqsjfx> zqshfxList = djdcService.getZqshfxList(param);
                exportZqshfx(response,zqshfxList);
                break;
            case "exportZtgjsj":
                //导出钻头关键数据
                List<Djjc> djjcList = djdcService.getDjjcList(param);
                ExcelUtil<Djjc> utilzt = new ExcelUtil<Djjc>(Djjc.class);
                utilzt.exportExcel(response, djjcList, "Sheet1");
                break;
            case "exportQkztfx":
                //导出区块钻头分析
                List<DjZtfx> djZtfxList = djdcService.getDjZtfxList(param);
                ExcelUtil<DjZtfx> utilzqk = new ExcelUtil<DjZtfx>(DjZtfx.class);
                utilzqk.exportExcel(response, djZtfxList, "Sheet1");
                break;
            case "exportZtdf":
                //导出钻头得分
                Map<String, Object> map = djdcService.calZtzhdf(param);
                List<LjZtzhdf> ztzhdf =(List<LjZtzhdf>) map.get("ztzhdf");
                ExcelUtil<LjZtzhdf> utilZtdf = new ExcelUtil<LjZtzhdf>(LjZtzhdf.class);
                utilZtdf.exportExcel(response, ztzhdf, "Sheet1");
                break;
            case "exportZzztdf":
                //导出最终钻头得分
                Map<String, Object> map2 = djdcService.calZtzhdf(param);
                List<LjZtdfzh> ljZtdfzhList =(List<LjZtdfzh>) map2.get("zjzhdf");
                ExcelUtil<LjZtdfzh> utilZzztdf = new ExcelUtil<LjZtdfzh>(LjZtdfzh.class);
                utilZzztdf.exportExcel(response, ljZtdfzhList, "Sheet1");
                break;
            case "exportSzfxjg":
                //导出实钻分析结果
                Map<String, Object> map3 = djdcService.calZtzhdf(param);
                List<LjSzfxjg> ljSzfxjgList =(List<LjSzfxjg>) map3.get("szfxjg");
                ExcelUtil<LjSzfxjg> utilSzfxjg = new ExcelUtil<LjSzfxjg>(LjSzfxjg.class);
                utilSzfxjg.exportExcel(response, ljSzfxjgList, "Sheet1");
                break;
            case "exportFdcsList":
                //导出实钻分析结果
                List<Jsha> fdcsList = djdcService.getFdcsList(param);
                exportFdcs(response,fdcsList);
                break;
            case "exportKsjList":
                //导出实钻分析结果
                List<DjZqsjfx> kjsjList = djdcService.getKjsjList(param);
                ExcelUtil<DjZqsjfx> kssjEx = new ExcelUtil<DjZqsjfx>(DjZqsjfx.class);
                kssjEx.exportExcel(response, kjsjList, "Sheet1");
                break;
            case "exportZsjList":
                //导出
                List<Zsjfx> zsjList = djdcService.getZsjList(param);
                ExcelUtil<Zsjfx> zsjfxExcelUtil = new ExcelUtil<Zsjfx>(Zsjfx.class);
                zsjfxExcelUtil.exportExcel(response, zsjList, "Sheet1");
                break;
            case "exportJsgaList":
                //导出
                List<JsgaVo> jsgaList = djdcService.getJsgaList(param);
                ExcelUtil<JsgaVo> jsgaExcelUtil = new ExcelUtil<JsgaVo>(JsgaVo.class);
                jsgaExcelUtil.exportExcel(response, jsgaList, "Sheet1");
                break;
            default:
                break;
        }

    }


    public void exportZqshfx(HttpServletResponse response,List<DjZqsjfx> list)throws IOException {
        Workbook exl = null;
        OutputStream out = null;
        InputStream in  = null;
        try {
            in =this.getClass().getResourceAsStream("/static/excel/zqfxdcmb.xlsx");
            exl = WorkbookFactory.create(in);
            out = response.getOutputStream();
            response.reset();
            String filename = URLEncoder.encode("导入模板.xlsx", "UTF-8");
            response.setCharacterEncoding("UTF-8");
            response.setHeader("Content-Disposition", "attachment;filename=" + filename);
            response.setContentType(MediaType.APPLICATION_OCTET_STREAM_VALUE);

            Sheet sheet = exl.getSheet("Sheet1");
            CellStyle cellStyle = exl.createCellStyle();
            cellStyle.setAlignment(HorizontalAlignment.CENTER);
            cellStyle.setVerticalAlignment(VerticalAlignment.CENTER);
            cellStyle.setBorderBottom(BorderStyle.THIN); //下边框
            cellStyle.setBorderLeft(BorderStyle.THIN);//左边框
            cellStyle.setBorderTop(BorderStyle.THIN);//上边框
            cellStyle.setBorderRight(BorderStyle.THIN);//右边框
            cellStyle.setBottomBorderColor(IndexedColors.BLACK.getIndex());
            cellStyle.setLeftBorderColor(IndexedColors.BLACK.getIndex());
            cellStyle.setRightBorderColor(IndexedColors.BLACK.getIndex());
            cellStyle.setTopBorderColor(IndexedColors.BLACK.getIndex());
            Font cellFont = exl.createFont();
            cellFont.setFontHeightInPoints((short)9);    // 字体大小
            cellFont.setFontName("宋体");             // 字体应用到当前单元格上
            cellStyle.setFont(cellFont);
            cellStyle.setWrapText(true);//设置自动换行

            int lastRow = sheet.getLastRowNum()+1;
            for(DjZqsjfx item:list){
                Row row = sheet.createRow(lastRow);
                row.setHeightInPoints(18);
                int m = 0;
                Cell cell = row.createCell(m++);cell.setCellStyle(cellStyle); cell.setCellValue(item.getJh()+"");
                cell = row.createCell(m++);cell.setCellStyle(cellStyle); cell.setCellValue(item.getKc()+"");
//                cell = row.createCell(m++);cell.setCellStyle(cellStyle); cell.setCellValue(item.getJtm()+"");
                cell = row.createCell(m++);cell.setCellStyle(cellStyle); cell.setCellValue(item.getKsjs()+"");
                cell = row.createCell(m++);cell.setCellStyle(cellStyle); cell.setCellValue(item.getJs()+"");
                cell = row.createCell(m++);cell.setCellStyle(cellStyle); cell.setCellValue(item.getJc()+"");
                cell = row.createCell(m++);cell.setCellStyle(cellStyle); cell.setCellValue(item.getCw()+"");
                cell = row.createCell(m++);cell.setCellStyle(cellStyle); cell.setCellValue(item.getZjzq()+"");
                cell = row.createCell(m++);cell.setCellStyle(cellStyle); cell.setCellValue(item.getZjycsl()+"");
                cell = row.createCell(m++);cell.setCellStyle(cellStyle); cell.setCellValue(item.getZjsczq()+"");
                cell = row.createCell(m++);cell.setCellStyle(cellStyle); cell.setCellValue(item.getZjsl()+"");
                cell = row.createCell(m++);cell.setCellStyle(cellStyle); cell.setCellValue(item.getZwzq()+"");
                if(item.getWjycsl()!=null){
                    cell = row.createCell(m++);cell.setCellStyle(cellStyle); cell.setCellValue(item.getWjycsl());

                }else {
                    cell = row.createCell(m++);cell.setCellStyle(cellStyle); cell.setCellValue("");
                }

                if(item.getWjsczq()!=null){
                    cell = row.createCell(m++);cell.setCellStyle(cellStyle); cell.setCellValue(item.getWjsczq());
                }else {
                    cell = row.createCell(m++);cell.setCellStyle(cellStyle); cell.setCellValue("");

                }

                cell = row.createCell(m++);cell.setCellStyle(cellStyle); cell.setCellValue(item.getZjycms());
                cell = row.createCell(m++);cell.setCellStyle(cellStyle); cell.setCellValue(item.getWjycms());
                lastRow++;
            }
            exl.write(out);
            exl.close();
        }catch (Exception e){
            e.getMessage();
            throw new IOException();
        }finally{
            if (exl != null) {
                try {
                    exl.close();
                } catch (IOException e1) {
                    e1.printStackTrace();
                }
            }
            if (out != null) {
                try {
                    out.close();
                } catch (IOException e1) {
                    e1.printStackTrace();
                }
            }
        }
    }



    public void exportFdcs(HttpServletResponse response,List<Jsha> list)throws IOException {
        Workbook exl = null;
        OutputStream out = null;
        InputStream in  = null;
        try {
            in =this.getClass().getResourceAsStream("/static/excel/ljfdcs.xlsx");
            exl = WorkbookFactory.create(in);
            out = response.getOutputStream();
            response.reset();
            String filename = URLEncoder.encode("导入模板.xlsx", "UTF-8");
            response.setCharacterEncoding("UTF-8");
            response.setHeader("Content-Disposition", "attachment;filename=" + filename);
            response.setContentType(MediaType.APPLICATION_OCTET_STREAM_VALUE);

            Sheet sheet = exl.getSheet("Sheet1");
            CellStyle cellStyle = exl.createCellStyle();
            cellStyle.setAlignment(HorizontalAlignment.CENTER);
            cellStyle.setVerticalAlignment(VerticalAlignment.CENTER);
            cellStyle.setBorderBottom(BorderStyle.THIN); //下边框
            cellStyle.setBorderLeft(BorderStyle.THIN);//左边框
            cellStyle.setBorderTop(BorderStyle.THIN);//上边框
            cellStyle.setBorderRight(BorderStyle.THIN);//右边框
            cellStyle.setBottomBorderColor(IndexedColors.BLACK.getIndex());
            cellStyle.setLeftBorderColor(IndexedColors.BLACK.getIndex());
            cellStyle.setRightBorderColor(IndexedColors.BLACK.getIndex());
            cellStyle.setTopBorderColor(IndexedColors.BLACK.getIndex());
            Font cellFont = exl.createFont();
            cellFont.setFontHeightInPoints((short)9);    // 字体大小
            cellFont.setFontName("宋体");             // 字体应用到当前单元格上
            cellStyle.setFont(cellFont);
            cellStyle.setWrapText(true);//设置自动换行

            int lastRow = sheet.getLastRowNum()+1;
            for(Jsha item:list){
                Row row = sheet.createRow(lastRow);
                row.setHeightInPoints(18);
                int m = 0;
                Cell cell = row.createCell(m++);cell.setCellStyle(cellStyle); cell.setCellValue(item.getJh());
                cell = row.createCell(m++);cell.setCellStyle(cellStyle); cell.setCellValue(item.getKc());
                cell = row.createCell(m++);cell.setCellStyle(cellStyle); cell.setCellValue(item.getZy());
                cell = row.createCell(m++);cell.setCellStyle(cellStyle); cell.setCellValue(item.getZs());
                cell = row.createCell(m++);cell.setCellStyle(cellStyle); cell.setCellValue(item.getGj());
                cell = row.createCell(m++);cell.setCellStyle(cellStyle); cell.setCellValue(item.getBs());
                cell = row.createCell(m++);cell.setCellStyle(cellStyle); cell.setCellValue(item.getPl());
                cell = row.createCell(m++);cell.setCellStyle(cellStyle); cell.setCellValue(item.getLgby());
                cell = row.createCell(m++);cell.setCellStyle(cellStyle); cell.setCellValue(item.getZtyj());
                cell = row.createCell(m++);cell.setCellStyle(cellStyle); cell.setCellValue(item.getHkyh());
                cell = row.createCell(m++);cell.setCellStyle(cellStyle); cell.setCellValue(item.getCjl());
                cell = row.createCell(m++);cell.setCellStyle(cellStyle); cell.setCellValue(item.getPssd());
                cell = row.createCell(m++);cell.setCellStyle(cellStyle); cell.setCellValue(item.getZtsgl());
                cell = row.createCell(m++);cell.setCellStyle(cellStyle); cell.setCellValue(item.getBsgl());
                cell = row.createCell(m++);cell.setCellStyle(cellStyle); cell.setCellValue(item.getSfsdzg());
                cell = row.createCell(m++);cell.setCellStyle(cellStyle); cell.setCellValue(item.getSfsdzt());
                cell = row.createCell(m++);cell.setCellStyle(cellStyle); cell.setCellValue(item.getGllyl());
                lastRow++;
            }
            exl.write(out);
            exl.close();
        }catch (Exception e){
            e.getMessage();
            throw new IOException();
        }finally{
            if (exl != null) {
                try {
                    exl.close();
                } catch (IOException e1) {
                    e1.printStackTrace();
                }
            }
            if (out != null) {
                try {
                    out.close();
                } catch (IOException e1) {
                    e1.printStackTrace();
                }
            }
        }
    }




    // 生成Markdown表格
    public static String listToMarkdownTable(List<Ljjw> ljjwList) {
        StringBuilder markdownTable = new StringBuilder();

        // 获取Ljjw类的所有字段
        Field[] fields = Ljjw.class.getDeclaredFields();

        // 生成表头
        markdownTable.append("|");
        for (Field field : fields) {

        }
        markdownTable.append("井号".replace("|", "\\|")).append("|");
        markdownTable.append("井口横坐标".replace("|", "\\|")).append("|");
        markdownTable.append("井口纵坐标".replace("|", "\\|")).append("|");
        markdownTable.append("井底横坐标".replace("|", "\\|")).append("|");
        markdownTable.append("井底纵坐标".replace("|", "\\|")).append("|");
        markdownTable.append("井型".replace("|", "\\|")).append("|");
        markdownTable.append("井别".replace("|", "\\|")).append("|");
        markdownTable.append("斜深".replace("|", "\\|")).append("|");
        markdownTable.append("垂深".replace("|", "\\|")).append("|");
        markdownTable.append("完钻层位".replace("|", "\\|")).append("|");
        markdownTable.append("总开次".replace("|", "\\|")).append("|");
        markdownTable.append("完井周期".replace("|", "\\|")).append("|");
        markdownTable.append("钻井周期".replace("|", "\\|")).append("|");
        markdownTable.append("井口距离".replace("|", "\\|")).append("|");
        markdownTable.append("井底距离".replace("|", "\\|")).append("|");
        markdownTable.append("井口纵距离".replace("|", "\\|")).append("|");
        markdownTable.append("井口横距离".replace("|", "\\|")).append("|");
        markdownTable.append("井底纵距离".replace("|", "\\|")).append("|");
        markdownTable.append("井底横距离".replace("|", "\\|")).append("|");
        markdownTable.append("\n");

        // 生成表头分隔线
        markdownTable.append("|");
        for (Field field : fields) {
            markdownTable.append("---|");
        }
        markdownTable.append("\n");

        // 生成数据行
        for (Ljjw ljjw : ljjwList) {
            markdownTable.append("|");
            for (Field field : fields) {
                field.setAccessible(true);
                try {
                    Object value = field.get(ljjw);
                    String valueStr = value != null ? value.toString() : "";
                    // 处理字段值中的|字符
                    valueStr = valueStr.replace("|", "\\|");
                    markdownTable.append(valueStr).append("|");
                } catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
            }
            markdownTable.append("\n");
        }

        return markdownTable.toString();
    }


    /**
     * 调用大模型解析钻具组合
     * @param param
     * @return
     * @throws Exception
     */
    @PostMapping("/dyAiModelJxZjzh")
    public AjaxResult dyAiModelJxZjzh(@RequestBody CommonParam param) throws Exception{
        return AjaxResult.success(djdcService.dyAiModelJxZjzh(param));
    }

    /**
     * 调用长城大模型
     * @param param
     * @return
     */
    @PostMapping("/dyAiModel")
    public AjaxResult dyAiModel(CommonParam param){

        Map<String,Object> map=new HashMap<>();
        map.put("prompt",param.getZjzh()+" 这是一个钻具组合信息，请把这个钻具组合信息拆分成竖表，字段为钻具名称(zjmc)、型号(xh)、长度(cd),最终输出json格式数据,其他内容不输出,输出内容不换行，只要数据，反斜杠不输出");

        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        String json = gson.toJson(map);

        String url="http://10.68.249.59:33331/api/chat/1";

        String result2 = HttpRequest.post(url)
                .body(json)
                .execute().body();
        System.out.println(result2);
        // 解析API响应
        Gson gsonres = new GsonBuilder().setPrettyPrinting().create();
        JsonObject apiResponse = JsonParser.parseString(result2).getAsJsonObject();

        // 提取message.content字段
        JsonObject message = apiResponse.getAsJsonObject("message");
        String content = message.get("content").getAsString();

        // 提取content中的JSON部分（去除Markdown代码块标记）
        String jsonContent = extractJsonContent(content);

        // 解析并格式化JSON内容
        JsonElement jsonElement = JsonParser.parseString(jsonContent);
        String formattedJson = gson.toJson(jsonElement);

        // 输出格式化后的JSON
        System.out.println(formattedJson);

        // 示例：处理解析后的数据
        JsonObject dataObject = JsonParser.parseString(jsonContent).getAsJsonObject();
        JsonArray dataArray = dataObject.getAsJsonArray("data");

        // 遍历数据数组
        for (JsonElement element : dataArray) {
            JsonObject item = element.getAsJsonObject();
            String zjmc = item.get("zjmc").getAsString();
            String xh = item.get("xh").getAsString();
            String cd = item.get("cd").getAsString();
            System.out.printf("组件名称: %s, 型号: %s, 长度: %s%n", zjmc, xh, cd);
        }


        return AjaxResult.success();
    }



    /**
     * 从Markdown代码块中提取JSON内容
     */
    private static String extractJsonContent(String markdownContent) {
        // 去除开头的```json和结尾的```
        return markdownContent
                .replaceFirst("^```json", "")
                .replaceFirst("```$", "")
                .trim();
    }





}
