package com.zjsgfa.project.zjsgfa.service.impl;

import java.util.List;
import com.zjsgfa.common.utils.DateUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.zjsgfa.project.zjsgfa.mapper.SjSzfxjgMapper;
import com.zjsgfa.project.zjsgfa.domain.SjSzfxjg;
import com.zjsgfa.project.zjsgfa.service.ISjSzfxjgService;

/**
 * 设计-实钻分析结果Service业务层处理
 * 
 * @author
 * @date 2025-07-22
 */
@Service
public class SjSzfxjgServiceImpl implements ISjSzfxjgService 
{
    @Autowired
    private SjSzfxjgMapper sjSzfxjgMapper;

    /**
     * 查询设计-实钻分析结果
     * 
     * @param id 设计-实钻分析结果主键
     * @return 设计-实钻分析结果
     */
    @Override
    public SjSzfxjg selectSjSzfxjgById(Long id)
    {
        return sjSzfxjgMapper.selectSjSzfxjgById(id);
    }

    /**
     * 查询设计-实钻分析结果列表
     * 
     * @param sjSzfxjg 设计-实钻分析结果
     * @return 设计-实钻分析结果
     */
    @Override
    public List<SjSzfxjg> selectSjSzfxjgList(SjSzfxjg sjSzfxjg)
    {
        return sjSzfxjgMapper.selectSjSzfxjgList(sjSzfxjg);
    }

    /**
     * 新增设计-实钻分析结果
     * 
     * @param sjSzfxjg 设计-实钻分析结果
     * @return 结果
     */
    @Override
    public int insertSjSzfxjg(SjSzfxjg sjSzfxjg)
    {
        return sjSzfxjgMapper.insertSjSzfxjg(sjSzfxjg);
    }

    /**
     * 修改设计-实钻分析结果
     * 
     * @param sjSzfxjg 设计-实钻分析结果
     * @return 结果
     */
    @Override
    public int updateSjSzfxjg(SjSzfxjg sjSzfxjg)
    {
        sjSzfxjg.setUpdateTime(DateUtils.getNowDate());
        return sjSzfxjgMapper.updateSjSzfxjg(sjSzfxjg);
    }

    /**
     * 批量删除设计-实钻分析结果
     * 
     * @param ids 需要删除的设计-实钻分析结果主键
     * @return 结果
     */
    @Override
    public int deleteSjSzfxjgByIds(Long[] ids)
    {
        return sjSzfxjgMapper.deleteSjSzfxjgByIds(ids);
    }

    /**
     * 删除设计-实钻分析结果信息
     * 
     * @param id 设计-实钻分析结果主键
     * @return 结果
     */
    @Override
    public int deleteSjSzfxjgById(Long id)
    {
        return sjSzfxjgMapper.deleteSjSzfxjgById(id);
    }
}
