package com.zjsgfa.project.zjsgfa.service.impl;

import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.zjsgfa.project.zjsgfa.mapper.SjQkztfxMapper;
import com.zjsgfa.project.zjsgfa.domain.SjQkztfx;
import com.zjsgfa.project.zjsgfa.service.ISjQkztfxService;

/**
 * 设计-区块钻头分析Service业务层处理
 * 
 * @author
 * @date 2025-07-22
 */
@Service
public class SjQkztfxServiceImpl implements ISjQkztfxService 
{
    @Autowired
    private SjQkztfxMapper sjQkztfxMapper;

    /**
     * 查询设计-区块钻头分析
     * 
     * @param id 设计-区块钻头分析主键
     * @return 设计-区块钻头分析
     */
    @Override
    public SjQkztfx selectSjQkztfxById(Long id)
    {
        return sjQkztfxMapper.selectSjQkztfxById(id);
    }

    /**
     * 查询设计-区块钻头分析列表
     * 
     * @param sjQkztfx 设计-区块钻头分析
     * @return 设计-区块钻头分析
     */
    @Override
    public List<SjQkztfx> selectSjQkztfxList(SjQkztfx sjQkztfx)
    {
        return sjQkztfxMapper.selectSjQkztfxList(sjQkztfx);
    }

    /**
     * 新增设计-区块钻头分析
     * 
     * @param sjQkztfx 设计-区块钻头分析
     * @return 结果
     */
    @Override
    public int insertSjQkztfx(SjQkztfx sjQkztfx)
    {
        return sjQkztfxMapper.insertSjQkztfx(sjQkztfx);
    }

    /**
     * 修改设计-区块钻头分析
     * 
     * @param sjQkztfx 设计-区块钻头分析
     * @return 结果
     */
    @Override
    public int updateSjQkztfx(SjQkztfx sjQkztfx)
    {
        return sjQkztfxMapper.updateSjQkztfx(sjQkztfx);
    }

    /**
     * 批量删除设计-区块钻头分析
     * 
     * @param ids 需要删除的设计-区块钻头分析主键
     * @return 结果
     */
    @Override
    public int deleteSjQkztfxByIds(Long[] ids)
    {
        return sjQkztfxMapper.deleteSjQkztfxByIds(ids);
    }

    /**
     * 删除设计-区块钻头分析信息
     * 
     * @param id 设计-区块钻头分析主键
     * @return 结果
     */
    @Override
    public int deleteSjQkztfxById(Long id)
    {
        return sjQkztfxMapper.deleteSjQkztfxById(id);
    }
}
