package com.zjsgfa.project.zjsgfa.controller;

import java.util.List;
import javax.servlet.http.HttpServletResponse;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.zjsgfa.framework.aspectj.lang.annotation.Log;
import com.zjsgfa.framework.aspectj.lang.enums.BusinessType;
import com.zjsgfa.project.zjsgfa.domain.SjZsjqk;
import com.zjsgfa.project.zjsgfa.service.ISjZsjqkService;
import com.zjsgfa.framework.web.controller.BaseController;
import com.zjsgfa.framework.web.domain.AjaxResult;
import com.zjsgfa.common.utils.poi.ExcelUtil;
import com.zjsgfa.framework.web.page.TableDataInfo;

/**
 * 设计-注水井情况Controller
 * 
 * @author
 * @date 2025-08-05
 */
@RestController
@RequestMapping("/system/sjZsjqk")
public class SjZsjqkController extends BaseController
{
    @Autowired
    private ISjZsjqkService sjZsjqkService;

    /**
     * 查询设计-注水井情况列表
     */
    //@PreAuthorize("@ss.hasPermi('system:sjZsjqk:list')")
    @GetMapping("/list")
    public TableDataInfo list(SjZsjqk sjZsjqk)
    {
        startPage();
        List<SjZsjqk> list = sjZsjqkService.selectSjZsjqkList(sjZsjqk);
        return getDataTable(list);
    }

    /**
     * 导出设计-注水井情况列表
     */
    //@PreAuthorize("@ss.hasPermi('system:sjZsjqk:export')")
    @Log(title = "设计-注水井情况", businessType = BusinessType.EXPORT)
    @PostMapping("/export")
    public void export(HttpServletResponse response, SjZsjqk sjZsjqk)
    {
        List<SjZsjqk> list = sjZsjqkService.selectSjZsjqkList(sjZsjqk);
        ExcelUtil<SjZsjqk> util = new ExcelUtil<SjZsjqk>(SjZsjqk.class);
        util.exportExcel(response, list, "设计-注水井情况数据");
    }

    /**
     * 获取设计-注水井情况详细信息
     */
    //@PreAuthorize("@ss.hasPermi('system:sjZsjqk:query')")
    @GetMapping(value = "/{sjjh}")
    public AjaxResult getInfo(@PathVariable("sjjh") String sjjh)
    {
        return success(sjZsjqkService.selectSjZsjqkBySjjh(sjjh));
    }

    /**
     * 新增设计-注水井情况
     */
    @Log(title = "设计-注水井情况", businessType = BusinessType.INSERT)
    //@PreAuthorize("@ss.hasPermi('system:sjZsjqk:add')")
    @PostMapping
    public AjaxResult add(@RequestBody SjZsjqk sjZsjqk)
    {
        return toAjax(sjZsjqkService.insertSjZsjqk(sjZsjqk));
    }

    /**
     * 修改设计-注水井情况
     */
    //@PreAuthorize("@ss.hasPermi('system:sjZsjqk:edit')")
    @Log(title = "设计-注水井情况", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody SjZsjqk sjZsjqk)
    {
        return toAjax(sjZsjqkService.updateSjZsjqk(sjZsjqk));
    }

    /**
     * 删除设计-注水井情况
     */
    //@PreAuthorize("@ss.hasPermi('system:sjZsjqk:remove')")
    @Log(title = "设计-注水井情况", businessType = BusinessType.DELETE)
	@DeleteMapping("/{sjjhs}")
    public AjaxResult remove(@PathVariable String[] sjjhs)
    {
        return toAjax(sjZsjqkService.deleteSjZsjqkBySjjhs(sjjhs));
    }

    @PostMapping("/addAll")
    public AjaxResult addAll(@RequestBody List<SjZsjqk> sjZsjqkList)
    {
       return toAjax(sjZsjqkService.insertSjZsjqkBatch(sjZsjqkList));
    }

}
