package com.zjsgfa.project.zjsgfa.controller;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.zjsgfa.framework.aspectj.lang.annotation.Log;
import com.zjsgfa.framework.aspectj.lang.enums.BusinessType;
import com.zjsgfa.project.zjsgfa.domain.SjDzfc;
import com.zjsgfa.project.zjsgfa.service.ISjDzfcService;
import com.zjsgfa.framework.web.controller.BaseController;
import com.zjsgfa.framework.web.domain.AjaxResult;
import com.zjsgfa.common.utils.poi.ExcelUtil;
import com.zjsgfa.framework.web.page.TableDataInfo;

/**
 * 地质分层Controller
 * 
 * @author
 * @date 2025-07-07
 */
@RestController
@RequestMapping("/system/sjDzfc")
public class SjDzfcController extends BaseController
{
    @Autowired
    private ISjDzfcService sjDzfcService;

    /**
     * 查询地质分层列表
     */
    //@PreAuthorize("@ss.hasPermi('system:sjDzfc:list')")
    @GetMapping("/list")
    public TableDataInfo list(SjDzfc sjDzfc)
    {
//        startPage();
        List<SjDzfc> list = sjDzfcService.selectSjDzfcList(sjDzfc);
        return getDataTable(list);
    }
    @GetMapping("/getList")
    public AjaxResult apiList(SjDzfc sjDzfc)
    {
        Map<String,Object> map=new HashMap<>();
        List<SjDzfc> list = sjDzfcService.selectSjDzfcList(sjDzfc);


        map.put("dcJ", "界");
        map.put("dcX", "系");
        map.put("dcT", "统");
        map.put("dcZ", "组");
        map.put("dcD", "段");
        map.put("sjjh", "设计井号");
        map.put("sjdcs", "底垂深");
        map.put("sjjcgx", "接触关系");
        map.put("sjhd", "厚度");
        map.put("sjddsd", "断点深度");
        map.put("yjjh1", "依据井号1");
        map.put("yjdcs1", "依据底深1");
        map.put("yjjcgx1", "接触关系1");
        map.put("yjhyjd1", "含油井段1");
        map.put("yjddsd1", "断点深度1");
        map.put("sjyxts", "设计井岩性提示");
        map.put("yjjh2", "依据井号2");
        map.put("yjdcs2", "依据底深2");
        map.put("yjjcgx2", "接触关系2");
        map.put("yjhyjd2", "含油井段2");
        map.put("yjddsd2", "断点深度2");
        return AjaxResult.success(list,map);
    }

    /**
     * 导出地质分层列表
     */
    //@PreAuthorize("@ss.hasPermi('system:sjDzfc:export')")
    @Log(title = "地质分层", businessType = BusinessType.EXPORT)
    @PostMapping("/export")
    public void export(HttpServletResponse response, SjDzfc sjDzfc)
    {
        List<SjDzfc> list = sjDzfcService.selectSjDzfcList(sjDzfc);
        ExcelUtil<SjDzfc> util = new ExcelUtil<SjDzfc>(SjDzfc.class);
        util.exportExcel(response, list, "地质分层数据");
    }

    /**
     * 获取地质分层详细信息
     */
    //@PreAuthorize("@ss.hasPermi('system:sjDzfc:query')")
    @GetMapping(value = "/{id}")
    public AjaxResult getInfo(@PathVariable("id") Long id)
    {
        return success(sjDzfcService.selectSjDzfcById(id));
    }

    /**
     * 新增地质分层
     */
    //@PreAuthorize("@ss.hasPermi('system:sjDzfc:add')")
    @Log(title = "地质分层", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody SjDzfc sjDzfc)
    {
        return toAjax(sjDzfcService.insertSjDzfc(sjDzfc));
    }

    /**
     * 修改地质分层
     */
    //@PreAuthorize("@ss.hasPermi('system:sjDzfc:edit')")
    @Log(title = "地质分层", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody SjDzfc sjDzfc)
    {
        return toAjax(sjDzfcService.updateSjDzfc(sjDzfc));
    }

    /**
     * 删除地质分层
     */
    //@PreAuthorize("@ss.hasPermi('system:sjDzfc:remove')")
    @Log(title = "地质分层", businessType = BusinessType.DELETE)
	@DeleteMapping("/{ids}")
    public AjaxResult remove(@PathVariable Long[] ids)
    {
        return toAjax(sjDzfcService.deleteSjDzfcByIds(ids));
    }
}
