package com.zjsgfa.project.zjsgfa.domain;

import java.util.Date;
import com.fasterxml.jackson.annotation.JsonFormat;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.zjsgfa.framework.aspectj.lang.annotation.Excel;
import com.zjsgfa.framework.web.domain.BaseEntity;

/**
 * 设计信息-套管柱强度校核对象 sj_tg_tgqdjh
 * 
 * @author
 * @date 2025-07-17
 */
public class SjTgTgqdjh extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** 主键 */
    private Long id;

    /** 井号 */
    @Excel(name = "井号")
    private String jh;

    /** 开次 */
    @Excel(name = "开次")
    private String kc;

    /** 井段 */
    @Excel(name = "井段")
    private String jd;

    /** 每米质量 */
    @Excel(name = "每米质量")
    private Double mmzl;

    /** 段净重 */
    @Excel(name = "段净重")
    private Double djz;

    /** 累计重 */
    @Excel(name = "累计重")
    private Double ljz;

    /** 抗外挤最大载荷 */
    @Excel(name = "抗外挤最大载荷")
    private Double zdzhkwj;

    /** 抗外挤安全系数 */
    @Excel(name = "抗外挤安全系数")
    private Double aqxskwj;

    /** 抗内压最大载荷 */
    @Excel(name = "抗内压最大载荷")
    private Double zdzhkny;

    /** 抗内压安全系数 */
    @Excel(name = "抗内压安全系数")
    private Double aqxskny;

    /** 抗拉最大载荷 */
    @Excel(name = "抗拉最大载荷")
    private Double zdzhkl;

    /** 抗拉安全系数 */
    @Excel(name = "抗拉安全系数")
    private Double aqxskl;

    /** 备注 */
    @Excel(name = "备注")
    private String bz;

    /** 创建人 */
    @Excel(name = "创建人")
    private String createdBy;

    /** 创建时间 */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "创建时间", width = 30, dateFormat = "yyyy-MM-dd")
    private Date createdTime;

    public void setId(Long id) 
    {
        this.id = id;
    }

    public Long getId() 
    {
        return id;
    }

    public void setJh(String jh) 
    {
        this.jh = jh;
    }

    public String getJh() 
    {
        return jh;
    }

    public void setKc(String kc) 
    {
        this.kc = kc;
    }

    public String getKc() 
    {
        return kc;
    }

    public void setJd(String jd) 
    {
        this.jd = jd;
    }

    public String getJd() 
    {
        return jd;
    }

    public void setMmzl(Double mmzl) 
    {
        this.mmzl = mmzl;
    }

    public Double getMmzl() 
    {
        return mmzl;
    }

    public void setDjz(Double djz) 
    {
        this.djz = djz;
    }

    public Double getDjz() 
    {
        return djz;
    }

    public void setLjz(Double ljz) 
    {
        this.ljz = ljz;
    }

    public Double getLjz() 
    {
        return ljz;
    }

    public void setZdzhkwj(Double zdzhkwj) 
    {
        this.zdzhkwj = zdzhkwj;
    }

    public Double getZdzhkwj() 
    {
        return zdzhkwj;
    }

    public void setAqxskwj(Double aqxskwj) 
    {
        this.aqxskwj = aqxskwj;
    }

    public Double getAqxskwj() 
    {
        return aqxskwj;
    }

    public void setZdzhkny(Double zdzhkny) 
    {
        this.zdzhkny = zdzhkny;
    }

    public Double getZdzhkny() 
    {
        return zdzhkny;
    }

    public void setAqxskny(Double aqxskny) 
    {
        this.aqxskny = aqxskny;
    }

    public Double getAqxskny() 
    {
        return aqxskny;
    }

    public void setZdzhkl(Double zdzhkl) 
    {
        this.zdzhkl = zdzhkl;
    }

    public Double getZdzhkl() 
    {
        return zdzhkl;
    }

    public void setAqxskl(Double aqxskl) 
    {
        this.aqxskl = aqxskl;
    }

    public Double getAqxskl() 
    {
        return aqxskl;
    }

    public void setBz(String bz) 
    {
        this.bz = bz;
    }

    public String getBz() 
    {
        return bz;
    }

    public void setCreatedBy(String createdBy) 
    {
        this.createdBy = createdBy;
    }

    public String getCreatedBy() 
    {
        return createdBy;
    }

    public void setCreatedTime(Date createdTime) 
    {
        this.createdTime = createdTime;
    }

    public Date getCreatedTime() 
    {
        return createdTime;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this,ToStringStyle.MULTI_LINE_STYLE)
            .append("id", getId())
            .append("jh", getJh())
            .append("kc", getKc())
            .append("jd", getJd())
            .append("mmzl", getMmzl())
            .append("djz", getDjz())
            .append("ljz", getLjz())
            .append("zdzhkwj", getZdzhkwj())
            .append("aqxskwj", getAqxskwj())
            .append("zdzhkny", getZdzhkny())
            .append("aqxskny", getAqxskny())
            .append("zdzhkl", getZdzhkl())
            .append("aqxskl", getAqxskl())
            .append("bz", getBz())
            .append("createdBy", getCreatedBy())
            .append("createdTime", getCreatedTime())
            .append("updateBy", getUpdateBy())
            .append("updateTime", getUpdateTime())
            .toString();
    }
}
