package com.zjsgfa.project.zjsgfa.controller;

import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.zjsgfa.framework.aspectj.lang.annotation.Log;
import com.zjsgfa.framework.aspectj.lang.enums.BusinessType;
import com.zjsgfa.project.zjsgfa.domain.SgfambKcxx;
import com.zjsgfa.project.zjsgfa.service.ISgfambKcxxService;
import com.zjsgfa.framework.web.controller.BaseController;
import com.zjsgfa.framework.web.domain.AjaxResult;
import com.zjsgfa.common.utils.poi.ExcelUtil;
import com.zjsgfa.framework.web.page.TableDataInfo;

/**
 * 施工方案模板管理—开次信息Controller
 * 
 * @author ruoyi
 * @date 2025-09-23
 */
@RestController
@RequestMapping("/system/sgfambKcxx")
public class SgfambKcxxController extends BaseController
{
    @Autowired
    private ISgfambKcxxService sgfambKcxxService;

    /**
     * 查询施工方案模板管理—开次信息列表
     */
    //@PreAuthorize("@ss.hasPermi('system:sgfambKcxx:list')")
    @GetMapping("/list")
    public TableDataInfo list(SgfambKcxx sgfambKcxx)
    {
//        startPage();
        List<SgfambKcxx> list = sgfambKcxxService.selectSgfambKcxxList(sgfambKcxx);
        return getDataTable(list);
    }

    /**
     * 导出施工方案模板管理—开次信息列表
     */
    //@PreAuthorize("@ss.hasPermi('system:sgfambKcxx:export')")
    @Log(title = "施工方案模板管理—开次信息", businessType = BusinessType.EXPORT)
    @PostMapping("/export")
    public void export(HttpServletResponse response, SgfambKcxx sgfambKcxx)
    {
        List<SgfambKcxx> list = sgfambKcxxService.selectSgfambKcxxList(sgfambKcxx);
        ExcelUtil<SgfambKcxx> util = new ExcelUtil<SgfambKcxx>(SgfambKcxx.class);
        util.exportExcel(response, list, "施工方案模板管理—开次信息数据");
    }

    /**
     * 获取施工方案模板管理—开次信息详细信息
     */
    //@PreAuthorize("@ss.hasPermi('system:sgfambKcxx:query')")
    @GetMapping(value = "/{id}")
    public AjaxResult getInfo(@PathVariable("id") Long id)
    {
        return success(sgfambKcxxService.selectSgfambKcxxById(id));
    }

    /**
     * 新增施工方案模板管理—开次信息
     */
    //@PreAuthorize("@ss.hasPermi('system:sgfambKcxx:add')")
    @Log(title = "施工方案模板管理—开次信息", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody SgfambKcxx sgfambKcxx)
    {
        return toAjax(sgfambKcxxService.insertSgfambKcxx(sgfambKcxx));
    }

    /**
     * 修改施工方案模板管理—开次信息
     */
    //@PreAuthorize("@ss.hasPermi('system:sgfambKcxx:edit')")
    @Log(title = "施工方案模板管理—开次信息", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody SgfambKcxx sgfambKcxx)
    {
        return toAjax(sgfambKcxxService.updateSgfambKcxx(sgfambKcxx));
    }

    /**
     * 删除施工方案模板管理—开次信息
     */
    //@PreAuthorize("@ss.hasPermi('system:sgfambKcxx:remove')")
    @Log(title = "施工方案模板管理—开次信息", businessType = BusinessType.DELETE)
	@DeleteMapping("/{ids}")
    public AjaxResult remove(@PathVariable Long[] ids)
    {
        return toAjax(sgfambKcxxService.deleteSgfambKcxxByIds(ids));
    }
}
