package com.ruoyi.project.zt.service.impl;

import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ruoyi.project.zt.mapper.LjZtdfzhMapper;
import com.ruoyi.project.zt.domain.LjZtdfzh;
import com.ruoyi.project.zt.service.ILjZtdfzhService;

/**
 * 邻井-钻头得分综合Service业务层处理
 * 
 * @author ruoyi
 * @date 2025-06-30
 */
@Service
public class LjZtdfzhServiceImpl implements ILjZtdfzhService 
{
    @Autowired
    private LjZtdfzhMapper ljZtdfzhMapper;

    /**
     * 查询邻井-钻头得分综合
     * 
     * @param id 邻井-钻头得分综合主键
     * @return 邻井-钻头得分综合
     */
    @Override
    public LjZtdfzh selectLjZtdfzhById(Long id)
    {
        return ljZtdfzhMapper.selectLjZtdfzhById(id);
    }

    /**
     * 查询邻井-钻头得分综合列表
     * 
     * @param ljZtdfzh 邻井-钻头得分综合
     * @return 邻井-钻头得分综合
     */
    @Override
    public List<LjZtdfzh> selectLjZtdfzhList(LjZtdfzh ljZtdfzh)
    {
        return ljZtdfzhMapper.selectLjZtdfzhList(ljZtdfzh);
    }

    /**
     * 新增邻井-钻头得分综合
     * 
     * @param ljZtdfzh 邻井-钻头得分综合
     * @return 结果
     */
    @Override
    public int insertLjZtdfzh(LjZtdfzh ljZtdfzh)
    {
        return ljZtdfzhMapper.insertLjZtdfzh(ljZtdfzh);
    }

    /**
     * 修改邻井-钻头得分综合
     * 
     * @param ljZtdfzh 邻井-钻头得分综合
     * @return 结果
     */
    @Override
    public int updateLjZtdfzh(LjZtdfzh ljZtdfzh)
    {
        return ljZtdfzhMapper.updateLjZtdfzh(ljZtdfzh);
    }

    /**
     * 批量删除邻井-钻头得分综合
     * 
     * @param ids 需要删除的邻井-钻头得分综合主键
     * @return 结果
     */
    @Override
    public int deleteLjZtdfzhByIds(Long[] ids)
    {
        return ljZtdfzhMapper.deleteLjZtdfzhByIds(ids);
    }

    /**
     * 删除邻井-钻头得分综合信息
     * 
     * @param id 邻井-钻头得分综合主键
     * @return 结果
     */
    @Override
    public int deleteLjZtdfzhById(Long id)
    {
        return ljZtdfzhMapper.deleteLjZtdfzhById(id);
    }
}
