package com.ruoyi.project.zt.controller;

import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.ruoyi.framework.aspectj.lang.annotation.Log;
import com.ruoyi.framework.aspectj.lang.enums.BusinessType;
import com.ruoyi.project.zt.domain.LjZtzhdf;
import com.ruoyi.project.zt.service.ILjZtzhdfService;
import com.ruoyi.framework.web.controller.BaseController;
import com.ruoyi.framework.web.domain.AjaxResult;
import com.ruoyi.common.utils.poi.ExcelUtil;
import com.ruoyi.framework.web.page.TableDataInfo;

/**
 * 钻头综合得分Controller
 * 
 * @author ruoyi
 * @date 2025-06-29
 */
@RestController
@RequestMapping("/system/ljZtzhdf")
public class LjZtzhdfController extends BaseController
{
    @Autowired
    private ILjZtzhdfService ljZtzhdfService;

    /**
     * 查询钻头综合得分列表
     */
    @PreAuthorize("@ss.hasPermi('system:ljZtzhdf:list')")
    @GetMapping("/list")
    public TableDataInfo list(LjZtzhdf ljZtzhdf)
    {
        startPage();
        List<LjZtzhdf> list = ljZtzhdfService.selectLjZtzhdfList(ljZtzhdf);
        return getDataTable(list);
    }

    /**
     * 导出钻头综合得分列表
     */
    @PreAuthorize("@ss.hasPermi('system:ljZtzhdf:export')")
    @Log(title = "钻头综合得分", businessType = BusinessType.EXPORT)
    @PostMapping("/export")
    public void export(HttpServletResponse response, LjZtzhdf ljZtzhdf)
    {
        List<LjZtzhdf> list = ljZtzhdfService.selectLjZtzhdfList(ljZtzhdf);
        ExcelUtil<LjZtzhdf> util = new ExcelUtil<LjZtzhdf>(LjZtzhdf.class);
        util.exportExcel(response, list, "钻头综合得分数据");
    }

    /**
     * 获取钻头综合得分详细信息
     */
    @PreAuthorize("@ss.hasPermi('system:ljZtzhdf:query')")
    @GetMapping(value = "/{id}")
    public AjaxResult getInfo(@PathVariable("id") Long id)
    {
        return success(ljZtzhdfService.selectLjZtzhdfById(id));
    }

    /**
     * 新增钻头综合得分
     */
    @PreAuthorize("@ss.hasPermi('system:ljZtzhdf:add')")
    @Log(title = "钻头综合得分", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody LjZtzhdf ljZtzhdf)
    {
        return toAjax(ljZtzhdfService.insertLjZtzhdf(ljZtzhdf));
    }

    /**
     * 修改钻头综合得分
     */
    @PreAuthorize("@ss.hasPermi('system:ljZtzhdf:edit')")
    @Log(title = "钻头综合得分", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody LjZtzhdf ljZtzhdf)
    {
        return toAjax(ljZtzhdfService.updateLjZtzhdf(ljZtzhdf));
    }

    /**
     * 删除钻头综合得分
     */
    @PreAuthorize("@ss.hasPermi('system:ljZtzhdf:remove')")
    @Log(title = "钻头综合得分", businessType = BusinessType.DELETE)
	@DeleteMapping("/{ids}")
    public AjaxResult remove(@PathVariable Long[] ids)
    {
        return toAjax(ljZtzhdfService.deleteLjZtzhdfByIds(ids));
    }
}
