package com.ruoyi.project.zjsgfa.service.impl;

import java.util.List;
import com.ruoyi.common.utils.DateUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ruoyi.project.zjsgfa.mapper.SjZjyCljlMapper;
import com.ruoyi.project.zjsgfa.domain.SjZjyCljl;
import com.ruoyi.project.zjsgfa.service.ISjZjyCljlService;

/**
 * 设计信息-钻井液材料加量Service业务层处理
 * 
 * @author ruoyi
 * @date 2025-07-17
 */
@Service
public class SjZjyCljlServiceImpl implements ISjZjyCljlService 
{
    @Autowired
    private SjZjyCljlMapper sjZjyCljlMapper;

    /**
     * 查询设计信息-钻井液材料加量
     * 
     * @param id 设计信息-钻井液材料加量主键
     * @return 设计信息-钻井液材料加量
     */
    @Override
    public SjZjyCljl selectSjZjyCljlById(Long id)
    {
        return sjZjyCljlMapper.selectSjZjyCljlById(id);
    }

    /**
     * 查询设计信息-钻井液材料加量列表
     * 
     * @param sjZjyCljl 设计信息-钻井液材料加量
     * @return 设计信息-钻井液材料加量
     */
    @Override
    public List<SjZjyCljl> selectSjZjyCljlList(SjZjyCljl sjZjyCljl)
    {
        return sjZjyCljlMapper.selectSjZjyCljlList(sjZjyCljl);
    }

    /**
     * 新增设计信息-钻井液材料加量
     * 
     * @param sjZjyCljl 设计信息-钻井液材料加量
     * @return 结果
     */
    @Override
    public int insertSjZjyCljl(SjZjyCljl sjZjyCljl)
    {
        return sjZjyCljlMapper.insertSjZjyCljl(sjZjyCljl);
    }

    /**
     * 修改设计信息-钻井液材料加量
     * 
     * @param sjZjyCljl 设计信息-钻井液材料加量
     * @return 结果
     */
    @Override
    public int updateSjZjyCljl(SjZjyCljl sjZjyCljl)
    {
        sjZjyCljl.setUpdateTime(DateUtils.getNowDate());
        return sjZjyCljlMapper.updateSjZjyCljl(sjZjyCljl);
    }

    /**
     * 批量删除设计信息-钻井液材料加量
     * 
     * @param ids 需要删除的设计信息-钻井液材料加量主键
     * @return 结果
     */
    @Override
    public int deleteSjZjyCljlByIds(Long[] ids)
    {
        return sjZjyCljlMapper.deleteSjZjyCljlByIds(ids);
    }

    /**
     * 删除设计信息-钻井液材料加量信息
     * 
     * @param id 设计信息-钻井液材料加量主键
     * @return 结果
     */
    @Override
    public int deleteSjZjyCljlById(Long id)
    {
        return sjZjyCljlMapper.deleteSjZjyCljlById(id);
    }
}
