package com.ruoyi.project.zjsgfa.service.impl;

import java.util.List;
import com.ruoyi.common.utils.DateUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ruoyi.project.zjsgfa.mapper.SjSggyZjyCljlMapper;
import com.ruoyi.project.zjsgfa.domain.SjSggyZjyCljl;
import com.ruoyi.project.zjsgfa.service.ISjSggyZjyCljlService;

/**
 * 设计信息-施工概要-钻井液材料加量Service业务层处理
 * 
 * @author ruoyi
 * @date 2025-08-20
 */
@Service
public class SjSggyZjyCljlServiceImpl implements ISjSggyZjyCljlService 
{
    @Autowired
    private SjSggyZjyCljlMapper sjSggyZjyCljlMapper;

    /**
     * 查询设计信息-施工概要-钻井液材料加量
     * 
     * @param id 设计信息-施工概要-钻井液材料加量主键
     * @return 设计信息-施工概要-钻井液材料加量
     */
    @Override
    public SjSggyZjyCljl selectSjSggyZjyCljlById(Long id)
    {
        return sjSggyZjyCljlMapper.selectSjSggyZjyCljlById(id);
    }

    /**
     * 查询设计信息-施工概要-钻井液材料加量列表
     * 
     * @param sjSggyZjyCljl 设计信息-施工概要-钻井液材料加量
     * @return 设计信息-施工概要-钻井液材料加量
     */
    @Override
    public List<SjSggyZjyCljl> selectSjSggyZjyCljlList(SjSggyZjyCljl sjSggyZjyCljl)
    {
        return sjSggyZjyCljlMapper.selectSjSggyZjyCljlList(sjSggyZjyCljl);
    }

    /**
     * 新增设计信息-施工概要-钻井液材料加量
     * 
     * @param sjSggyZjyCljl 设计信息-施工概要-钻井液材料加量
     * @return 结果
     */
    @Override
    public int insertSjSggyZjyCljl(SjSggyZjyCljl sjSggyZjyCljl)
    {
        return sjSggyZjyCljlMapper.insertSjSggyZjyCljl(sjSggyZjyCljl);
    }

    /**
     * 修改设计信息-施工概要-钻井液材料加量
     * 
     * @param sjSggyZjyCljl 设计信息-施工概要-钻井液材料加量
     * @return 结果
     */
    @Override
    public int updateSjSggyZjyCljl(SjSggyZjyCljl sjSggyZjyCljl)
    {
        sjSggyZjyCljl.setUpdateTime(DateUtils.getNowDate());
        return sjSggyZjyCljlMapper.updateSjSggyZjyCljl(sjSggyZjyCljl);
    }

    /**
     * 批量删除设计信息-施工概要-钻井液材料加量
     * 
     * @param ids 需要删除的设计信息-施工概要-钻井液材料加量主键
     * @return 结果
     */
    @Override
    public int deleteSjSggyZjyCljlByIds(Long[] ids)
    {
        return sjSggyZjyCljlMapper.deleteSjSggyZjyCljlByIds(ids);
    }

    /**
     * 删除设计信息-施工概要-钻井液材料加量信息
     * 
     * @param id 设计信息-施工概要-钻井液材料加量主键
     * @return 结果
     */
    @Override
    public int deleteSjSggyZjyCljlById(Long id)
    {
        return sjSggyZjyCljlMapper.deleteSjSggyZjyCljlById(id);
    }
}
