package com.ruoyi.project.zjsgfa.controller;

import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.ruoyi.framework.aspectj.lang.annotation.Log;
import com.ruoyi.framework.aspectj.lang.enums.BusinessType;
import com.ruoyi.project.zjsgfa.domain.SjTgTgz;
import com.ruoyi.project.zjsgfa.service.ISjTgTgzService;
import com.ruoyi.framework.web.controller.BaseController;
import com.ruoyi.framework.web.domain.AjaxResult;
import com.ruoyi.common.utils.poi.ExcelUtil;
import com.ruoyi.framework.web.page.TableDataInfo;

/**
 * 设计信息-套管柱数据Controller
 * 
 * @author ruoyi
 * @date 2025-07-17
 */
@RestController
@RequestMapping("/system/sjTgTgz")
public class SjTgTgzController extends BaseController
{
    @Autowired
    private ISjTgTgzService sjTgTgzService;

    /**
     * 查询设计信息-套管柱数据列表
     */
    //@PreAuthorize("@ss.hasPermi('system:sjTgTgz:list')")
    @GetMapping("/list")
    public TableDataInfo list(SjTgTgz sjTgTgz)
    {
//        startPage();
        List<SjTgTgz> list = sjTgTgzService.selectSjTgTgzList(sjTgTgz);
        return getDataTable(list);
    }

    /**
     * 导出设计信息-套管柱数据列表
     */
    //@PreAuthorize("@ss.hasPermi('system:sjTgTgz:export')")
    @Log(title = "设计信息-套管柱数据", businessType = BusinessType.EXPORT)
    @PostMapping("/export")
    public void export(HttpServletResponse response, SjTgTgz sjTgTgz)
    {
        List<SjTgTgz> list = sjTgTgzService.selectSjTgTgzList(sjTgTgz);
        ExcelUtil<SjTgTgz> util = new ExcelUtil<SjTgTgz>(SjTgTgz.class);
        util.exportExcel(response, list, "设计信息-套管柱数据数据");
    }

    /**
     * 获取设计信息-套管柱数据详细信息
     */
    //@PreAuthorize("@ss.hasPermi('system:sjTgTgz:query')")
    @GetMapping(value = "/{id}")
    public AjaxResult getInfo(@PathVariable("id") Long id)
    {
        return success(sjTgTgzService.selectSjTgTgzById(id));
    }

    /**
     * 新增设计信息-套管柱数据
     */
    //@PreAuthorize("@ss.hasPermi('system:sjTgTgz:add')")
    @Log(title = "设计信息-套管柱数据", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody SjTgTgz sjTgTgz)
    {
        return toAjax(sjTgTgzService.insertSjTgTgz(sjTgTgz));
    }

    /**
     * 修改设计信息-套管柱数据
     */
    //@PreAuthorize("@ss.hasPermi('system:sjTgTgz:edit')")
    @Log(title = "设计信息-套管柱数据", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody SjTgTgz sjTgTgz)
    {
        return toAjax(sjTgTgzService.updateSjTgTgz(sjTgTgz));
    }

    /**
     * 删除设计信息-套管柱数据
     */
    //@PreAuthorize("@ss.hasPermi('system:sjTgTgz:remove')")
    @Log(title = "设计信息-套管柱数据", businessType = BusinessType.DELETE)
	@DeleteMapping("/{ids}")
    public AjaxResult remove(@PathVariable Long[] ids)
    {
        return toAjax(sjTgTgzService.deleteSjTgTgzByIds(ids));
    }
}
