package com.ruoyi.project.zjsgfa.controller;

import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.ruoyi.framework.aspectj.lang.annotation.Log;
import com.ruoyi.framework.aspectj.lang.enums.BusinessType;
import com.ruoyi.project.zjsgfa.domain.SjZjcsxx;
import com.ruoyi.project.zjsgfa.service.ISjZjcsxxService;
import com.ruoyi.framework.web.controller.BaseController;
import com.ruoyi.framework.web.domain.AjaxResult;
import com.ruoyi.common.utils.poi.ExcelUtil;
import com.ruoyi.framework.web.page.TableDataInfo;

/**
 * 设计-钻具参数信息Controller
 * 
 * @author ruoyi
 * @date 2025-08-18
 */
@RestController
@RequestMapping("/system/sjZjcsxx")
public class SjZjcsxxController extends BaseController
{
    @Autowired
    private ISjZjcsxxService sjZjcsxxService;

    /**
     * 查询设计-钻具参数信息列表
     */
    //@PreAuthorize("@ss.hasPermi('system:sjZjcsxx:list')")
    @GetMapping("/list")
    public TableDataInfo list(SjZjcsxx sjZjcsxx)
    {
        startPage();
        List<SjZjcsxx> list = sjZjcsxxService.selectSjZjcsxxList(sjZjcsxx);
        return getDataTable(list);
    }

    /**
     * 导出设计-钻具参数信息列表
     */
    //@PreAuthorize("@ss.hasPermi('system:sjZjcsxx:export')")
    @Log(title = "设计-钻具参数信息", businessType = BusinessType.EXPORT)
    @PostMapping("/export")
    public void export(HttpServletResponse response, SjZjcsxx sjZjcsxx)
    {
        List<SjZjcsxx> list = sjZjcsxxService.selectSjZjcsxxList(sjZjcsxx);
        ExcelUtil<SjZjcsxx> util = new ExcelUtil<SjZjcsxx>(SjZjcsxx.class);
        util.exportExcel(response, list, "设计-钻具参数信息数据");
    }

    /**
     * 获取设计-钻具参数信息详细信息
     */
    //@PreAuthorize("@ss.hasPermi('system:sjZjcsxx:query')")
    @GetMapping(value = "/{id}")
    public AjaxResult getInfo(@PathVariable("id") Long id)
    {
        return success(sjZjcsxxService.selectSjZjcsxxById(id));
    }

    /**
     * 新增设计-钻具参数信息
     */
    //@PreAuthorize("@ss.hasPermi('system:sjZjcsxx:add')")
    @Log(title = "设计-钻具参数信息", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody SjZjcsxx sjZjcsxx)
    {
        return toAjax(sjZjcsxxService.insertSjZjcsxx(sjZjcsxx));
    }

    /**
     * 修改设计-钻具参数信息
     */
    //@PreAuthorize("@ss.hasPermi('system:sjZjcsxx:edit')")
    @Log(title = "设计-钻具参数信息", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody SjZjcsxx sjZjcsxx)
    {
        return toAjax(sjZjcsxxService.updateSjZjcsxx(sjZjcsxx));
    }

    /**
     * 删除设计-钻具参数信息
     */
    //@PreAuthorize("@ss.hasPermi('system:sjZjcsxx:remove')")
    @Log(title = "设计-钻具参数信息", businessType = BusinessType.DELETE)
	@DeleteMapping("/{ids}")
    public AjaxResult remove(@PathVariable Long[] ids)
    {
        return toAjax(sjZjcsxxService.deleteSjZjcsxxByIds(ids));
    }
}
