package com.ruoyi.project.zjsgfa.controller;

import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.ruoyi.framework.aspectj.lang.annotation.Log;
import com.ruoyi.framework.aspectj.lang.enums.BusinessType;
import com.ruoyi.project.zjsgfa.domain.SjJygjGdfdcs;
import com.ruoyi.project.zjsgfa.service.ISjJygjGdfdcsService;
import com.ruoyi.framework.web.controller.BaseController;
import com.ruoyi.framework.web.domain.AjaxResult;
import com.ruoyi.common.utils.poi.ExcelUtil;
import com.ruoyi.framework.web.page.TableDataInfo;

/**
 * 设计信息-井眼轨迹_轨道分段参数Controller
 * 
 * @author ruoyi
 * @date 2025-06-26
 */
@RestController
@RequestMapping("/system/sjJygjGdfdcs")
public class SjJygjGdfdcsController extends BaseController
{
    @Autowired
    private ISjJygjGdfdcsService sjJygjGdfdcsService;

    /**
     * 查询设计信息-井眼轨迹_轨道分段参数列表
     */
    //@PreAuthorize("@ss.hasPermi('system:sjJygjGdfdcs:list')")
    @GetMapping("/list")
    public TableDataInfo list(SjJygjGdfdcs sjJygjGdfdcs)
    {
//        startPage();
        List<SjJygjGdfdcs> list = sjJygjGdfdcsService.selectSjJygjGdfdcsList(sjJygjGdfdcs);
        return getDataTable(list);
    }

    /**
     * 导出设计信息-井眼轨迹_轨道分段参数列表
     */
    //@PreAuthorize("@ss.hasPermi('system:sjJygjGdfdcs:export')")
    @Log(title = "设计信息-井眼轨迹_轨道分段参数", businessType = BusinessType.EXPORT)
    @PostMapping("/export")
    public void export(HttpServletResponse response, SjJygjGdfdcs sjJygjGdfdcs)
    {
        List<SjJygjGdfdcs> list = sjJygjGdfdcsService.selectSjJygjGdfdcsList(sjJygjGdfdcs);
        ExcelUtil<SjJygjGdfdcs> util = new ExcelUtil<SjJygjGdfdcs>(SjJygjGdfdcs.class);
        util.exportExcel(response, list, "设计信息-井眼轨迹_轨道分段参数数据");
    }

    /**
     * 获取设计信息-井眼轨迹_轨道分段参数详细信息
     */
    //@PreAuthorize("@ss.hasPermi('system:sjJygjGdfdcs:query')")
    @GetMapping(value = "/{id}")
    public AjaxResult getInfo(@PathVariable("id") Long id)
    {
        return success(sjJygjGdfdcsService.selectSjJygjGdfdcsById(id));
    }

    /**
     * 新增设计信息-井眼轨迹_轨道分段参数
     */
    //@PreAuthorize("@ss.hasPermi('system:sjJygjGdfdcs:add')")
    @Log(title = "设计信息-井眼轨迹_轨道分段参数", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody SjJygjGdfdcs sjJygjGdfdcs)
    {
        return toAjax(sjJygjGdfdcsService.insertSjJygjGdfdcs(sjJygjGdfdcs));
    }

    /**
     * 修改设计信息-井眼轨迹_轨道分段参数
     */
    //@PreAuthorize("@ss.hasPermi('system:sjJygjGdfdcs:edit')")
    @Log(title = "设计信息-井眼轨迹_轨道分段参数", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody SjJygjGdfdcs sjJygjGdfdcs)
    {
        return toAjax(sjJygjGdfdcsService.updateSjJygjGdfdcs(sjJygjGdfdcs));
    }

    /**
     * 删除设计信息-井眼轨迹_轨道分段参数
     */
    //@PreAuthorize("@ss.hasPermi('system:sjJygjGdfdcs:remove')")
    @Log(title = "设计信息-井眼轨迹_轨道分段参数", businessType = BusinessType.DELETE)
	@DeleteMapping("/{ids}")
    public AjaxResult remove(@PathVariable Long[] ids)
    {
        return toAjax(sjJygjGdfdcsService.deleteSjJygjGdfdcsByIds(ids));
    }
}
