package com.ruoyi.project.zjsgfa.controller;

import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.ruoyi.framework.aspectj.lang.annotation.Log;
import com.ruoyi.framework.aspectj.lang.enums.BusinessType;
import com.ruoyi.project.zjsgfa.domain.SjFdsgcsZjyFdxnb;
import com.ruoyi.project.zjsgfa.service.ISjFdsgcsZjyFdxnbService;
import com.ruoyi.framework.web.controller.BaseController;
import com.ruoyi.framework.web.domain.AjaxResult;
import com.ruoyi.common.utils.poi.ExcelUtil;
import com.ruoyi.framework.web.page.TableDataInfo;

/**
 * 设计信息-分段施工措施-分段钻井液性能设计Controller
 * 
 * @author ruoyi
 * @date 2025-08-20
 */
@RestController
@RequestMapping("/system/sjFdsgcsZjyFdxnb")
public class SjFdsgcsZjyFdxnbController extends BaseController
{
    @Autowired
    private ISjFdsgcsZjyFdxnbService sjFdsgcsZjyFdxnbService;

    /**
     * 查询设计信息-分段施工措施-分段钻井液性能设计列表
     */
    //@PreAuthorize("@ss.hasPermi('system:sjFdsgcsZjyFdxnb:list')")
    @GetMapping("/list")
    public AjaxResult list(SjFdsgcsZjyFdxnb sjFdsgcsZjyFdxnb)
    {
        Map<String, Object> list = sjFdsgcsZjyFdxnbService.selectSjFdsgcsZjyFdxnbList(sjFdsgcsZjyFdxnb);
        return AjaxResult.success(list);
    }

    /**
     * 导出设计信息-分段施工措施-分段钻井液性能设计列表
     */
    //@PreAuthorize("@ss.hasPermi('system:sjFdsgcsZjyFdxnb:export')")
    @Log(title = "设计信息-分段施工措施-分段钻井液性能设计", businessType = BusinessType.EXPORT)
    @PostMapping("/export")
    public void export(HttpServletResponse response, SjFdsgcsZjyFdxnb sjFdsgcsZjyFdxnb)
    {
//        List<SjFdsgcsZjyFdxnb> list = sjFdsgcsZjyFdxnbService.selectSjFdsgcsZjyFdxnbList(sjFdsgcsZjyFdxnb);
//        ExcelUtil<SjFdsgcsZjyFdxnb> util = new ExcelUtil<SjFdsgcsZjyFdxnb>(SjFdsgcsZjyFdxnb.class);
//        util.exportExcel(response, list, "设计信息-分段施工措施-分段钻井液性能设计数据");
    }

    /**
     * 获取设计信息-分段施工措施-分段钻井液性能设计详细信息
     */
    //@PreAuthorize("@ss.hasPermi('system:sjFdsgcsZjyFdxnb:query')")
    @GetMapping(value = "/{id}")
    public AjaxResult getInfo(@PathVariable("id") Long id)
    {
        return success(sjFdsgcsZjyFdxnbService.selectSjFdsgcsZjyFdxnbById(id));
    }

    /**
     * 新增设计信息-分段施工措施-分段钻井液性能设计
     */
    //@PreAuthorize("@ss.hasPermi('system:sjFdsgcsZjyFdxnb:add')")
    @Log(title = "设计信息-分段施工措施-分段钻井液性能设计", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody SjFdsgcsZjyFdxnb sjFdsgcsZjyFdxnb)
    {
        return toAjax(sjFdsgcsZjyFdxnbService.insertSjFdsgcsZjyFdxnb(sjFdsgcsZjyFdxnb));
    }

    /**
     * 修改设计信息-分段施工措施-分段钻井液性能设计
     */
    //@PreAuthorize("@ss.hasPermi('system:sjFdsgcsZjyFdxnb:edit')")
    @Log(title = "设计信息-分段施工措施-分段钻井液性能设计", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody SjFdsgcsZjyFdxnb sjFdsgcsZjyFdxnb)
    {
        return toAjax(sjFdsgcsZjyFdxnbService.updateSjFdsgcsZjyFdxnb(sjFdsgcsZjyFdxnb));
    }

    @PostMapping("/pledit")
    public AjaxResult pledit(@RequestBody SjFdsgcsZjyFdxnb sjFdsgcsZjyFdxnb)
    {
        return toAjax(sjFdsgcsZjyFdxnbService.pledit(sjFdsgcsZjyFdxnb.getList()));
    }

    /**
     * 删除设计信息-分段施工措施-分段钻井液性能设计
     */
    //@PreAuthorize("@ss.hasPermi('system:sjFdsgcsZjyFdxnb:remove')")
    @Log(title = "设计信息-分段施工措施-分段钻井液性能设计", businessType = BusinessType.DELETE)
	@DeleteMapping("/{ids}")
    public AjaxResult remove(@PathVariable Long[] ids)
    {
        return toAjax(sjFdsgcsZjyFdxnbService.deleteSjFdsgcsZjyFdxnbByIds(ids));
    }

}
