package com.zjsgfa.project.zjsgfa.service.impl;

import java.util.List;
import com.zjsgfa.common.utils.DateUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.zjsgfa.project.zjsgfa.mapper.SjZlyqXxMapper;
import com.zjsgfa.project.zjsgfa.domain.SjZlyqXx;
import com.zjsgfa.project.zjsgfa.service.ISjZlyqXxService;

/**
 * 设计信息-井身质量要求详细Service业务层处理
 * 
 * @author
 * @date 2025-07-17
 */
@Service
public class SjZlyqXxServiceImpl implements ISjZlyqXxService 
{
    @Autowired
    private SjZlyqXxMapper sjZlyqXxMapper;

    /**
     * 查询设计信息-井身质量要求详细
     * 
     * @param id 设计信息-井身质量要求详细主键
     * @return 设计信息-井身质量要求详细
     */
    @Override
    public SjZlyqXx selectSjZlyqXxById(Long id)
    {
        return sjZlyqXxMapper.selectSjZlyqXxById(id);
    }

    /**
     * 查询设计信息-井身质量要求详细列表
     * 
     * @param sjZlyqXx 设计信息-井身质量要求详细
     * @return 设计信息-井身质量要求详细
     */
    @Override
    public List<SjZlyqXx> selectSjZlyqXxList(SjZlyqXx sjZlyqXx)
    {
        return sjZlyqXxMapper.selectSjZlyqXxList(sjZlyqXx);
    }

    /**
     * 新增设计信息-井身质量要求详细
     * 
     * @param sjZlyqXx 设计信息-井身质量要求详细
     * @return 结果
     */
    @Override
    public int insertSjZlyqXx(SjZlyqXx sjZlyqXx)
    {
        return sjZlyqXxMapper.insertSjZlyqXx(sjZlyqXx);
    }

    /**
     * 修改设计信息-井身质量要求详细
     * 
     * @param sjZlyqXx 设计信息-井身质量要求详细
     * @return 结果
     */
    @Override
    public int updateSjZlyqXx(SjZlyqXx sjZlyqXx)
    {
        sjZlyqXx.setUpdateTime(DateUtils.getNowDate());
        return sjZlyqXxMapper.updateSjZlyqXx(sjZlyqXx);
    }

    /**
     * 批量删除设计信息-井身质量要求详细
     * 
     * @param ids 需要删除的设计信息-井身质量要求详细主键
     * @return 结果
     */
    @Override
    public int deleteSjZlyqXxByIds(Long[] ids)
    {
        return sjZlyqXxMapper.deleteSjZlyqXxByIds(ids);
    }

    /**
     * 删除设计信息-井身质量要求详细信息
     * 
     * @param id 设计信息-井身质量要求详细主键
     * @return 结果
     */
    @Override
    public int deleteSjZlyqXxById(Long id)
    {
        return sjZlyqXxMapper.deleteSjZlyqXxById(id);
    }
}
