package com.zjsgfa.project.zjsgfa.controller;

import java.util.List;
import javax.servlet.http.HttpServletResponse;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.zjsgfa.framework.aspectj.lang.annotation.Log;
import com.zjsgfa.framework.aspectj.lang.enums.BusinessType;
import com.zjsgfa.project.zjsgfa.domain.SjZtxx;
import com.zjsgfa.project.zjsgfa.service.ISjZtxxService;
import com.zjsgfa.framework.web.controller.BaseController;
import com.zjsgfa.framework.web.domain.AjaxResult;
import com.zjsgfa.common.utils.poi.ExcelUtil;
import com.zjsgfa.framework.web.page.TableDataInfo;

/**
 * 设计-钻头选型Controller
 * 
 * @author
 * @date 2025-08-18
 */
@RestController
@RequestMapping("/system/sjZtxx")
public class SjZtxxController extends BaseController
{
    @Autowired
    private ISjZtxxService sjZtxxService;

    /**
     * 查询设计-钻头选型列表
     */
    //@PreAuthorize("@ss.hasPermi('system:sjZtxx:list')")
    @GetMapping("/list")
    public TableDataInfo list(SjZtxx sjZtxx)
    {
        startPage();
        List<SjZtxx> list = sjZtxxService.selectSjZtxxList(sjZtxx);
        return getDataTable(list);
    }

    /**
     * 导出设计-钻头选型列表
     */
    //@PreAuthorize("@ss.hasPermi('system:sjZtxx:export')")
    @Log(title = "设计-钻头选型", businessType = BusinessType.EXPORT)
    @PostMapping("/export")
    public void export(HttpServletResponse response, SjZtxx sjZtxx)
    {
        List<SjZtxx> list = sjZtxxService.selectSjZtxxList(sjZtxx);
        ExcelUtil<SjZtxx> util = new ExcelUtil<SjZtxx>(SjZtxx.class);
        util.exportExcel(response, list, "设计-钻头选型数据");
    }

    /**
     * 获取设计-钻头选型详细信息
     */
    //@PreAuthorize("@ss.hasPermi('system:sjZtxx:query')")
    @GetMapping(value = "/{id}")
    public AjaxResult getInfo(@PathVariable("id") Long id)
    {
        return success(sjZtxxService.selectSjZtxxById(id));
    }

    /**
     * 新增设计-钻头选型
     */
    //@PreAuthorize("@ss.hasPermi('system:sjZtxx:add')")
    @Log(title = "设计-钻头选型", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody SjZtxx sjZtxx)
    {
        return toAjax(sjZtxxService.insertSjZtxx(sjZtxx));
    }

    /**
     * 修改设计-钻头选型
     */
    //@PreAuthorize("@ss.hasPermi('system:sjZtxx:edit')")
    @Log(title = "设计-钻头选型", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody SjZtxx sjZtxx)
    {
        return toAjax(sjZtxxService.updateSjZtxx(sjZtxx));
    }

    /**
     * 删除设计-钻头选型
     */
    //@PreAuthorize("@ss.hasPermi('system:sjZtxx:remove')")
    @Log(title = "设计-钻头选型", businessType = BusinessType.DELETE)
	@DeleteMapping("/{ids}")
    public AjaxResult remove(@PathVariable Long[] ids)
    {
        return toAjax(sjZtxxService.deleteSjZtxxByIds(ids));
    }
}
