package com.zjsgfa.project.zt.domain;

import java.util.Date;
import java.util.List;

import lombok.Data;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.zjsgfa.framework.aspectj.lang.annotation.Excel;
import com.zjsgfa.framework.web.domain.BaseEntity;

/**
 * 邻井-实钻分析结果对象 lj_szfxjg
 * 
 * @author
 * @date 2025-06-29
 */
@Data
public class LjSzfxjg extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** 主键 */
    private Long id;

    /** 功能模块 */
//    @Excel(name = "功能模块")
    private String gnmk;

    /** 分析范围 */
    @Excel(name = "分析范围")
    private String fxfw;

    /** 分析对象 */
    @Excel(name = "分析对象")
    private String fxdx;

    /** 分析现象 */
    @Excel(name = "分析现象")
    private String fxxy;

    /** 分析结论 */
//    @Excel(name = "分析结论")
    private String fxjl;

    /** 输出方向 */
    @Excel(name = "输出方向")
    private String scfx;

    /** 优选依据 */
    @Excel(name = "优选依据")
    private String yxyj;

    /** 最优建议 */
    @Excel(name = "最优建议")
    private String zyjy;

    /** 其次建议 */
    @Excel(name = "其次建议")
    private String qcyj;

    /** 推荐评分 */
    @Excel(name = "推荐评分")
    private Double tjpf;

    /** 详细参数 */
//    @Excel(name = "详细参数")
    private String xxcs;

    /** 创建人 */
//    @Excel(name = "创建人")
    private String createdBy;

    /** 创建时间 */
//    @JsonFormat(pattern = "yyyy-MM-dd")
//    @Excel(name = "创建时间", width = 30, dateFormat = "yyyy-MM-dd")
    private Date createdTime;

    private List<LjSzfxjg> list;

    public void setId(Long id) 
    {
        this.id = id;
    }

    public Long getId() 
    {
        return id;
    }

    public void setGnmk(String gnmk) 
    {
        this.gnmk = gnmk;
    }

    public String getGnmk() 
    {
        return gnmk;
    }

    public void setFxfw(String fxfw) 
    {
        this.fxfw = fxfw;
    }

    public String getFxfw() 
    {
        return fxfw;
    }

    public void setFxdx(String fxdx) 
    {
        this.fxdx = fxdx;
    }

    public String getFxdx() 
    {
        return fxdx;
    }

    public void setFxxy(String fxxy) 
    {
        this.fxxy = fxxy;
    }

    public String getFxxy() 
    {
        return fxxy;
    }

    public void setFxjl(String fxjl) 
    {
        this.fxjl = fxjl;
    }

    public String getFxjl() 
    {
        return fxjl;
    }

    public void setScfx(String scfx) 
    {
        this.scfx = scfx;
    }

    public String getScfx() 
    {
        return scfx;
    }

    public void setYxyj(String yxyj) 
    {
        this.yxyj = yxyj;
    }

    public String getYxyj() 
    {
        return yxyj;
    }

    public void setZyjy(String zyjy) 
    {
        this.zyjy = zyjy;
    }

    public String getZyjy() 
    {
        return zyjy;
    }

    public void setQcyj(String qcyj) 
    {
        this.qcyj = qcyj;
    }

    public String getQcyj() 
    {
        return qcyj;
    }

    public void setTjpf(Double tjpf)
    {
        this.tjpf = tjpf;
    }

    public Double getTjpf()
    {
        return tjpf;
    }

    public void setXxcs(String xxcs) 
    {
        this.xxcs = xxcs;
    }

    public String getXxcs() 
    {
        return xxcs;
    }

    public void setCreatedBy(String createdBy) 
    {
        this.createdBy = createdBy;
    }

    public String getCreatedBy() 
    {
        return createdBy;
    }

    public void setCreatedTime(Date createdTime) 
    {
        this.createdTime = createdTime;
    }

    public Date getCreatedTime() 
    {
        return createdTime;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this,ToStringStyle.MULTI_LINE_STYLE)
            .append("id", getId())
            .append("gnmk", getGnmk())
            .append("fxfw", getFxfw())
            .append("fxdx", getFxdx())
            .append("fxxy", getFxxy())
            .append("fxjl", getFxjl())
            .append("scfx", getScfx())
            .append("yxyj", getYxyj())
            .append("zyjy", getZyjy())
            .append("qcyj", getQcyj())
            .append("tjpf", getTjpf())
            .append("xxcs", getXxcs())
            .append("createdBy", getCreatedBy())
            .append("createdTime", getCreatedTime())
            .append("updateBy", getUpdateBy())
            .append("updateTime", getUpdateTime())
            .toString();
    }
}
