package com.zjsgfa.project.zjsgfa.service.impl;

import java.util.List;
import com.zjsgfa.common.utils.DateUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.zjsgfa.project.zjsgfa.mapper.SjTgTgqdjhMapper;
import com.zjsgfa.project.zjsgfa.domain.SjTgTgqdjh;
import com.zjsgfa.project.zjsgfa.service.ISjTgTgqdjhService;

/**
 * 设计信息-套管柱强度校核Service业务层处理
 * 
 * @author
 * @date 2025-07-17
 */
@Service
public class SjTgTgqdjhServiceImpl implements ISjTgTgqdjhService 
{
    @Autowired
    private SjTgTgqdjhMapper sjTgTgqdjhMapper;

    /**
     * 查询设计信息-套管柱强度校核
     * 
     * @param id 设计信息-套管柱强度校核主键
     * @return 设计信息-套管柱强度校核
     */
    @Override
    public SjTgTgqdjh selectSjTgTgqdjhById(Long id)
    {
        return sjTgTgqdjhMapper.selectSjTgTgqdjhById(id);
    }

    /**
     * 查询设计信息-套管柱强度校核列表
     * 
     * @param sjTgTgqdjh 设计信息-套管柱强度校核
     * @return 设计信息-套管柱强度校核
     */
    @Override
    public List<SjTgTgqdjh> selectSjTgTgqdjhList(SjTgTgqdjh sjTgTgqdjh)
    {
        return sjTgTgqdjhMapper.selectSjTgTgqdjhList(sjTgTgqdjh);
    }

    /**
     * 新增设计信息-套管柱强度校核
     * 
     * @param sjTgTgqdjh 设计信息-套管柱强度校核
     * @return 结果
     */
    @Override
    public int insertSjTgTgqdjh(SjTgTgqdjh sjTgTgqdjh)
    {
        return sjTgTgqdjhMapper.insertSjTgTgqdjh(sjTgTgqdjh);
    }

    /**
     * 修改设计信息-套管柱强度校核
     * 
     * @param sjTgTgqdjh 设计信息-套管柱强度校核
     * @return 结果
     */
    @Override
    public int updateSjTgTgqdjh(SjTgTgqdjh sjTgTgqdjh)
    {
        sjTgTgqdjh.setUpdateTime(DateUtils.getNowDate());
        return sjTgTgqdjhMapper.updateSjTgTgqdjh(sjTgTgqdjh);
    }

    /**
     * 批量删除设计信息-套管柱强度校核
     * 
     * @param ids 需要删除的设计信息-套管柱强度校核主键
     * @return 结果
     */
    @Override
    public int deleteSjTgTgqdjhByIds(Long[] ids)
    {
        return sjTgTgqdjhMapper.deleteSjTgTgqdjhByIds(ids);
    }

    /**
     * 删除设计信息-套管柱强度校核信息
     * 
     * @param id 设计信息-套管柱强度校核主键
     * @return 结果
     */
    @Override
    public int deleteSjTgTgqdjhById(Long id)
    {
        return sjTgTgqdjhMapper.deleteSjTgTgqdjhById(id);
    }
}
