package com.zjsgfa.project.zjsgfa.service.impl;

import java.nio.charset.StandardCharsets;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.*;
import java.util.stream.Collectors;

import cn.hutool.core.codec.Base64;
import cn.hutool.http.HttpRequest;
import com.google.gson.*;
import com.zjsgfa.common.utils.DateUtils;
import com.zjsgfa.common.utils.StringUtils;
import com.zjsgfa.framework.util.HttpsPostUtil;
import com.zjsgfa.framework.util.HttpsSkipVerifyUtil;
import com.zjsgfa.project.zjsgfa.domain.*;
import com.zjsgfa.project.zjsgfa.mapper.*;
import com.zjsgfa.project.zjsgfa.util.CxszhUtil;
import com.zjsgfa.project.zt.domain.*;
import com.zjsgfa.project.zt.mapper.DjdcInfoMapper;
import com.zjsgfa.project.zt.mapper.JsqaMapper;
import com.zjsgfa.project.zt.service.DjdcService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.zjsgfa.project.zjsgfa.service.ISjFdsgcsService;

/**
 * 设计-分段施工措施Service业务层处理
 * 
 * @author
 * @date 2025-08-06
 */
@Service
public class SjFdsgcsServiceImpl implements ISjFdsgcsService 
{
    @Autowired
    private SjFdsgcsMapper sjFdsgcsMapper;

    @Autowired
    private SjDjjcMapper sjDjjcMapper;
    @Autowired
    private SjJsjgMapper sjJsjgMapper;
    @Autowired
    private SjLjjwMapper sjLjjwMapper;

    @Autowired
    private SjQkztfxMapper sjQkztfxMapper;

    @Autowired
    private SjFdsgcsDcyxMapper sjFdsgcsDcyxMapper;

    @Autowired
    private SjJygjGdsjgdcsMapper sjJygjGdsjgdcsMapper;

    @Autowired
    private JsqaMapper jsqaMapper;

    @Autowired
    private ClFxsbMapper clFxsbMapper;

    @Autowired
    private SjZysxMapper sjZysxMapper;

    @Autowired
    private SjSggyZjzhcsMapper sjSggyZjzhcsMapper;


    @Autowired
    private SjSggyGjsbxnyqMapper sjSggyGjsbxnyqMapper;
    @Autowired
    private DjdcService djdcService;

    @Autowired
    private SgfambKcSggyMapper sgfambKcSggyMapper;
    @Autowired
    private DjdcInfoMapper djdcInfoMapper;
    @Autowired
    private SjJygjGdfdcsMapper sjJygjGdfdcsMapper;

    @Autowired
    private SjFdsgcsDcylZjymdsjbMapper sjFdsgcsDcylZjymdsjbMapper;

    @Autowired
    private SjFdsgcsDcylZjymdtjbMapper sjFdsgcsDcylZjymdtjbMapper;


    /**
     * 查询设计-分段施工措施
     * 
     * @param id 设计-分段施工措施主键
     * @return 设计-分段施工措施
     */
    @Override
    public SjFdsgcs selectSjFdsgcsById(Long id)
    {
        return sjFdsgcsMapper.selectSjFdsgcsById(id);
    }

    /**
     * 查询设计-分段施工措施列表
     * 
     * @param sjFdsgcs 设计-分段施工措施
     * @return 设计-分段施工措施
     */
    @Override
    public List<SjFdsgcs> selectSjFdsgcsList(SjFdsgcs sjFdsgcs)
    {
        return sjFdsgcsMapper.selectSjFdsgcsList(sjFdsgcs);
    }

    /**
     * 新增设计-分段施工措施
     * 
     * @param sjFdsgcs 设计-分段施工措施
     * @return 结果
     */
    @Override
    public int insertSjFdsgcs(SjFdsgcs sjFdsgcs)
    {
        return sjFdsgcsMapper.insertSjFdsgcs(sjFdsgcs);
    }

    /**
     * 修改设计-分段施工措施
     * 
     * @param sjFdsgcs 设计-分段施工措施
     * @return 结果
     */
    @Override
    public int updateSjFdsgcs(SjFdsgcs sjFdsgcs)
    {

        if(StringUtils.isNotEmpty(sjFdsgcs.getGjfx())){
            String s = new String(Base64.decode(sjFdsgcs.getGjfx()), StandardCharsets.UTF_8);
            sjFdsgcs.setGjfx(s);
        }


        if(StringUtils.isNotEmpty(sjFdsgcs.getGjyh())){
            String s = new String(Base64.decode(sjFdsgcs.getGjyh()), StandardCharsets.UTF_8);
            sjFdsgcs.setGjyh(s);
            //保存到施工概要
            SjSggyGjsbxnyq sjSggyGjsbxnyq = new SjSggyGjsbxnyq();
            sjSggyGjsbxnyq.setJh(sjFdsgcs.getJh());
            List<SjSggyGjsbxnyq> sjSggyGjsbxnyqs = sjSggyGjsbxnyqMapper.selectSjSggyGjsbxnyqList(sjSggyGjsbxnyq);
            SjFdsgcs sjFdsgcs1=new SjFdsgcs();
            sjFdsgcs1.setJh(sjFdsgcs.getJh());
            List<SjFdsgcs> sjFdsgcs2 = sjFdsgcsMapper.selectSjFdsgcsList(sjFdsgcs1);

            List<String> strs=new ArrayList<>();
            sjFdsgcs2.forEach(item->{
                if(StringUtils.isNotEmpty(item.getGjyh())){
                    if(item.getKc().equals(sjFdsgcs.getKc())){
                        strs.add("<p>"+item.getKc()+"</p>:"+s);
                    }else {
                        strs.add("<p>"+item.getKc()+"</p>:"+item.getGjyh());
                    }
                }
            });


            if(sjSggyGjsbxnyqs.size()>0){
                SjSggyGjsbxnyq sjSggyGjsbxnyq1 = sjSggyGjsbxnyqs.get(0);

                sjSggyGjsbxnyq1.setSjyh(String.join(" \n",strs.stream().distinct().collect(Collectors.toList())));
                sjSggyGjsbxnyqMapper.updateSjSggyGjsbxnyq(sjSggyGjsbxnyq1);
            }else {
                sjSggyGjsbxnyq.setSjyh(String.join(" \n",strs.stream().distinct().collect(Collectors.toList())));
                sjSggyGjsbxnyqMapper.insertSjSggyGjsbxnyq(sjSggyGjsbxnyq);
            }


        }


        if(StringUtils.isNotEmpty(sjFdsgcs.getDcyl())){
            String s = new String(Base64.decode(sjFdsgcs.getDcyl()), StandardCharsets.UTF_8);
            sjFdsgcs.setDcyl(s);
        }

        if(StringUtils.isNotEmpty(sjFdsgcs.getZyfx())){
            String s = new String(Base64.decode(sjFdsgcs.getZyfx()), StandardCharsets.UTF_8);
            sjFdsgcs.setZyfx(s);
        }

        if(StringUtils.isNotEmpty(sjFdsgcs.getFxgkcs())){
            String s = new String(Base64.decode(sjFdsgcs.getFxgkcs()), StandardCharsets.UTF_8);
            sjFdsgcs.setFxgkcs(s);
        }

        if(StringUtils.isNotEmpty(sjFdsgcs.getZjycs())){
            String s = new String(Base64.decode(sjFdsgcs.getZjycs()), StandardCharsets.UTF_8);
            sjFdsgcs.setZjycs(s);
        }

        if(StringUtils.isNotEmpty(sjFdsgcs.getZjgccs())){
            String s = new String(Base64.decode(sjFdsgcs.getZjgccs()), StandardCharsets.UTF_8);
            sjFdsgcs.setZjgccs(s);
        }
        if(StringUtils.isNotEmpty(sjFdsgcs.getZjzh())){
            String s = new String(Base64.decode(sjFdsgcs.getZjzh()), StandardCharsets.UTF_8);
            sjFdsgcs.setZjzh(s);
            //查询井段信息
            SjJsjg sjJsjg = new SjJsjg();
            sjJsjg.setJh(sjFdsgcs.getJh());
            List<SjJsjg> sjJsjgList = sjJsjgMapper.selectSjJsjgList(sjJsjg);
            double ksjs=0;
            String jd ="";
            for(int i=0;i<sjJsjgList.size();i++) {
                SjJsjg sjJsjg1 = sjJsjgList.get(i);
                if(sjFdsgcs.getKc().equals(sjJsjg1.getKc())){
                    if (i == 0) {
                        ksjs = 0;
                    } else {
                        ksjs = sjJsjgList.get(i - 1).getJs();
                    }
                    jd=ksjs+"-"+sjJsjg1.getJs();

                }
            }
            SjSggyZjzhcs sjSggyZjzhcs= new SjSggyZjzhcs();
            sjSggyZjzhcs.setJh(sjFdsgcs.getJh());
            sjSggyZjzhcs.setKc(sjFdsgcs.getKc());
            SjSggyZjzhcs sjSggyZjzhcs1 = sjSggyZjzhcsMapper.selectSjSggyZjzhcsByZjzhcs(sjSggyZjzhcs);
            if(sjSggyZjzhcs1!=null){
                sjSggyZjzhcs1.setZjjg(s);
                sjSggyZjzhcs1.setJd(jd);
                sjSggyZjzhcsMapper.updateSjSggyZjzhcs(sjSggyZjzhcs1);
            }else {
                sjSggyZjzhcs1=new SjSggyZjzhcs();
                sjSggyZjzhcs1.setJh(sjFdsgcs.getJh());
                sjSggyZjzhcs1.setKc(sjFdsgcs.getKc());
                sjSggyZjzhcs1.setJd(jd);
                sjSggyZjzhcs1.setZjjg(s);
                sjSggyZjzhcsMapper.insertSjSggyZjzhcs(sjSggyZjzhcs1);
            }
        }
        if(StringUtils.isNotEmpty(sjFdsgcs.getZjzhzysx())){
            String s = new String(Base64.decode(sjFdsgcs.getZjzhzysx()), StandardCharsets.UTF_8);
            sjFdsgcs.setZjzhzysx(s);
        }


        return sjFdsgcsMapper.updateSjFdsgcs(sjFdsgcs);
    }

    /**
     * 批量删除设计-分段施工措施
     * 
     * @param ids 需要删除的设计-分段施工措施主键
     * @return 结果
     */
    @Override
    public int deleteSjFdsgcsByIds(Long[] ids)
    {
        return sjFdsgcsMapper.deleteSjFdsgcsByIds(ids);
    }

    /**
     * 删除设计-分段施工措施信息
     * 
     * @param id 设计-分段施工措施主键
     * @return 结果
     */
    @Override
    public int deleteSjFdsgcsById(Long id)
    {
        return sjFdsgcsMapper.deleteSjFdsgcsById(id);
    }

    @Override
    public void jsfdsgcs(SjFdsgcs sjFdsgcs) {
        SjJsjg sjJsjg =new SjJsjg();
        sjJsjg.setJh(sjFdsgcs.getJh());
        List<SjJsjg> sjJsjgList = sjJsjgMapper.selectSjJsjgList(sjJsjg);
        //查询邻井
        SjLjjw sjLjjw =new SjLjjw();
        sjLjjw.setJh(sjFdsgcs.getJh());
        List<SjLjjw> sjLjjwList = sjLjjwMapper.selectSjLjjwList(sjLjjw);
        SjQkztfx sjQkztfx =new SjQkztfx();
        sjQkztfx.setJh(sjFdsgcs.getJh());
        List<SjQkztfx> sjQkztfxes = sjQkztfxMapper.selectSjQkztfxList(sjQkztfx);
        List<ClFxsb> clFxsbList = clFxsbMapper.selectClFxsbList(new ClFxsb());

        SjJygjGdsjgdcs sjJygjGdsjgdcs=new SjJygjGdsjgdcs();
        sjJygjGdsjgdcs.setJh(sjFdsgcs.getJh());
        List<SjJygjGdsjgdcs> sjJygjGdsjgdcsList = sjJygjGdsjgdcsMapper.selectSjJygjGdsjgdcsList(sjJygjGdsjgdcs);

        List<String> collect = sjLjjwList.stream().map(SjLjjw::getLjjh).collect(Collectors.toList());

        System.out.println("邻井井位"+collect);
        SjDjjc sjDjjc1 = sjDjjcMapper.selectSjDjjcByJh(sjFdsgcs.getJh());
        List<SgfambKcSggy> sgfambKcSggyList=sgfambKcSggyMapper.selectSgfambKcSggyListByQk(new SgfambKcSggy());
        List<SgfambKcSggy> sgmbySggyList=new ArrayList<>();
        if(sjDjjc1.getFaid()!=null){
            sgmbySggyList = sgfambKcSggyList.stream().filter(sgfambKcSggy -> sgfambKcSggy.getZbid().toString().equals(sjDjjc1.getFaid().toString())).collect(Collectors.toList());
        }
        //获取所有井的造斜规律数据
        List<Jskd> jskdList = new ArrayList<>();
        List<DjZqsjfx> djZqsjfxList=new ArrayList<>();
        ///如果邻井不为空，则进行造斜率的数据封装
        if (sjLjjwList.size() > 0) {
            Object djdcinfo;
            CommonParam commonParam = new CommonParam();
            String[] jhs=new String[sjLjjwList.size()];
            for (int i = 0; i < sjLjjwList.size(); i++) {
                jhs[i]=sjLjjwList.get(i).getLjjh();
            }
            commonParam.setJhs(jhs);
            commonParam.setFw(sjJygjGdsjgdcsList.get(0).getFw());
           djZqsjfxList = djdcInfoMapper.getjskd(commonParam);
        }
        System.out.println("所有井的造斜规律数据"+djZqsjfxList);


        List<String> jh_list = sjLjjwList.stream().filter(it -> "附近高指标井".equals(it.getLb1())).map(SjLjjw::getLjjh).collect(Collectors.toList());

        SjFdsgcsDcyx sjFdsgcsDcyx1 = new SjFdsgcsDcyx();
        sjFdsgcsDcyx1.setJh(sjFdsgcs.getJh());
        List<SjFdsgcsDcyx> sjFdsgcsDcyxes = sjFdsgcsDcyxMapper.selectSjFdsgcsDcyxList(sjFdsgcsDcyx1);
        List<SjFdsgcsDcylZjymdsjb> zjymdsjbList =new ArrayList<>();
        List<SjFdsgcsDcylZjymdtjb> zjymdtjbList =new ArrayList<>();
        if(jh_list.size()>0){
            //获取地层压力数据
            Map map =new HashMap<>();
            map.put("jh_list",jh_list.toArray());
            Gson gson = new GsonBuilder().setPrettyPrinting().create();
            String json = gson.toJson(map);
            //调用httpsPost请求获取数据
            String url = "https://10.68.249.59:12001/api/ljzjymd";
            System.out.println(json);
            String result = HttpRequest.post(url).body(json).execute().body();
            System.out.println(result);
            JsonObject jsonObject = safeParseJsonObject(result);
            if(jsonObject!=null){
                JsonObject root = gson.fromJson(result, JsonObject.class);
                JsonObject outerData = root.getAsJsonObject("data");
                List<String> dcylmsList=new ArrayList<>();

                for(String ljh:jh_list){
                    JsonObject innerData = outerData.getAsJsonObject(ljh);
                    if(innerData!=null){
                        //邻井钻井液密度数据表
                        JsonArray zjymdsjb = innerData.getAsJsonArray("邻井钻井液密度数据表");
                        List<SjFdsgcsDcylZjymdsjb> list=getZjymdsjbList(zjymdsjb,sjFdsgcs.getJh(),sjFdsgcsDcyxes);
                        zjymdsjbList.addAll(list);
                        //邻井钻井液密度统计表
                        JsonArray zjymdtjb = innerData.getAsJsonArray("邻井钻井液密度统计表");
                        zjymdtjbList.addAll(getZjymdtjbList(zjymdtjb, ljh,sjFdsgcs.getJh(), sjFdsgcsDcyxes));
                        //地层压力描述文本
//                String dcylms = innerData.get("地层压力描述文本").toString();
//                dcylmsList.add("邻井"+ljh+dcylms);
                    }
                }
            }

//
//
////
//            fillLiang217Xie40Data(sjFdsgcs.getJh(),"一开",zjymdsjbList);
//            // 3. 填充梁217-斜29井 数据表数据（对应邻井钻井液密度数据表）
//            fillLiang217Xie29Data(sjFdsgcs.getJh(),"二开",zjymdsjbList);
//
//            fillLiang217Xie40Stat(sjFdsgcs.getJh(),"一开",zjymdtjbList);
//            fillLiang217Xie29Stat(sjFdsgcs.getJh(),"二开",zjymdtjbList);
            if(zjymdsjbList.size()>0){
                sjFdsgcsDcylZjymdsjbMapper.deleteSjFdsgcsDcylZjymdsjbByjh(sjFdsgcs.getJh());
                sjFdsgcsDcylZjymdsjbMapper.insertSjFdsgcsDcylZjymdsjbBatch(zjymdsjbList);
            }
            if(zjymdtjbList.size()>0){
                sjFdsgcsDcylZjymdtjbMapper.deleteSjFdsgcsDcylZjymdtjbByJh(sjFdsgcs.getJh());
                sjFdsgcsDcylZjymdtjbMapper.insertSjFdsgcsDcylZjymdtjbBatch(zjymdtjbList);
            }
        }



        double previousDepth= 0;
        double csaa= 0;
        for (int i = 0; i < sjJsjgList.size(); i++) {
            SjJsjg sjJsjg1 = sjJsjgList.get(i);
            if (i == 0) {
                previousDepth = 0;
            } else {
                //上一次的垂深
                previousDepth = csaa;
            }
            String gjyh="";
            ///查询符合开次的测斜数据
            if(djZqsjfxList.size()>0){
                List<Jskd> jskdList_kc =new ArrayList<>();
                double ksjs=0.0;
                if (i==0){
                    //开始井深
                    ksjs=0;
                }else {
                    ksjs= sjJsjgList.get(i-1).getJs();
                }
                double jsjs=sjJsjg1.getJs();
                CommonParam commonParam = new CommonParam();

                String[] jhs= djZqsjfxList.stream().map(djZqsjfx -> djZqsjfx.getJh()).toArray(String[]::new) ;
                commonParam.setJhs(jhs);
                commonParam.setKsjs(ksjs);
                commonParam.setJsjs(jsjs);
                jskdList_kc=djdcInfoMapper.getJskdList2(commonParam);
                System.out.println("jskdList_kc"+jskdList_kc);
                if (jskdList_kc.size()>0){
                    for (Jskd jskd : jskdList_kc) {
                        gjyh+=jskd.getGldc()+": 自然增："+jskd.getZrz()+", 自然减："+jskd.getZrj()+", 人工增："+jskd.getRgz()+", 人工减："+jskd.getRgj()+"<br>";
                    }
                }

            }





            String kc = sjJsjg1.getKc();
            sjFdsgcs.setKc(kc);
            SjFdsgcs sjFdsgcs1 =sjFdsgcsMapper.selectSjFdsgcsByJhAndKc(sjFdsgcs);

            SgfambKcSggy sgfambKcSggy=sgmbySggyList.stream().filter(kcSggy -> kcSggy.getKc().equals(kc)).findFirst().orElse(null);
            String zyfx="";
            if(sgfambKcSggy!=null){
                zyfx=sgfambKcSggy.getFxts();
            }
            zyfx=zyfx+"<p>邻井风险<p>";
            List<String> fzqk=new ArrayList<>();
            //查询一趟钻率

            List<SjQkztfx> collect2 = sjQkztfxes.stream().filter(it -> StringUtils.isNotEmpty(it.getKc())).collect(Collectors.toList());
            List<SjQkztfx> collect1 = collect2.stream().filter(it -> it.getKc().equals(kc) && it.getLb().equals("高指标")).collect(Collectors.toList());
            SjQkztfx sjQkztfx1 = collect1.stream().max(Comparator.comparing(SjQkztfx::getYtzl)).get();
            System.out.println("kc======="+kc);
            Double ytzl=0.0;
            if(sjQkztfx1!=null){
                ytzl=sjQkztfx1.getYtzl();
            }
            System.out.println("ytzl=========="+ytzl);

            List<SjFdsgcsDcylZjymdtjb> collect4 = zjymdtjbList.stream().filter(zjymdtjb ->kc.equals(zjymdtjb.getKc()) ).collect(Collectors.toList());
            String dcyl="";
            if(collect4.size()>0){
                List<String> dcylList=new ArrayList<>();
                dcylList.add("经分析，根据邻井钻井液密度分析出的压力情况如下。：<br/>");
                Map<String, List<SjFdsgcsDcylZjymdtjb>> collect3 = collect4.stream().collect(Collectors.groupingBy(SjFdsgcsDcylZjymdtjb::getLjjh));
                for(String key:collect3.keySet()){
                    String aa="邻井"+key+"：" ;
                    dcylList.add(aa);
                    List<SjFdsgcsDcylZjymdtjb> zjymdtjbList1 = collect3.get(key);
                    zjymdtjbList1.forEach(zjymdtjb -> {
                        String bb=zjymdtjb.getCw()+" 密度范围为"+zjymdtjb.getMdMin()+"-"+zjymdtjb.getMdMax()+"，取样垂深在"+zjymdtjb.getQycsMin()+"-"+zjymdtjb.getQycsMax()+"。<br/>";
                        dcylList.add(bb);
                    });
                }

                dcyl= String.join(" ",dcylList);
            }



            if(sjFdsgcs1==null){

                //查询是否有复杂情况
                if(collect.size()>0){
                    Jsqa jsqa= new Jsqa();
                    jsqa.setJhs(collect);
                    jsqa.setJs(sjJsjg1.getJs());
                    List<Jsqa> jsqaList=jsqaMapper.getJsqaByjhAndJs(jsqa);
                    String zjycs="";
                    String zjgccs="";
                    if(jsqaList.size()>0){
                        List<String> collect3 = jsqaList.stream().map(Jsqa::getFzqk).distinct().collect(Collectors.toList());
                        //复杂情况
                        for(String s : collect3){
                            ClFxsb clFxsb1 = clFxsbList.stream().filter(clFxsb -> StringUtils.isNotEmpty(clFxsb.getPdtj())).collect(Collectors.toList()).stream().filter(clFxsb -> clFxsb.getPdtj().contains(s)).findFirst().orElse(null);
                            if(clFxsb1!=null){
                                if(StringUtils.isNotEmpty(zjgccs)){
                                    zjgccs=zjgccs+"；"+s+"：钻井工程措施："+clFxsb1.getGcjscs();
                                    zjycs=zjycs+"；"+s+"：钻井液措施："+clFxsb1.getZjycs();
                                }else {
                                    zjycs=zjycs+"：钻井液措施："+clFxsb1.getZjycs();
                                    zjgccs=zjgccs+"；"+s+"：钻井工程措施："+clFxsb1.getGcjscs();
                                }
                            }

                        }
                        for(Jsqa item: jsqaList){
                            fzqk.add(item.getJh()+"在"+item.getJs()+"时发生"+item.getFzqk());
                            ClFxsb clFxsb1 = clFxsbList.stream().filter(clFxsb -> StringUtils.isNotEmpty(clFxsb.getPdtj())).collect(Collectors.toList()).stream().filter(clFxsb -> clFxsb.getPdtj().contains(item.getFzqk())).findFirst().orElse(null);
                            if(clFxsb1!=null){
                                if(StringUtils.isNotEmpty(zyfx)){
                                    zyfx=zyfx+"；<br>"+item.getJh()+"在"+item.getJs()+"m发生"+item.getFzqk();
                                }else {
                                    zyfx=""+item.getJh()+"在"+item.getJs()+"m发生"+item.getFzqk();
                                }
                            }
                        }
//                        sjFdsgcs.setZjgccs(zjgccs);
//                        sjFdsgcs.setZjycs(zjycs);
                        if (zyfx.endsWith("<p>邻井风险<p>")){
                            zyfx=zyfx.replace("<p>邻井风险<p>","");
                        }
                        sjFdsgcs.setZyfx(zyfx);
                        String join = "";
                        if(fzqk.size()>0){
                            join = String.join(";", fzqk);
                        }else {
                            join = "无";
                        }

                        if(ytzl>0&& ytzl<100){
                            String tzqk="邻井一趟钻完成率为"+ytzl+"%；";
                            sjFdsgcs.setTzqk(tzqk);
                            sjFdsgcs.setLjfzqk(join);
                        }else if(ytzl>=100){
                            String tzqk="邻井一趟钻完成率为"+ytzl+"%,可实现一趟钻完成；";
                            sjFdsgcs.setTzqk(tzqk);
                            sjFdsgcs.setLjfzqk(join);
                        }

                    }else {
                        if(ytzl>0&& ytzl<100){
                            String tzqk="邻井一趟钻完成率为"+ytzl+"%";
                            sjFdsgcs.setTzqk(tzqk);
                            sjFdsgcs.setLjfzqk("无");
                        }else if(ytzl>=100){
                            String tzqk="邻井一趟钻完成率为"+ytzl+"%,可实现一趟钻完成";
                            sjFdsgcs.setTzqk(tzqk);
                            sjFdsgcs.setLjfzqk("无");
                        }


                    }
                }
                //井段情况
                double cs = CxszhUtil.getCs(sjJygjGdsjgdcsList, sjJsjg1.getJs());
                csaa=cs;
                SjFdsgcsDcyx sjFdsgcsDcyx  =new SjFdsgcsDcyx();

                sjFdsgcsDcyx.setJh(sjFdsgcs.getJh());
                sjFdsgcsDcyx.setKscs(previousDepth);
                sjFdsgcsDcyx.setJscs(cs);
                List<SjFdsgcsDcyx> sjFdsgcsDcyxList=sjFdsgcsDcyxMapper.getListByJh(sjFdsgcsDcyx);
                if(sjFdsgcsDcyxList.size()>0){
                    if(sjFdsgcsDcyxList.size()==1){
                        sjFdsgcs.setJdqk(previousDepth+"-"+cs+","+sjFdsgcsDcyxList.get(0).getDcmc());
                    }else {
                        sjFdsgcs.setJdqk(previousDepth+"-"+cs+","+sjFdsgcsDcyxList.get(0).getDcmc()+"-"+sjFdsgcsDcyxList.get(sjFdsgcsDcyxList.size()-1).getDcmc());
                    }
                }
                sjFdsgcs.setGjfx(gjyh);
                sjFdsgcs.setDcyl(dcyl);
                sjFdsgcsMapper.insertSjFdsgcs(sjFdsgcs);
            }else {
                sjFdsgcs1.setGjfx(gjyh);
                //查询是否有复杂情况
                if(collect.size()>0){
                    Jsqa jsqa= new Jsqa();
                    jsqa.setJhs(collect);
                    jsqa.setJs(sjJsjg1.getJs());
                    List<Jsqa> jsqaList=jsqaMapper.getJsqaByjhAndJs(jsqa);
                    String zjycs="";
                    String zjgccs="";
                    String fxgkcs="";
                    if(jsqaList.size()>0){
//                        List<String> fzqk=new ArrayList<>();
                        List<String> collect3 = jsqaList.stream().map(Jsqa::getFzqk).distinct().collect(Collectors.toList());
                        //复杂情况
                        for(String s : collect3){
                            ClFxsb clFxsb1 = clFxsbList.stream().filter(clFxsb -> StringUtils.isNotEmpty(clFxsb.getPdtj())).collect(Collectors.toList()).stream().filter(clFxsb -> clFxsb.getPdtj().contains(s)).findFirst().orElse(null);
                            if(clFxsb1!=null){
                                if(StringUtils.isNotEmpty(zjgccs)){
                                    zjgccs=zjgccs+"；"+s+"：钻井工程措施："+clFxsb1.getGcjscs();
                                    zjycs=zjycs+"；"+s+"：钻井液措施："+clFxsb1.getZjycs();
                                    fxgkcs=fxgkcs+"；"+s+"："+clFxsb1.getJkcs()+"<p>";
                                }else {
                                    zjycs=zjycs+"：钻井液措施："+clFxsb1.getZjycs();
                                    zjgccs=zjgccs+"；"+s+"：钻井工程措施："+clFxsb1.getGcjscs();
                                    fxgkcs=fxgkcs+"；"+s+"："+clFxsb1.getJkcs()+"<p>";
                                }
                            }
                        }
                        for(Jsqa item: jsqaList){
                            fzqk.add(item.getJh()+"在"+item.getJs()+"时发生"+item.getFzqk());
                            ClFxsb clFxsb1 = clFxsbList.stream().filter(clFxsb -> StringUtils.isNotEmpty(clFxsb.getPdtj())).collect(Collectors.toList()).stream().filter(clFxsb -> clFxsb.getPdtj().contains(item.getFzqk())).findFirst().orElse(null);
                            if(clFxsb1!=null){
                                if(StringUtils.isNotEmpty(zyfx)){
                                    zyfx=zyfx+item.getJh()+"在"+item.getJs()+"m发生"+item.getFzqk()+"<br>";
                                }else {
                                    zyfx="邻井存在风险："+item.getJh()+"在"+item.getJs()+"m发生"+item.getFzqk();
                                }
                            }
                        }
//                        sjFdsgcs1.setZjgccs(zjgccs);
//                        sjFdsgcs1.setZjycs(zjycs);
//                        sjFdsgcs1.setFxgkcs(fxgkcs);
                        sjFdsgcs1.setZyfx(zyfx);
                        String join = "";
                        if(fzqk.size()>0){
                            join = String.join(";", fzqk);
                        }else {
                            join = "无";
                        }
                        if(ytzl>=0&& ytzl<100){
                            String tzqk="邻井一趟钻完成率为"+ytzl+"%；";
                            sjFdsgcs1.setTzqk(tzqk);
                            sjFdsgcs1.setLjfzqk(join);
                        }else if(ytzl>=100){
                            String tzqk="邻井一趟钻完成率为"+ytzl+"%,可实现一趟钻完成；";
                            sjFdsgcs1.setLjfzqk(join);
                            sjFdsgcs1.setTzqk(tzqk);
                        }
                    }else {
                        if(ytzl>=0&& ytzl<100){
                            String tzqk="邻井一趟钻完成率为"+ytzl+"%";
                            sjFdsgcs1.setTzqk(tzqk);
                            sjFdsgcs1.setLjfzqk("无");
                        }else if(ytzl>=100){
                            String tzqk="邻井一趟钻完成率为"+ytzl+"%,可实现一趟钻完成";
                            sjFdsgcs1.setTzqk(tzqk);
                            sjFdsgcs1.setLjfzqk("无");
                        }
                    }
                }else {
                    if(ytzl>=0&& ytzl<100){
                        String tzqk="邻井一趟钻完成率为"+ytzl+"%";
                        sjFdsgcs1.setTzqk(tzqk);
                        sjFdsgcs1.setLjfzqk("无");
                    }else if(ytzl>=100){
                        String tzqk="邻井一趟钻完成率为"+ytzl+"%,可实现一趟钻完成";
                        sjFdsgcs1.setTzqk(tzqk);
                        sjFdsgcs1.setLjfzqk("无");
                    }
                }

                //井段情况
                double cs = CxszhUtil.getCs(sjJygjGdsjgdcsList, sjJsjg1.getJs());
                csaa=cs;
                SjFdsgcsDcyx sjFdsgcsDcyx  =new SjFdsgcsDcyx();

                sjFdsgcsDcyx.setJh(sjFdsgcs1.getJh());
                sjFdsgcsDcyx.setKscs(previousDepth);
                sjFdsgcsDcyx.setJscs(cs);
                List<SjFdsgcsDcyx> sjFdsgcsDcyxList=sjFdsgcsDcyxMapper.getListByJh(sjFdsgcsDcyx);
                if(sjFdsgcsDcyxList.size()>0){
                    if(sjFdsgcsDcyxList.size()==1){
                        sjFdsgcs1.setJdqk(previousDepth+"-"+cs+","+sjFdsgcsDcyxList.get(0).getDcmc());
                    }else {
                        sjFdsgcs1.setJdqk(previousDepth+"-"+cs+","+sjFdsgcsDcyxList.get(0).getDcmc()+"-"+sjFdsgcsDcyxList.get(sjFdsgcsDcyxList.size()-1).getDcmc());
                    }
                }
                sjFdsgcs1.setDcyl(dcyl);
                sjFdsgcsMapper.updateSjFdsgcs(sjFdsgcs1);
            }

        }

        SjZysx sjZysx = sjZysxMapper.selectSjZysxByJh(sjFdsgcs.getJh(),"喷漏卡塌");
        //查询复杂邻井
        SjDjjc sjDjjc = sjDjjcMapper.selectSjDjjcByJh(sjFdsgcs.getJh());
        CommonParam param =new CommonParam();
        param.setJkhzb(sjDjjc.getJkhzb());
        param.setJkzzb(sjDjjc.getJkzzb());
        param.setJl(3000.0);
        // 获取当前日期
        LocalDate currentDate = LocalDate.now();

        // 获取四年前的日期
        LocalDate fourYearsAgo = currentDate.minusYears(4);

        // 定义格式化器
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy");

        // 格式化日期
        String formattedDate = fourYearsAgo.format(formatter);
        param.setWjsjks(formattedDate);
        param.setWjsjjs(DateUtils.parseDateToStr("yyyy", new Date()));
        List<Ljjw> ljjwList=djdcService.getLjjwList2(param);
        List<String> ljjhlist = ljjwList.stream().limit(20).map(Ljjw::getJh).collect(Collectors.toList());
        collect.addAll(ljjhlist);


        if(sjZysx!=null){
            if(collect.size()>0){
                Jsqa jsqa= new Jsqa();
                jsqa.setJhs(collect);
                List<Jsqa> jsqaList=jsqaMapper.getJsqaByjhAndJs(jsqa);
                String zyfx="";
                if(jsqaList.size()>0){
                    for(Jsqa item: jsqaList){
                        String cw ="";
                        if(StringUtils.isNotEmpty(item.getCw())){
                            cw="在"+item.getCw()+"，";
                        }
                        String sjhd="";
                        if(StringUtils.isNotEmpty(item.getSjhd())){
                            sjhd="层厚"+item.getSjhd()+"m，";
                        }
                        if(StringUtils.isNotEmpty(zyfx)){
                            ClFxsb clFxsb1 = clFxsbList.stream().filter(clFxsb -> StringUtils.isNotEmpty(clFxsb.getPdtj())).collect(Collectors.toList()).stream().filter(clFxsb -> clFxsb.getPdtj().contains(item.getFzqk())).findFirst().orElse(null);
                            if(clFxsb1!=null){
                                zyfx=zyfx+"；邻井"+item.getJh()+cw+"距层顶"+item.getJs()+"m处发生"+item.getFzqk()+"，"+sjhd+"风险描述："+clFxsb1.getFxms();
                            }else {
                                zyfx=zyfx+"；邻井"+item.getJh()+cw+"距层顶"+item.getJs()+"m处发生"+item.getFzqk()+(StringUtils.isNotEmpty(sjhd)?"，"+sjhd.substring(0,sjhd.length()-1):"");
                            }
//                            for(ClFxsb clFxsb :clFxsbList){
//                                if(StringUtils.isNotEmpty(clFxsb.getPdtj())){
//                                    if(clFxsb.getPdtj().contains(item.getFzqk())){
//                                        if(!zyfx.contains(item.getFzqk())){
//                                            zyfx=zyfx+"；邻井"+item.getJh()+cw+"距层顶"+item.getJs()+"m处发生"+item.getFzqk()+"，"+sjhd+"风险描述："+clFxsb.getFxms();
//                                        }
//                                    }else {
//                                        zyfx=zyfx+"；邻井"+item.getJh()+cw+"距层顶"+item.getJs()+"m处发生"+item.getFzqk()+"，"+(StringUtils.isNotEmpty(sjhd)?sjhd.substring(0,sjhd.length()-1):"");
//                                    }
//                                }else {
//                                    zyfx=zyfx+"；邻井"+item.getJh()+cw+"距层顶"+item.getJs()+"m处发生"+item.getFzqk()+"，"+(StringUtils.isNotEmpty(sjhd)?sjhd.substring(0,sjhd.length()-1):"");
//                                }
//
//                            }
                        }else {
                            ClFxsb clFxsb1 = clFxsbList.stream().filter(clFxsb -> StringUtils.isNotEmpty(clFxsb.getPdtj())).collect(Collectors.toList()).stream().filter(clFxsb -> clFxsb.getPdtj().contains(item.getFzqk())).findFirst().orElse(null);
                            if(clFxsb1!=null){
                                zyfx="邻井"+item.getJh()+cw+"距层顶"+item.getJs()+"m处发生"+item.getFzqk()+"，"+sjhd+"，风险描述："+clFxsb1.getFxms();
                            }else {
                                zyfx="邻井"+item.getJh()+cw+"距层顶"+item.getJs()+"m处发生"+item.getFzqk()+(StringUtils.isNotEmpty(sjhd)?"，"+sjhd.substring(0,sjhd.length()-1):"");
                            }
//                            for(ClFxsb clFxsb :clFxsbList){
//                                if(StringUtils.isNotEmpty(clFxsb.getPdtj())){
//                                    if(clFxsb.getPdtj().contains(item.getFzqk())){
//                                        zyfx="邻井"+item.getJh()+cw+"距层顶"+item.getJs()+"m处发生"+item.getFzqk()+"，"+sjhd+"，风险描述："+clFxsb.getFxms();
//                                    }else {
//                                        zyfx="邻井"+item.getJh()+cw+"距层顶"+item.getJs()+"m处发生"+item.getFzqk()+"，"+(StringUtils.isNotEmpty(sjhd)?sjhd.substring(0,sjhd.length()-1):"");
//                                    }
//                                }else {
//                                    zyfx="邻井"+item.getJh()+cw+"距层顶"+item.getJs()+"m处发生"+item.getFzqk()+"，"+(StringUtils.isNotEmpty(sjhd)?sjhd.substring(0,sjhd.length()-1):"");
//                                }
//
//                            }
                        }
                    }
                }
                sjZysx.setZysx(zyfx);
            }
            sjZysxMapper.updateSjZysx(sjZysx);
        }else {
            sjZysx=new SjZysx();
            sjZysx.setJh(sjFdsgcs.getJh());
            sjZysx.setLb("喷漏卡塌");
            if(collect.size()>0){
                Jsqa jsqa= new Jsqa();
                jsqa.setJhs(collect);
                List<Jsqa> jsqaList=jsqaMapper.getJsqaByjhAndJs(jsqa);
                String zyfx="";
                if(jsqaList.size()>0){
                    for(Jsqa item: jsqaList){

                        String cw ="";
                        if(StringUtils.isNotEmpty(item.getCw())){
                            cw="在"+item.getCw()+"，";
                        }
                        String sjhd="";
                        if(StringUtils.isNotEmpty(item.getSjhd())){
                            sjhd="层厚"+item.getSjhd()+"m，";
                        }

                        if(StringUtils.isNotEmpty(zyfx)){
                            ClFxsb clFxsb1 = clFxsbList.stream().filter(clFxsb -> StringUtils.isNotEmpty(clFxsb.getPdtj())).collect(Collectors.toList()).stream().filter(clFxsb -> clFxsb.getPdtj().contains(item.getFzqk())).findFirst().orElse(null);
                            if(clFxsb1!=null){
                                zyfx=zyfx+"；邻井"+item.getJh()+cw+"距层顶"+item.getJs()+"m处发生"+item.getFzqk()+"，"+sjhd+"风险描述："+clFxsb1.getFxms();
                            }else {
                                zyfx=zyfx+"；邻井"+item.getJh()+cw+"距层顶"+item.getJs()+"m处发生"+item.getFzqk()+(StringUtils.isNotEmpty(sjhd)?"，"+sjhd.substring(0,sjhd.length()-1):"");
                            }
//                            for(ClFxsb clFxsb :clFxsbList){
//                                if(StringUtils.isNotEmpty(clFxsb.getPdtj())){
//                                    if(clFxsb.getPdtj().contains(item.getFzqk())){
//                                        if(!zyfx.contains(item.getFzqk())){
//                                            zyfx=zyfx+"；邻井"+item.getJh()+cw+"距层顶"+item.getJs()+"m处发生"+item.getFzqk()+"，"+sjhd+"风险描述："+clFxsb.getFxms();
//                                        }else {
//                                            zyfx=zyfx+"；邻井"+item.getJh()+cw+"距层顶"+item.getJs()+"m处发生"+item.getFzqk()+"，"+(StringUtils.isNotEmpty(sjhd)?sjhd.substring(0,sjhd.length()-1):"");
//                                        }
//                                    }else {
//                                        zyfx=zyfx+"；邻井"+item.getJh()+cw+"距层顶"+item.getJs()+"m处发生"+item.getFzqk()+"，"+(StringUtils.isNotEmpty(sjhd)?sjhd.substring(0,sjhd.length()-1):"");
//                                    }
//                                }
//
//                            }
                        }else {
                            ClFxsb clFxsb1 = clFxsbList.stream().filter(clFxsb -> StringUtils.isNotEmpty(clFxsb.getPdtj())).collect(Collectors.toList()).stream().filter(clFxsb -> clFxsb.getPdtj().contains(item.getFzqk())).findFirst().orElse(null);
                            if(clFxsb1!=null){
                                zyfx="邻井"+item.getJh()+cw+"距层顶"+item.getJs()+"m处发生"+item.getFzqk()+"，"+sjhd+"，风险描述："+clFxsb1.getFxms();
                            }else {
                                zyfx="邻井"+item.getJh()+cw+"距层顶"+item.getJs()+"m处发生"+item.getFzqk()+(StringUtils.isNotEmpty(sjhd)?"，"+sjhd.substring(0,sjhd.length()-1):"");
                            }
//                            for(ClFxsb clFxsb :clFxsbList){
//                                if(StringUtils.isNotEmpty(clFxsb.getPdtj())){
//                                    if(clFxsb.getPdtj().contains(item.getFzqk())){
//                                        zyfx="邻井"+item.getJh()+cw+"距层顶"+item.getJs()+"m处发生"+item.getFzqk()+"，"+sjhd+"，风险描述："+clFxsb.getFxms();
//                                    }else {
//                                        zyfx="邻井"+item.getJh()+cw+"距层顶"+item.getJs()+"m处发生"+item.getFzqk()+"，"+(StringUtils.isNotEmpty(sjhd)?sjhd.substring(0,sjhd.length()-1):"");
//                                    }
//                                }else {
//                                    zyfx="邻井"+item.getJh()+cw+"距层顶"+item.getJs()+"m处发生"+item.getFzqk()+"，"+(StringUtils.isNotEmpty(sjhd)?sjhd.substring(0,sjhd.length()-1):"");
//                                }
//
//                            }
                        }
                    }

                }
                sjZysx.setZysx(zyfx);
            }
            sjZysxMapper.insertSjZysx(sjZysx);
        }

    }


    public List<SjFdsgcsDcylZjymdsjb> getZjymdsjbList(JsonArray data,String jh,List<SjFdsgcsDcyx> dcyxList) {
        List<SjFdsgcsDcylZjymdsjb> list = new ArrayList<>();
        data.forEach(item -> {
            SjFdsgcsDcylZjymdsjb sjFdsgcsDcylZjymdsjb = new SjFdsgcsDcylZjymdsjb();
            JsonObject jsonObject = item.getAsJsonObject();
            String ljjh = jsonObject.get("井号").getAsString();
            Double qyjs = jsonObject.get("取样井深").getAsDouble();
            Double md = jsonObject.get("密度").getAsDouble();
            Double dycs = jsonObject.get("对应垂深").getAsDouble();
            String dycw = jsonObject.get("对应层位").getAsString();

            List<Djjc> kcList= djdcService.getJhKcList(ljjh);
            Djjc djjc1 = kcList.stream()
                    .filter(djjc -> qyjs >= djjc.getKsjs() && qyjs <= djjc.getJs())
                    .findFirst().orElse(null);
            if(djjc1!=null){
                sjFdsgcsDcylZjymdsjb.setKc(getKc(djjc1.getKc()));
            }

            sjFdsgcsDcylZjymdsjb.setJh(jh);
            sjFdsgcsDcylZjymdsjb.setLjjh(ljjh);
            sjFdsgcsDcylZjymdsjb.setQyjs(qyjs);
            sjFdsgcsDcylZjymdsjb.setMd(md);
            sjFdsgcsDcylZjymdsjb.setDycs(dycs);
            sjFdsgcsDcylZjymdsjb.setDycw(dycw);
            list.add(sjFdsgcsDcylZjymdsjb);
        });

        return list;
    }



    public String getKc(String kc) {
        if(kc.equals("1")){
            kc="一开";
        }else if(kc.equals("2")){
            kc="二开";
        }else if(kc.equals("3")){
            kc="三开";
        }else if(kc.equals("4")){
            kc="四开";
        }else if(kc.equals("5")){
            kc="五开";
        }
        return kc;
    }

    public List<SjFdsgcsDcylZjymdtjb> getZjymdtjbList(JsonArray data,String ljjh,String jh,List<SjFdsgcsDcyx> dcyxList) {
        List<SjFdsgcsDcylZjymdtjb> list = new ArrayList<>();
        data.forEach(item -> {
            SjFdsgcsDcylZjymdtjb sjFdsgcsDcylZjymdtjb = new SjFdsgcsDcylZjymdtjb();
            JsonObject jsonObject = item.getAsJsonObject();
            String cw = jsonObject.get("层位").getAsString();
            Double mdMin = jsonObject.get("密度最小值").getAsDouble();
            Double mdMax = jsonObject.get("密度最大值").getAsDouble();
            Double qycsMin = jsonObject.get("取样垂深最小值").getAsDouble();
            Double qycsMax = jsonObject.get("取样垂深最大值").getAsDouble();

            List<Djjc> kcList= djdcService.getJhKcList(ljjh);
            Djjc djjc1 = kcList.stream()
                    .filter(djjc -> qycsMin >= djjc.getKsjs() && qycsMin <= djjc.getJs())
                    .findFirst().orElse(null);
            if(djjc1!=null){
                sjFdsgcsDcylZjymdtjb.setKc(getKc(djjc1.getKc()));
            }
            sjFdsgcsDcylZjymdtjb.setLjjh(ljjh);
            sjFdsgcsDcylZjymdtjb.setJh(jh);
            sjFdsgcsDcylZjymdtjb.setCw(cw);
            sjFdsgcsDcylZjymdtjb.setMdMin(mdMin);
            sjFdsgcsDcylZjymdtjb.setMdMax(mdMax);
            sjFdsgcsDcylZjymdtjb.setQycsMin(qycsMin);
            sjFdsgcsDcylZjymdtjb.setQycsMax(qycsMax);
            list.add(sjFdsgcsDcylZjymdtjb);
        });

        return list;
    }




    /**
     * 填充梁217-斜40井 钻井液密度数据表数据
     */
    private static void fillLiang217Xie40Data(String mainWellNo,String kc,List<SjFdsgcsDcylZjymdsjb> dataList) {
//        String mainWellNo = "主井号（可根据实际填写，如梁217-XX）"; // 实际场景需替换为目标井号
        String neighborWellNo = "梁217-斜40"; // 邻井井号
//        String kc = "区块信息（可根据实际填写，如梁217区块）"; // 区块字段（文档未明确，预留默认值）

        // 逐条映射文档中的"邻井钻井液密度数据表"数据
        addDataItem(dataList, mainWellNo, kc, neighborWellNo, 359.5, 1.09, 359.49, "东营组");
        addDataItem(dataList, mainWellNo, kc, neighborWellNo, 359.5, 1.09, 359.49, "东营组");
        addDataItem(dataList, mainWellNo, kc, neighborWellNo, 1100.0, 1.09, 1099.1132768752161, "东营组");
        addDataItem(dataList, mainWellNo, kc, neighborWellNo, 1665.0, 1.09, 1612.229411764706, "东营组");
        addDataItem(dataList, mainWellNo, kc, neighborWellNo, 2150.0, 1.1, 2028.5997203774903, "东营组");
        addDataItem(dataList, mainWellNo, kc, neighborWellNo, 2450.0, 1.21, 2286.020289905693, "沙二段");
        addDataItem(dataList, mainWellNo, kc, neighborWellNo, 2600.0, 1.21, 2419.1807601527244, "沙二段");
        addDataItem(dataList, mainWellNo, kc, neighborWellNo, 2810.0, 1.21, 2601.9646916608267, "沙三上");
        addDataItem(dataList, mainWellNo, kc, neighborWellNo, 3000.0, 1.25, 2764.699968652038, "沙三下");
        addDataItem(dataList, mainWellNo, kc, neighborWellNo, 3122.0, 1.26, 2869.132985386221, "沙三下");
        addDataItem(dataList, mainWellNo, kc, neighborWellNo, 3300.0, 1.32, 3024.5532614742697, "沙四上");
        addDataItem(dataList, mainWellNo, kc, neighborWellNo, 3450.0, 1.32, 3162.20346355075, "沙四上");
        addDataItem(dataList, mainWellNo, kc, neighborWellNo, 3571.0, 1.35, 3273.57, "沙四下");
        addDataItem(dataList, mainWellNo, kc, neighborWellNo, 3571.0, 1.35, 3273.57, "沙四下");
        addDataItem(dataList, mainWellNo, kc, neighborWellNo, 3571.0, 1.35, 3273.57, "沙四下");
        addDataItem(dataList, mainWellNo, kc, neighborWellNo, 3571.0, 1.35, 3273.57, "沙四下");
    }

    /**
     * 填充梁217-斜29井 钻井液密度数据表数据
     */
    private static void fillLiang217Xie29Data(String mainWellNo,String kc,List<SjFdsgcsDcylZjymdsjb> dataList) {
//        String mainWellNo = "主井号（可根据实际填写，如梁217-XX）";
        String neighborWellNo = "梁217-斜29";
//        String kc = "区块信息（可根据实际填写，如梁217区块）";

        // 逐条映射文档中的"邻井钻井液密度数据表"数据
        addDataItem(dataList, mainWellNo, kc, neighborWellNo, 359.0, 1.08, 358.76275130434783, "东营组");
        addDataItem(dataList, mainWellNo, kc, neighborWellNo, 530.0, 1.08, 529.5564785788924, "东营组");
        addDataItem(dataList, mainWellNo, kc, neighborWellNo, 950.0, 1.08, 949.073211452225, "东营组");
        addDataItem(dataList, mainWellNo, kc, neighborWellNo, 1579.0, 1.09, 1554.5117318435755, "东营组");
        addDataItem(dataList, mainWellNo, kc, neighborWellNo, 2250.0, 1.1, 2151.504330543933, "沙二段");
        addDataItem(dataList, mainWellNo, kc, neighborWellNo, 2486.0, 1.15, 2366.0411892270026, "沙二段");
        addDataItem(dataList, mainWellNo, kc, neighborWellNo, 2486.0, 1.18, 2366.0411892270026, "沙二段");
        addDataItem(dataList, mainWellNo, kc, neighborWellNo, 2873.0, 1.21, 2705.3184577978463, "沙三下");
        addDataItem(dataList, mainWellNo, kc, neighborWellNo, 3050.0, 1.26, 2868.4271209480657, "沙三下");
        addDataItem(dataList, mainWellNo, kc, neighborWellNo, 3280.0, 1.35, 3090.7713604488076, "沙四上");
        addDataItem(dataList, mainWellNo, kc, neighborWellNo, 3445.0, 1.35, 3253.37, "沙四下");
        addDataItem(dataList, mainWellNo, kc, neighborWellNo, 3445.0, 1.35, 3253.37, "沙四下");
        addDataItem(dataList, mainWellNo, kc, neighborWellNo, 3445.0, 1.35, 3253.37, "沙四下");
    }

    /**
     * 填充梁217-斜40井 钻井液密度统计表数据
     */
    private static void fillLiang217Xie40Stat(String mainWellNo,String kc,List<SjFdsgcsDcylZjymdtjb> statList) {
//        String mainWellNo = "主井号（可根据实际填写，如梁217-XX）";
        String neighborWellNo = "梁217-斜40";
//        String kc = "区块信息（可根据实际填写，如梁217区块）";

        // 逐条映射文档中的"邻井钻井液密度统计表"数据
        addStatItem(statList, mainWellNo, kc, neighborWellNo, "东营组", 1.09, 1.1, 359.49, 2028.5997203774903);
        addStatItem(statList, mainWellNo, kc, neighborWellNo, "沙二段", 1.21, 1.21, 2286.020289905693, 2419.1807601527244);
        addStatItem(statList, mainWellNo, kc, neighborWellNo, "沙三上", 1.21, 1.21, 2601.9646916608267, 2601.9646916608267);
        addStatItem(statList, mainWellNo, kc, neighborWellNo, "沙三下", 1.25, 1.26, 2764.699968652038, 2869.132985386221);
        addStatItem(statList, mainWellNo, kc, neighborWellNo, "沙四上", 1.32, 1.32, 3024.5532614742697, 3162.20346355075);
        addStatItem(statList, mainWellNo, kc, neighborWellNo, "沙四下", 1.35, 1.35, 3273.57, 3273.57);
    }

    /**
     * 填充梁217-斜29井 钻井液密度统计表数据
     */
    private static void fillLiang217Xie29Stat(String mainWellNo,String kc,List<SjFdsgcsDcylZjymdtjb> statList) {
//        String mainWellNo = "主井号（可根据实际填写，如梁217-XX）";
        String neighborWellNo = "梁217-斜29";
//        String kc = "区块信息（可根据实际填写，如梁217区块）";

        // 逐条映射文档中的"邻井钻井液密度统计表"数据
        addStatItem(statList, mainWellNo, kc, neighborWellNo, "东营组", 1.08, 1.09, 358.76275130434783, 1554.5117318435755);
        addStatItem(statList, mainWellNo, kc, neighborWellNo, "沙二段", 1.1, 1.18, 2151.504330543933, 2366.0411892270026);
        addStatItem(statList, mainWellNo, kc, neighborWellNo, "沙三下", 1.21, 1.26, 2705.3184577978463, 2868.4271209480657);
        addStatItem(statList, mainWellNo, kc, neighborWellNo, "沙四上", 1.35, 1.35, 3090.7713604488076, 3090.7713604488076);
        addStatItem(statList, mainWellNo, kc, neighborWellNo, "沙四下", 1.35, 1.35, 3253.37, 3253.37);
    }

    /**
     * 工具方法：创建数据表实体并添加到List
     */
    private static void addDataItem(List<SjFdsgcsDcylZjymdsjb> list, String jh, String kc, String ljjh,
                                    Double qyjs, Double md, Double dycs, String dycw) {
        SjFdsgcsDcylZjymdsjb data = new SjFdsgcsDcylZjymdsjb();
        data.setJh(jh); // 主井号
        data.setKc(kc); // 区块
        data.setLjjh(ljjh); // 邻井井号
        data.setQyjs(qyjs); // 取样井深
        data.setMd(md); // 密度
        data.setDycs(dycs); // 对应垂深
        data.setDycw(dycw); // 对应层位
        list.add(data);
    }

    /**
     * 工具方法：创建统计表实体并添加到List
     */
    private static void addStatItem(List<SjFdsgcsDcylZjymdtjb> list, String jh, String kc, String ljjh,
                                    String cw, Double mdMin, Double mdMax, Double qycsMin, Double qycsMax) {
        SjFdsgcsDcylZjymdtjb stat = new SjFdsgcsDcylZjymdtjb();
        stat.setJh(jh); // 主井号
        stat.setKc(kc); // 区块
        stat.setLjjh(ljjh); // 邻井井号
        stat.setCw(cw); // 层位
        stat.setMdMin(mdMin); // 密度最小值
        stat.setMdMax(mdMax); // 密度最大值
        stat.setQycsMin(qycsMin); // 取样垂深最小值
        stat.setQycsMax(qycsMax); // 取样垂深最大值
        list.add(stat);
    }



    /**
     * 安全解析 JSON 字符串为 JsonObject，避免解析异常
     * @param jsonStr 待解析的字符串
     * @return 解析后的 JsonObject（非 JSON 对象返回 null）
     */
    public static JsonObject safeParseJsonObject(String jsonStr) {
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        // 第一步：空值校验
        if (jsonStr == null || jsonStr.trim().isEmpty()) {
            return null;
        }

        String trimmedStr = jsonStr.trim();
        // 第二步：格式初步校验（JSON 对象必须以 { 开头，} 结尾）
        if (!trimmedStr.startsWith("{") || !trimmedStr.endsWith("}")) {
            return null;
        }

        // 第三步：尝试解析，捕获解析异常
        try {
            return gson.fromJson(trimmedStr, JsonObject.class);
        } catch (JsonParseException e) {
            // 解析失败（比如格式不合法的 JSON），返回 null
            System.out.println("JSON 解析失败：" + e.getMessage());
            return null;
        }
    }
}
