package com.zjsgfa.project.zjsgfa.service.impl;

import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.*;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

import cn.hutool.http.HttpUtil;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.zjsgfa.common.utils.DateUtils;
import com.zjsgfa.common.utils.SecurityUtils;
import com.zjsgfa.common.utils.StringUtils;
import com.zjsgfa.common.utils.bean.BeanUtils;
import com.zjsgfa.framework.util.HttpsPostUtil;
import com.zjsgfa.framework.web.domain.AjaxResult;
import com.zjsgfa.project.zjsgfa.domain.*;
import com.zjsgfa.project.zjsgfa.mapper.*;
import com.zjsgfa.project.zt.domain.*;
import com.zjsgfa.project.zt.domain.vo.SjInfo;
import com.zjsgfa.project.zt.mapper.DjdcInfoMapper;
import com.zjsgfa.project.zt.mapper.JsaaMapper;
import com.zjsgfa.project.zt.mapper.JsqaMapper;
import com.zjsgfa.project.zt.service.DjdcService;
import org.jsoup.Jsoup;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.zjsgfa.project.zjsgfa.service.ISjDjjcService;
import org.springframework.transaction.annotation.Transactional;

/**
 * 设计信息-井基础信息Service业务层处理
 * 
 * @author
 * @date 2025-06-23
 */
@Service
public class SjDjjcServiceImpl implements ISjDjjcService 
{
    @Autowired
    private SjDjjcMapper sjDjjcMapper;

    @Autowired
    private DjdcService djdcService;
    @Autowired
    private SjLjjwMapper sjLjjwMapper;

    @Autowired
    private SjZqfxMapper sjZqfxMapper;
    @Autowired
    private SjZtgjsjMapper sjZtgjsjMapper;
    @Autowired
    private SjQkztfxMapper sjQkztfxMapper;
    @Autowired
    private SjJsjgMapper sjJsjgMapper;
    @Autowired
    private SjSzfxjgMapper sjSzfxjgMapper;

    @Autowired
    private SjLjtjztMapper sjLjtjztMapper;

    @Autowired
    private SjZtxxMapper sjZtxxMapper;

    @Autowired
    private SjZjcsxxMapper sjZjcsxxMapper;

    @Autowired
    private JsaaMapper jsaaMapper;

    @Autowired
    private SjFdsgcsMapper sjFdsgcsMapper;

    @Autowired
    private SjSggyZjzhcsMapper sjSggyZjzhcsMapper;

    @Autowired
    private SjFdsgcsLjzjzhMapper sjFdsgcsLjzjzhMapper;


    @Autowired
    private SgfambMapper sgfambMapper;

    @Autowired
    private SgfambKcxxMapper sgfambKcxxMapper;

    @Autowired
    private SgfambKcSggyMapper sgfambKcSggyMapper;

    @Autowired
    private SjJkzpMapper sjJkzpMapper;

    @Autowired
    private SjHseMapper sjHseMapper;

    @Autowired
    private JcxxJkzpMapper jcxxJkzpMapper;
    @Autowired
    private JcxxHseMapper jcxxHseMapper;


    @Autowired
    private SjSggyGjsbxnyqMapper sjSggyGjsbxnyqMapper;

    @Autowired
    private SjZysxMapper sjZysxMapper;

    @Autowired
    private MxglpzMapper mxglpzMapper;

    @Autowired
    private SjZtcsxxMapper sjZtcsxxMapper;

    @Autowired
    private JcxxJdxxMapper jcxxJdxxMapper;

    @Autowired
    private SjFlMapper sjFlMapper;


    @Autowired
    private SjFdsgcsZjfxztMapper sjFdsgcsZjfxztMapper;









    /**
     * 查询设计信息-井基础信息
     * 
     * @param id 设计信息-井基础信息主键
     * @return 设计信息-井基础信息
     */
    @Override
    public SjDjjc selectSjDjjcById(Long id)
    {
        return sjDjjcMapper.selectSjDjjcById(id);
    }

    /**
     * 查询设计信息-井基础信息列表
     * 
     * @param sjDjjc 设计信息-井基础信息
     * @return 设计信息-井基础信息
     */
    @Override
    public List<SjDjjc> selectSjDjjcList(SjDjjc sjDjjc)
    {
        return sjDjjcMapper.selectSjDjjcList(sjDjjc);
    }

    /**
     * 新增设计信息-井基础信息
     * 
     * @param sjDjjc 设计信息-井基础信息
     * @return 结果
     */
    @Override
    @Transactional
    public int insertSjDjjc(SjDjjc sjDjjc) throws Exception {

        SjDjjc sjDjjc1 =sjDjjcMapper.selectSjDjjcByJh(sjDjjc.getJh());
        if(sjDjjc1!=null){
            return 3;
        }
        sjDjjc.setCreatedBy(SecurityUtils.getUsername());
        //施工概要
        SjSggyGjsbxnyq sjSggyGjsbxnyq = new SjSggyGjsbxnyq();
        sjSggyGjsbxnyq.setJh(sjDjjc.getJh());
        if(StringUtils.isNotEmpty(sjDjjc.getZjd())){
            JcxxJdxx jcxxJdxx = jcxxJdxxMapper.selectJcxxJdxxById(Long.parseLong(sjDjjc.getZjd()));
            sjDjjc.setZjgs(jcxxJdxx.getZjgs());
            SjFl sjFl=new SjFl();
            sjFl.setJh(sjDjjc.getJh());
            sjFl.setCreatedBy(SecurityUtils.getUsername());
            sjFl.setYjlxfs(jcxxJdxx.getYjlxr());
            sjFl.setWjsgcs(jcxxJdxx.getWjsgcs());
            sjFl.setYfgkcs(jcxxJdxx.getYfgkcs());
            sjFl.setTsyxzs(jcxxJdxx.getTsyxzs());
            sjFlMapper.insertSjFl(sjFl);
            BeanUtils.copyProperties(jcxxJdxx,sjSggyGjsbxnyq);
        }
        int i = sjDjjcMapper.insertSjDjjc(sjDjjc);

        List<String> sjggjyh= new ArrayList<>();


        //根据方案id查询
        List<SgfambKcSggy> sgfambKcSggyList=sgfambKcSggyMapper.selectSgfambKcSggyListByQk(new SgfambKcSggy());
        List<SgfambKcSggy> collect = sgfambKcSggyList.stream().filter(sgfambKcSggy -> sgfambKcSggy.getZbid().toString().equals(sjDjjc.getFaid().toString())).collect(Collectors.toList());

        for (SgfambKcSggy sgfambKcSggy : collect) {
            if (sgfambKcSggy != null) {
                String gjyhxx=sgfambKcSggy.getKc()+"轨迹优化，"+sgfambKcSggy.getGjyh();
                sjggjyh.add(gjyhxx);
                //查询分段施工
                SjFdsgcs sjFdsgcs = new SjFdsgcs();
                sjFdsgcs.setKc(sgfambKcSggy.getKc());
                sjFdsgcs.setJh(sjDjjc.getJh());
                SjFdsgcs sjFdsgcs1 = sjFdsgcsMapper.selectSjFdsgcsByJhAndKc(sjFdsgcs);
                String zjzh="";

                if(StringUtils.isNotEmpty(sgfambKcSggy.getZjzh())){
                    boolean containsTemplate = sgfambKcSggy.getZjzh().contains("{{") && sgfambKcSggy.getZjzh().contains("}}");
                    if (containsTemplate) {
                        String s= extractFirstVariable(sgfambKcSggy.getZjzh());
                        Mxglpz mxglpz=mxglpzMapper.selectMxglpzByName(s);
                        if(mxglpz!=null){
                            String url = mxglpz.getUrl();
                            String rc = mxglpz.getRc();
                            ObjectMapper objectMapper = new ObjectMapper();

                            // 将JSON字符串转换为Map
                            Map<String, Object> resultMap = objectMapper.readValue(
                                    rc,
                                    new TypeReference<Map<String, Object>>() {}
                            );
                            // 将JSON字符串转换为Map
//                            Map<String, Object> resultMap = new HashMap<>();
//                            resultMap.put("jh", sjDjjc.getJh());
                            String tokenres = HttpUtil.get(url, resultMap);
                            System.out.println(tokenres);
                            zjzh=sgfambKcSggy.getZjzh().replace("{{" + s + "}}", tokenres);

                        }else {
                            zjzh= s;
                        }
                    }else {
                        zjzh= sgfambKcSggy.getZjzh();
                    }
                    zjzh=removeHtmlTags(zjzh);

                }
                String fxts="";
                //邻井风险
                if(StringUtils.isNotEmpty( sgfambKcSggy.getFxts())){
                    SjZysx sjZysx=new SjZysx();
                    sjZysx.setJh(sjDjjc.getJh());
                    sjZysx.setLb("喷漏卡塌");
                    List<SjZysx> sjZysxes = sjZysxMapper.selectSjZysxList(sjZysx);
                    boolean containsTemplate = sgfambKcSggy.getFxts().contains("{{") && sgfambKcSggy.getFxts().contains("}}");

                    if (containsTemplate) {
                        String s= extractFirstVariable(sgfambKcSggy.getFxts());
                        Mxglpz mxglpz=mxglpzMapper.selectMxglpzByName(s);
                        if(mxglpz!=null){
                            String url = mxglpz.getUrl();
                            String rc = mxglpz.getRc();
                            ObjectMapper objectMapper = new ObjectMapper();

                            // 将JSON字符串转换为Map
                            Map<String, Object> resultMap = objectMapper.readValue(
                                    rc,
                                    new TypeReference<Map<String, Object>>() {}
                            );
                            String tokenres = HttpUtil.get(url, resultMap);
                            System.out.println(tokenres);
                            fxts=tokenres;
                        }else {
                            fxts= s;
                        }
                    }else {
                        fxts= sgfambKcSggy.getFxts();
                    }
                    if(sjZysxes.size()>0){
                        SjZysx sjZysx1 = sjZysxes.get(0);
                        sjZysx1.setZysx(fxts);
                        sjZysxMapper.updateSjZysx(sjZysx1);
                    }else {
                        sjZysx.setZysx(fxts);
                        sjZysxMapper.insertSjZysx(sjZysx);
                    }
                }
                if (sjFdsgcs1 != null) {
                    sjFdsgcs1.setJh(sjDjjc.getJh());
                    sjFdsgcs1.setKc(sgfambKcSggy.getKc());
                    sjFdsgcs1.setZjzh(zjzh);
                    sjFdsgcs1.setZjzhzysx(sgfambKcSggy.getZjzhzysx());
                    sjFdsgcs1.setGjfx(sgfambKcSggy.getGjfx());
                    sjFdsgcs1.setGjyh(sgfambKcSggy.getGjyh());
                    sjFdsgcs1.setZjycs(sgfambKcSggy.getZjycs());
                    sjFdsgcs1.setZjgccs(sgfambKcSggy.getZjgccs());
                    sjFdsgcs1.setZyfx(fxts);
                    sjFdsgcs1.setFxgkcs(sgfambKcSggy.getFxgkcs());
                    sjFdsgcsMapper.updateSjFdsgcs(sjFdsgcs1);
                } else {
                    sjFdsgcs1 = new SjFdsgcs();
                    sjFdsgcs1.setJh(sjDjjc.getJh());
                    sjFdsgcs1.setKc(sgfambKcSggy.getKc());
                    sjFdsgcs1.setZjzh(zjzh);
                    sjFdsgcs1.setZjzhzysx(sgfambKcSggy.getZjzhzysx());
                    sjFdsgcs1.setGjfx(sgfambKcSggy.getGjfx());
                    sjFdsgcs1.setGjyh(sgfambKcSggy.getGjyh());
                    sjFdsgcs1.setZjycs(sgfambKcSggy.getZjycs());
                    sjFdsgcs1.setZjgccs(sgfambKcSggy.getZjgccs());
                    sjFdsgcs1.setZyfx(fxts);
                    sjFdsgcs1.setFxgkcs(sgfambKcSggy.getFxgkcs());
                    sjFdsgcsMapper.insertSjFdsgcs(sjFdsgcs1);
                }
                SjZtxx sjZtxx = new SjZtxx();
                sjZtxx.setJh(sjDjjc.getJh());
                sjZtxx.setKc(sgfambKcSggy.getKc());
                List<SjZtxx> sjZtxxes = sjZtxxMapper.selectSjZtxxList(sjZtxx);
                if (sjZtxxes.size() > 0) {
                    SjZtxx sjZtxx1 = sjZtxxes.get(0);
                    sjZtxx1.setZtxh(sgfambKcSggy.getZtxh());
                    sjZtxx.setLb("高指标井推荐");
                    sjZtxxMapper.updateSjZtxx(sjZtxx1);
                } else {
                    sjZtxx.setZtxh(sgfambKcSggy.getZtxh());
                    sjZtxx.setLb("高指标井推荐");
                    sjZtxxMapper.insertSjZtxx(sjZtxx);
                }
                SjZjcsxx sjZjcsxx = new SjZjcsxx();
                sjZjcsxx.setJh(sjDjjc.getJh());
                sjZjcsxx.setKc(sgfambKcSggy.getKc());
                List<SjZjcsxx> sjZjcsxxes = sjZjcsxxMapper.selectSjZjcsxxList(sjZjcsxx);
                if (sjZjcsxxes.size() > 0) {
                    SjZjcsxx sjZjcsxx1 = sjZjcsxxes.get(0);
                    sjZjcsxx1.setZjzy(sgfambKcSggy.getZjzy());
                    sjZjcsxx1.setZjzs(sgfambKcSggy.getZjzs());
                    sjZjcsxx1.setZjpl(sgfambKcSggy.getZjpl());
                    sjZjcsxx1.setZjby(sgfambKcSggy.getZjby());
                    sjZjcsxx1.setZjzysx(sgfambKcSggy.getZjzysx());
                    sjZjcsxx1.setZjbysx(sgfambKcSggy.getZjbysx());
                    sjZjcsxx1.setZjzssx(sgfambKcSggy.getZjzssx());
                    sjZjcsxx1.setZjplsx(sgfambKcSggy.getZjplsx());
                    sjZjcsxx1.setCj(sgfambKcSggy.getCj());
                    sjZjcsxx1.setCc(sgfambKcSggy.getCc());
                    sjZjcsxx1.setSy(sgfambKcSggy.getSy());
                    sjZjcsxx1.setYj(sgfambKcSggy.getYj());
                    sjZjcsxx1.setZjymd(sgfambKcSggy.getZjymd());
                    sjZjcsxx1.setZtxh(sgfambKcSggy.getZtxh());
                    sjZjcsxx1.setDy(sgfambKcSggy.getDy());
                    sjZjcsxx1.setFfp(sgfambKcSggy.getFfp());
                    sjZjcsxx1.setFfpcx(sgfambKcSggy.getFfpcx());
                    sjZjcsxxMapper.updateSjZjcsxx(sjZjcsxx1);
                } else {
                    sjZjcsxx.setZjzy(sgfambKcSggy.getZjzy());
                    sjZjcsxx.setZjzs(sgfambKcSggy.getZjzs());
                    sjZjcsxx.setZjpl(sgfambKcSggy.getZjpl());
                    sjZjcsxx.setZjby(sgfambKcSggy.getZjby());
                    sjZjcsxx.setZjzysx(sgfambKcSggy.getZjzysx());
                    sjZjcsxx.setZjbysx(sgfambKcSggy.getZjbysx());
                    sjZjcsxx.setZjzssx(sgfambKcSggy.getZjzssx());
                    sjZjcsxx.setZjplsx(sgfambKcSggy.getZjplsx());
                    sjZjcsxx.setCj(sgfambKcSggy.getCj());
                    sjZjcsxx.setCc(sgfambKcSggy.getCc());
                    sjZjcsxx.setSy(sgfambKcSggy.getSy());
                    sjZjcsxx.setYj(sgfambKcSggy.getYj());
                    sjZjcsxx.setZjymd(sgfambKcSggy.getZjymd());
                    sjZjcsxx.setZtxh(sgfambKcSggy.getZtxh());
                    sjZjcsxx.setDy(sgfambKcSggy.getDy());
                    sjZjcsxx.setFfp(sgfambKcSggy.getFfp());
                    sjZjcsxx.setFfpcx(sgfambKcSggy.getFfpcx());
                    sjZjcsxxMapper.insertSjZjcsxx(sjZjcsxx);
                }
                //保存施工概要钻具组合
                SjSggyZjzhcs sjSggyZjzhcs= new SjSggyZjzhcs();
                sjSggyZjzhcs.setJh(sjDjjc.getJh());
                sjSggyZjzhcs.setKc(sgfambKcSggy.getKc());
                SjSggyZjzhcs sjSggyZjzhcs1 = sjSggyZjzhcsMapper.selectSjSggyZjzhcsByZjzhcs(sjSggyZjzhcs);
                if(sjSggyZjzhcs1!=null){
                    sjSggyZjzhcs1.setZjjg(zjzh);
                    sjSggyZjzhcs1.setZtxh(sjZjcsxx.getZtxh());
                    sjSggyZjzhcs1.setCc(sjZjcsxx.getCc());
                    sjSggyZjzhcs1.setSy(sjZjcsxx.getSy());
                    sjSggyZjzhcs1.setZjymd(sjZjcsxx.getZjymd());
                    sjSggyZjzhcs1.setCj(sjZjcsxx.getCj());
                    sjSggyZjzhcs1.setYj(sjZjcsxx.getYj());
                    sjSggyZjzhcs1.setZjzy(StringUtils.isNotEmpty(sjZjcsxx.getZjzysx())?sjZjcsxx.getZjzy()+"-"+sjZjcsxx.getZjzysx():sjZjcsxx.getZjzy());
                    sjSggyZjzhcs1.setZjzs(StringUtils.isNotEmpty(sjZjcsxx.getZjzssx())?sjZjcsxx.getZjzs()+"-"+sjZjcsxx.getZjzssx():sjZjcsxx.getZjzs());
                    sjSggyZjzhcs1.setZjby(StringUtils.isNotEmpty(sjZjcsxx.getZjbysx())?sjZjcsxx.getZjby()+"-"+sjZjcsxx.getZjbysx():sjZjcsxx.getZjby());
                    sjSggyZjzhcs1.setZjpl(StringUtils.isNotEmpty(sjZjcsxx.getZjplsx() )?sjZjcsxx.getZjpl()+"-"+sjZjcsxx.getZjplsx() :sjZjcsxx.getZjpl());
                    sjSggyZjzhcsMapper.updateSjSggyZjzhcs(sjSggyZjzhcs1);
                }else {
                    sjSggyZjzhcs1=new SjSggyZjzhcs();
                    sjSggyZjzhcs1.setJh(sjZjcsxx.getJh());
                    sjSggyZjzhcs1.setKc(sjZjcsxx.getKc());
                    sjSggyZjzhcs1.setZjjg(zjzh);
                    sjSggyZjzhcs1.setZtxh(sjZjcsxx.getZtxh());
                    sjSggyZjzhcs1.setCc(sjZjcsxx.getCc());
                    sjSggyZjzhcs1.setSy(sjZjcsxx.getSy());
                    sjSggyZjzhcs1.setZjymd(sjZjcsxx.getZjymd());
                    sjSggyZjzhcs1.setCj(sjZjcsxx.getCj());
                    sjSggyZjzhcs1.setYj(sjZjcsxx.getYj());
                    sjSggyZjzhcs1.setZjzy(StringUtils.isNotEmpty(sjZjcsxx.getZjzysx())?sjZjcsxx.getZjzy()+"-"+sjZjcsxx.getZjzysx():sjZjcsxx.getZjzy());
                    sjSggyZjzhcs1.setZjzs(StringUtils.isNotEmpty(sjZjcsxx.getZjzssx())?sjZjcsxx.getZjzs()+"-"+sjZjcsxx.getZjzssx():sjZjcsxx.getZjzs());
                    sjSggyZjzhcs1.setZjby(StringUtils.isNotEmpty(sjZjcsxx.getZjbysx())?sjZjcsxx.getZjby()+"-"+sjZjcsxx.getZjbysx():sjZjcsxx.getZjby());
                    sjSggyZjzhcs1.setZjpl(StringUtils.isNotEmpty(sjZjcsxx.getZjplsx() )?sjZjcsxx.getZjpl()+"-"+sjZjcsxx.getZjplsx() :sjZjcsxx.getZjpl());
                    sjSggyZjzhcsMapper.insertSjSggyZjzhcs(sjSggyZjzhcs1);
                }

            }
        }
        sjSggyGjsbxnyq.setSjyh(String.join(" \n", sjggjyh));
        sjSggyGjsbxnyqMapper.insertSjSggyGjsbxnyq(sjSggyGjsbxnyq);


        //井口装置
        List<JcxxJkzp> jcxxJkzps = jcxxJkzpMapper.selectJcxxJkzpList(new JcxxJkzp());
        JcxxJkzp jcxxJkzp = jcxxJkzps.stream().filter(it -> it.getQk().equals(sjDjjc.getQk())).findFirst().orElse(null);

       if(jcxxJkzp!=null){
           SjJkzp sjJkzp =new SjJkzp();
           sjJkzp.setJh(sjDjjc.getJh());
           sjJkzp.setClcb(jcxxJkzp.getClcb());
           sjJkzp.setJlgh(jcxxJkzp.getJlgh());
           sjJkzp.setSyyq(jcxxJkzp.getSyyq());
           sjJkzp.setZjkzz(jcxxJkzp.getZjkzz());
           sjJkzpMapper.insertSjJkzp(sjJkzp);
       }
        List<JcxxHse> jcxxHses = jcxxHseMapper.selectJcxxHseList(new JcxxHse());
        JcxxHse jcxxHse = jcxxHses.stream().filter(it -> it.getQk().equals(sjDjjc.getQk())).findFirst().orElse(null);
        if(jcxxHse!=null){
            SjHse sjHse =new SjHse();
            sjHse.setJh(sjDjjc.getJh());
            sjHse.setHse(jcxxHse.getHse());
            sjHseMapper.insertSjHse(sjHse);
        }

        return i;

    }
    public static String removeHtmlTags(String htmlContent) {
        if (htmlContent == null || htmlContent.isEmpty()) {
            return "";
        }
        // 方式1：直接提取纯文本（保留换行）
        String plainText = Jsoup.parse(htmlContent).text();

        // 方式2：清理HTML（可自定义保留标签/属性）
        // String cleanHtml = Jsoup.clean(htmlContent, Safelist.none()); // 无标签

        return plainText;
    }

    /**
     * 提取字符串中第一个{{}}包裹的内容
     * @param input 输入字符串
     * @return 第一个匹配的内容，若没有匹配则返回null
     */
    public static String extractFirstVariable(String input) {
        // 正则表达式匹配{{和}}之间的内容
        Pattern pattern = Pattern.compile("\\{\\{(.*?)\\}\\}");
        Matcher matcher = pattern.matcher(input);

        // 只查找第一个匹配项
        if (matcher.find()) {
            return matcher.group(1); // 返回第一个匹配项的内容
        }
        return null; // 没有找到匹配项
    }

    /**
     * 修改设计信息-井基础信息
     * 
     * @param sjDjjc 设计信息-井基础信息
     * @return 结果
     */
    @Override
    @Transactional
    public int updateSjDjjc(SjDjjc sjDjjc)  throws Exception
    {
        sjDjjc.setUpdateTime(DateUtils.getNowDate());
        sjDjjc.setUpdateBy(SecurityUtils.getUsername());

        List<String> sjggjyh= new ArrayList<>();
        List<SgfambKcSggy> sgfambKcSggyList=sgfambKcSggyMapper.selectSgfambKcSggyListByQk(new SgfambKcSggy());
        List<SgfambKcSggy> collect = sgfambKcSggyList.stream().filter(sgfambKcSggy -> sgfambKcSggy.getZbid().toString().equals(sjDjjc.getFaid().toString())).collect(Collectors.toList());
        for (SgfambKcSggy sgfambKcSggy : collect) {
            if (sgfambKcSggy != null) {
                String gjyhxx=sgfambKcSggy.getKc()+"轨迹优化，"+sgfambKcSggy.getGjyh();
                sjggjyh.add(gjyhxx);
                //查询分段施工
                SjFdsgcs sjFdsgcs = new SjFdsgcs();
                sjFdsgcs.setKc(sgfambKcSggy.getKc());
                sjFdsgcs.setJh(sjDjjc.getJh());
                SjFdsgcs sjFdsgcs1 = sjFdsgcsMapper.selectSjFdsgcsByJhAndKc(sjFdsgcs);
                String zjzh="";

                if(StringUtils.isNotEmpty(sgfambKcSggy.getZjzh())){
                    boolean containsTemplate = sgfambKcSggy.getZjzh().contains("{{") && sgfambKcSggy.getZjzh().contains("}}");
                    if (containsTemplate) {
                        String s= extractFirstVariable(sgfambKcSggy.getZjzh());
                        Mxglpz mxglpz=mxglpzMapper.selectMxglpzByName(s);
                        if(mxglpz!=null){
                            String url = mxglpz.getUrl();
                            String rc = mxglpz.getRc();
                            ObjectMapper objectMapper = new ObjectMapper();

                            // 将JSON字符串转换为Map
                            Map<String, Object> resultMap = objectMapper.readValue(
                                    rc,
                                    new TypeReference<Map<String, Object>>() {}
                            );
                            // 将JSON字符串转换为Map
//                            Map<String, Object> resultMap = new HashMap<>();
//                            resultMap.put("jh", sjDjjc.getJh());
                            String tokenres = HttpUtil.get(url, resultMap);
                            System.out.println(tokenres);
                            zjzh=sgfambKcSggy.getZjzh().replace("{{" + s + "}}", tokenres);

                        }else {
                            zjzh= s;
                        }
                    }else {
                        zjzh= sgfambKcSggy.getZjzh();
                    }
                    zjzh=removeHtmlTags(zjzh);

                }
                String fxts="区块风险：<p>";
                //邻井风险
                if(StringUtils.isNotEmpty( sgfambKcSggy.getFxts())){
                    SjZysx sjZysx=new SjZysx();
                    sjZysx.setJh(sjDjjc.getJh());
                    sjZysx.setLb("喷漏卡塌");
                    List<SjZysx> sjZysxes = sjZysxMapper.selectSjZysxList(sjZysx);
                    boolean containsTemplate = sgfambKcSggy.getFxts().contains("{{") && sgfambKcSggy.getFxts().contains("}}");

                    if (containsTemplate) {
                        String s= extractFirstVariable(sgfambKcSggy.getFxts());
                        Mxglpz mxglpz=mxglpzMapper.selectMxglpzByName(s);
                        if(mxglpz!=null){
                            String url = mxglpz.getUrl();
                            String rc = mxglpz.getRc();
                            ObjectMapper objectMapper = new ObjectMapper();

                            // 将JSON字符串转换为Map
                            Map<String, Object> resultMap = objectMapper.readValue(
                                    rc,
                                    new TypeReference<Map<String, Object>>() {}
                            );
                            String tokenres = HttpUtil.get(url, resultMap);
                            System.out.println(tokenres);
                            fxts+=tokenres;
                        }else {
                            fxts+= s;
                        }
                    }else {
                        fxts+= sgfambKcSggy.getFxts();
                    }
                    if (fxts.equals("区块风险：<p>")){
                        fxts="";
                    }
                    if(sjZysxes.size()>0){
                        SjZysx sjZysx1 = sjZysxes.get(0);
                        sjZysx1.setZysx(fxts);
                        sjZysxMapper.updateSjZysx(sjZysx1);
                    }else {
                        sjZysx.setZysx(fxts);
                        sjZysxMapper.insertSjZysx(sjZysx);
                    }
                }
                if (sjFdsgcs1 != null) {
                    sjFdsgcs1.setJh(sjDjjc.getJh());
                    sjFdsgcs1.setKc(sgfambKcSggy.getKc());
                    sjFdsgcs1.setZjzh(zjzh);
                    sjFdsgcs1.setZjzhzysx(sgfambKcSggy.getZjzhzysx());
                    sjFdsgcs1.setGjfx(sgfambKcSggy.getGjfx());
                    sjFdsgcs1.setGjyh(sgfambKcSggy.getGjyh());
                    sjFdsgcs1.setZjycs(sgfambKcSggy.getZjycs());
                    sjFdsgcs1.setFxgkcs(sgfambKcSggy.getFxgkcs());
                    sjFdsgcs1.setZjgccs(sgfambKcSggy.getZjgccs());
                    sjFdsgcs1.setZyfx(fxts);
                    sjFdsgcs1.setFxgkcs(sgfambKcSggy.getFxgkcs());
                    sjFdsgcsMapper.updateSjFdsgcs(sjFdsgcs1);
                } else {
                    sjFdsgcs1 = new SjFdsgcs();
                    sjFdsgcs1.setJh(sjDjjc.getJh());
                    sjFdsgcs1.setKc(sgfambKcSggy.getKc());
                    sjFdsgcs1.setZjzh(zjzh);
                    sjFdsgcs1.setZjzhzysx(sgfambKcSggy.getZjzhzysx());
                    sjFdsgcs1.setGjfx(sgfambKcSggy.getGjfx());
                    sjFdsgcs1.setGjyh(sgfambKcSggy.getGjyh());
                    sjFdsgcs1.setZjycs(sgfambKcSggy.getZjycs());
                    sjFdsgcs1.setZjgccs(sgfambKcSggy.getZjgccs());
                    sjFdsgcs1.setFxgkcs(sgfambKcSggy.getFxgkcs());
                    sjFdsgcs1.setZyfx(fxts);
                    sjFdsgcs1.setFxgkcs(sgfambKcSggy.getFxgkcs());
                    sjFdsgcsMapper.insertSjFdsgcs(sjFdsgcs1);
                }
                SjZtxx sjZtxx = new SjZtxx();
                sjZtxx.setJh(sjDjjc.getJh());
                sjZtxx.setKc(sgfambKcSggy.getKc());
                sjZtxx.setLb("高指标井推荐");
                List<SjZtxx> sjZtxxes = sjZtxxMapper.selectSjZtxxList(sjZtxx);
                if (sjZtxxes.size() > 0) {
                    SjZtxx sjZtxx1 = sjZtxxes.get(0);
                    sjZtxx1.setZtxh(sgfambKcSggy.getZtxh());
                    sjZtxx1.setKc(sgfambKcSggy.getKc());
                    sjZtxx1.setLb("高指标井推荐");
                    sjZtxxMapper.updateSjZtxx(sjZtxx1);
                } else {
                    sjZtxx.setZtxh(sgfambKcSggy.getZtxh());
                    sjZtxx.setKc(sgfambKcSggy.getKc());
                    sjZtxx.setLb("高指标井推荐");
                    sjZtxxMapper.insertSjZtxx(sjZtxx);
                }
//                SjZjcsxx sjZjcsxx = new SjZjcsxx();
//                sjZjcsxx.setJh(sjDjjc.getJh());
//                sjZjcsxx.setKc(sgfambKcSggy.getKc());
//                List<SjZjcsxx> sjZjcsxxes = sjZjcsxxMapper.selectSjZjcsxxList(sjZjcsxx);
//                if (sjZjcsxxes.size() > 0) {
//                    SjZjcsxx sjZjcsxx1 = sjZjcsxxes.get(0);
//                    sjZjcsxx1.setZjzy(sgfambKcSggy.getZjzy());
//                    sjZjcsxx1.setZjzs(sgfambKcSggy.getZjzs());
//                    sjZjcsxx1.setZjpl(sgfambKcSggy.getZjpl());
//                    sjZjcsxx1.setZjby(sgfambKcSggy.getZjby());
//                    sjZjcsxx1.setZjzysx(sgfambKcSggy.getZjzysx());
//                    sjZjcsxx1.setZjbysx(sgfambKcSggy.getZjbysx());
//                    sjZjcsxx1.setZjzssx(sgfambKcSggy.getZjzssx());
//                    sjZjcsxx1.setZjplsx(sgfambKcSggy.getZjplsx());
//                    sjZjcsxx1.setCj(sgfambKcSggy.getCj());
//                    sjZjcsxx1.setCc(sgfambKcSggy.getCc());
//                    sjZjcsxx1.setSy(sgfambKcSggy.getSy());
//                    sjZjcsxx1.setYj(sgfambKcSggy.getYj());
//                    sjZjcsxx1.setZjymd(sgfambKcSggy.getZjymd());
//                    sjZjcsxx1.setZtxh(sgfambKcSggy.getZtxh());
//                    sjZjcsxx.setDy(sgfambKcSggy.getDy());
//                    sjZjcsxx.setFfp(sgfambKcSggy.getFfp());
//                    sjZjcsxx.setFfpcx(sgfambKcSggy.getFfpcx());
//                    sjZjcsxxMapper.updateSjZjcsxx(sjZjcsxx1);
//                } else {
//                    sjZjcsxx.setZjzy(sgfambKcSggy.getZjzy());
//                    sjZjcsxx.setZjzs(sgfambKcSggy.getZjzs());
//                    sjZjcsxx.setZjpl(sgfambKcSggy.getZjpl());
//                    sjZjcsxx.setZjby(sgfambKcSggy.getZjby());
//                    sjZjcsxx.setZjzysx(sgfambKcSggy.getZjzysx());
//                    sjZjcsxx.setZjbysx(sgfambKcSggy.getZjbysx());
//                    sjZjcsxx.setZjzssx(sgfambKcSggy.getZjzssx());
//                    sjZjcsxx.setZjplsx(sgfambKcSggy.getZjplsx());
//                    sjZjcsxx.setCj(sgfambKcSggy.getCj());
//                    sjZjcsxx.setCc(sgfambKcSggy.getCc());
//                    sjZjcsxx.setSy(sgfambKcSggy.getSy());
//                    sjZjcsxx.setYj(sgfambKcSggy.getYj());
//                    sjZjcsxx.setZjymd(sgfambKcSggy.getZjymd());
//                    sjZjcsxx.setZtxh(sgfambKcSggy.getZtxh());
//                    sjZjcsxx.setDy(sgfambKcSggy.getDy());
//                    sjZjcsxx.setFfp(sgfambKcSggy.getFfp());
//                    sjZjcsxx.setFfpcx(sgfambKcSggy.getFfpcx());
//                    sjZjcsxxMapper.insertSjZjcsxx(sjZjcsxx);
//                }
//                //钻头参数信息
//                SjZtcsxx sjZtcsxx = new SjZtcsxx();
//                sjZtcsxx.setJh(sjDjjc.getJh());
//                sjZtcsxx.setKc(sgfambKcSggy.getKc());
//                sjZtcsxx.setLb("高指标井推荐");
//                sjZtcsxx.setDy(sgfambKcSggy.getDy());
//                sjZtcsxx.setZtxh(sgfambKcSggy.getZtxh());
//                sjZtcsxx.setSy(sgfambKcSggy.getSy());
//                sjZtcsxx.setFfp(sgfambKcSggy.getFfp());
//                sjZtcsxx.setFfpcx(sgfambKcSggy.getFfpcx());
//                sjZtcsxxMapper.deleteSjZtcsxxByJhAndKcAndlb(sjZtcsxx);
//                sjZtcsxxMapper.insertSjZtcsxx(sjZtcsxx);
            }
        }


        return sjDjjcMapper.updateSjDjjc(sjDjjc);
    }

    /**
     * 批量删除设计信息-井基础信息
     * 
     * @param ids 需要删除的设计信息-井基础信息主键
     * @return 结果
     */
    @Override
    public int deleteSjDjjcByIds(Long[] ids)
    {


        int i = sjDjjcMapper.deleteSjDjjcByIds(ids);



        return i;
    }

    /**
     * 删除设计信息-井基础信息信息
     * 
     * @param id 设计信息-井基础信息主键
     * @return 结果
     */
    @Override
    public int deleteSjDjjcById(Long id)
    {
        SjDjjc sjDjjc = selectSjDjjcById(id);

        sjDjjcMapper.batchDeleteByJhPrefix(sjDjjc.getJh());

        int i = sjDjjcMapper.deleteSjDjjcById(id);

        return i;
    }

    @Override
    public AjaxResult saveLjzl(CommonParam param) throws Exception {
        String jh = param.getSjjh();
        String ljjh = param.getJh();
        SjDjjc sjDjjc = sjDjjcMapper.selectSjDjjcByJh(jh);
        param.setQk(sjDjjc.getQk());
        param.setJkhzb(sjDjjc.getJkhzb());
        param.setJkzzb(sjDjjc.getJkzzb());
        param.setJdhzb(sjDjjc.getJdhzb());
        param.setJdzzb(sjDjjc.getJdzzb());
        param.setJh(null);

        String[] jh_list = ljjh.split(",");

        CommonParam param1 = new CommonParam();
        param1.setJh(ljjh);
        param1.setQk(sjDjjc.getQk());
        //周期分析
        List<DjZqsjfx> zqshfxList = djdcService.getZqshfxList(param1);
        List<SjZqfx> sjZqfxList=new ArrayList<>();
        zqshfxList.forEach(item->{
            String kc  =item.getKc();
            if(kc.equals("1")){
                kc="一开";
            }else if(kc.equals("2")){
                kc="二开";
            }else if(kc.equals("3")){
                kc="三开";
            }else if(kc.equals("4")){
                kc="四开";
            }else if(kc.equals("5")){
                kc="五开";
            }
            SjZqfx sjZqfx=new SjZqfx();
            BeanUtils.copyProperties(item,sjZqfx);
            sjZqfx.setJh(jh);
            sjZqfx.setKc(kc);
            sjZqfx.setLjjh(item.getJh());
            sjZqfx.setCw(item.getCw());
            sjZqfx.setZjzq(item.getZjzq());
            sjZqfx.setZjycsl(item.getZjycsl());
            sjZqfx.setZjsczq(item.getZjsczq());
            sjZqfx.setZjsl(item.getZjsl());
            sjZqfx.setZwzq(item.getZwzq());
            sjZqfx.setWjycsl(item.getWjycsl());
            sjZqfx.setWjsczq(item.getWjsczq());
            sjZqfx.setZjycms(item.getZjycms());
            sjZqfx.setWjycms(item.getWjycms());
            sjZqfxList.add(sjZqfx);
        });
        if(sjZqfxList.size()>0){
            sjZqfxMapper.deleteSjZqfxByJh(jh);
            sjZqfxMapper.insertSjZqfxBatch(sjZqfxList);
        }
        //钻头关键数据
        List<Djjc> djjcList = djdcService.getDjjcList(param1);
        List<SjZtgjsj> sjZtgjsjList=new ArrayList<>();

        djjcList.forEach(item->{
            SjZtgjsj sjZtgjsj=new SjZtgjsj();
            BeanUtils.copyProperties(item,sjZtgjsj);
            sjZtgjsj.setJh(jh);
            sjZtgjsj.setLjjh(item.getJh());
            String kc  =item.getKc();
            if(kc.equals("1")){
                kc="一开";
            }else if(kc.equals("2")){
                kc="二开";
            }else if(kc.equals("3")){
                kc="三开";
            }else if(kc.equals("4")){
                kc="四开";
            }else if(kc.equals("5")){
                kc="五开";
            }
            sjZtgjsj.setKc(kc);
            sjZtgjsjList.add(sjZtgjsj);
        });
        if(sjZtgjsjList.size()>0){
            sjZtgjsjMapper.deleteSjZtgjsjByJh(jh);
            sjZtgjsjMapper.insertSjZtgjsjBatch(sjZtgjsjList);
        }
        //区块钻头分析
        List<SjQkztfx> sjQkztfxList=new ArrayList<>();
        CommonParam commonParam =new CommonParam();
        commonParam.setQk(sjDjjc.getQk());
        List<DjZtfx> djZtfxList = djdcService.getDjZtfxList(commonParam);
        djZtfxList.forEach(item->{
            SjQkztfx sjQkztfx=new SjQkztfx();
            BeanUtils.copyProperties(item,sjQkztfx);
            sjQkztfx.setJh(jh);
            sjQkztfx.setLb("区块");
            String kc  =item.getKc();
            if(kc.equals("1")){
                kc="一开";
            }else if(kc.equals("2")){
                kc="二开";
            }else if(kc.equals("3")){
                kc="三开";
            }else if(kc.equals("4")){
                kc="四开";
            }else if(kc.equals("5")){
                kc="五开";
            }
            sjQkztfx.setKc(kc);
            sjQkztfxList.add(sjQkztfx);
        });

        //根据高指标井
        commonParam.setJh(ljjh);
        commonParam.setQk(null);
        List<DjZtfx> djZtfxList2 = djdcService.getDjZtfxList(commonParam);
        djZtfxList2.forEach(item->{
            SjQkztfx sjQkztfx=new SjQkztfx();
            BeanUtils.copyProperties(item,sjQkztfx);
            sjQkztfx.setJh(jh);
            sjQkztfx.setLb("高指标");
            String kc  =item.getKc();
            if(kc.equals("1")){
                kc="一开";
            }else if(kc.equals("2")){
                kc="二开";
            }else if(kc.equals("3")){
                kc="三开";
            }else if(kc.equals("4")){
                kc="四开";
            }else if(kc.equals("5")){
                kc="五开";
            }
            sjQkztfx.setKc(kc);
            sjQkztfxList.add(sjQkztfx);
        });


        if(sjQkztfxList.size()>0){
            sjQkztfxMapper.deleteSjQkztfxByJh(jh);
            sjQkztfxMapper.insertSjQkztfxBatch(sjQkztfxList);
        }




        //实钻分析结果
        SjJsjg sjJsjg =new SjJsjg();
        sjJsjg.setJh(jh);
        List<SjJsjg> sjJsjgList = sjJsjgMapper.selectSjJsjgList(sjJsjg);
        List<SjInfo> sjInfoList=new ArrayList<>();
        for(int i=0;i<sjJsjgList.size();i++){
            SjInfo sjInfo =new SjInfo();
            sjInfo.setKc((i+1)+"");
            sjInfo.setZtcc(sjJsjgList.get(i).getZtzj());
            sjInfoList.add(sjInfo);
        }
        CommonParam zsParam=new CommonParam();
        zsParam.setSj(sjInfoList);
        zsParam.setJh(ljjh);
        List<LjSzfxjg> ljSzfxjgList=djdcService.getSztfxjgList(djZtfxList,djjcList,zsParam);
        List<SjSzfxjg> sjSzfxjgList=new ArrayList<>();
        ljSzfxjgList.forEach(item->{
            SjSzfxjg sjSzfxjg=new SjSzfxjg();
            BeanUtils.copyProperties(item,sjSzfxjg);
            sjSzfxjg.setJh(jh);
            String kc  =item.getFxfw();
            if(kc.equals("1开")){
                kc="一开";
            }else if(kc.equals("2开")){
                kc="二开";
            }else if(kc.equals("3开")){
                kc="三开";
            }else if(kc.equals("4开")){
                kc="四开";
            }else if(kc.equals("5开")){
                kc="五开";
            }
            sjSzfxjg.setFxfw(kc);
            sjSzfxjgList.add(sjSzfxjg);
        });
        if(sjSzfxjgList.size()>0){
            sjSzfxjgMapper.deleteSjSzfxjgByJh(jh);
            sjSzfxjgMapper.insertSjSzfxjgBatch(sjSzfxjgList);
        }
        //分段专家分析数据表格
        List<SjFdsgcsZjfxzt> sjFdsgcsZjfxztList = new ArrayList<>();
        sjSzfxjgList.forEach(item->{
            SjFdsgcsZjfxzt sjFdsgcsZjfxzt=new SjFdsgcsZjfxzt();
            sjFdsgcsZjfxzt.setJh(jh);
            sjFdsgcsZjfxzt.setKc(item.getFxfw());
            sjFdsgcsZjfxzt.setZyjy(item.getZyjy());
            sjFdsgcsZjfxzt.setQcyj(item.getQcyj());
            sjFdsgcsZjfxzt.setTjpf(item.getTjpf());
            sjFdsgcsZjfxzt.setYxyj(item.getYxyj());
            sjFdsgcsZjfxztList.add(sjFdsgcsZjfxzt);
        });
        if(sjFdsgcsZjfxztList.size()>0){
            sjFdsgcsZjfxztMapper.deleteSjFdsgcsZjfxztByjh(jh);
            sjFdsgcsZjfxztMapper.insertSjFdsgcsZjfxztBatch(sjFdsgcsZjfxztList);
        }



        return AjaxResult.success();
    }











    @Override
    public AjaxResult saveZtxh(CommonParam param) {
        String jh = param.getSjjh();
        SjZtgjsj sjZtgjsj = new SjZtgjsj();
        sjZtgjsj.setJh(jh);
        List<SjZtgjsj> sjZtgjsjList = sjZtgjsjMapper.selectSjZtgjsjList(sjZtgjsj);
        SjJsjg sjJsjg = new SjJsjg();
        sjJsjg.setJh(jh);
        List<SjJsjg> sjJsjgList = sjJsjgMapper.selectSjJsjgList(sjJsjg);
        List<SjLjtjzt> sjLjtjztList=new ArrayList<>();
        SjDjjc sjDjjc=sjDjjcMapper.selectSjDjjcByJh(jh);
        SjSzfxjg sjSzfxjg = new SjSzfxjg();
        sjSzfxjg.setJh(jh);
        List<SjSzfxjg> sjSzfxjgs = sjSzfxjgMapper.selectSjSzfxjgList(sjSzfxjg);


//        List<SgfambKcSggy> sgfambKcSggyList=sgfambKcSggyMapper.selectSgfambKcSggyListByQk(new SgfambKcSggy());
//        List<SgfambKcSggy> sggyList = new ArrayList<>();
//        if(sjDjjc.getFaid()!=null){
//            sggyList = sgfambKcSggyList.stream().filter(sgfambKcSggy -> sgfambKcSggy.getZbid().toString().equals(sjDjjc.getFaid().toString())).collect(Collectors.toList());
//        }


        double ksjs=0;
        for(int i=0;i<sjJsjgList.size();i++){
            SjJsjg sjJsjg1 = sjJsjgList.get(i);
            if(i==0){
                ksjs=0;
            }else {
                ksjs=sjJsjgList.get(i-1).getJs();
            }
            final int kc=i+1;
            //查询钻头关键数据
            List<SjZtgjsj> collect = sjZtgjsjList.stream()
                    .filter(it ->sjJsjg1.getKc().equals(it.getKc()))
                    .sorted(Comparator.comparing(SjZtgjsj::getJxzs,
                                    Comparator.nullsLast(Comparator.reverseOrder())))
                    .collect(Collectors.toList());
            if(collect.size()>3){
                collect=collect.subList(0,3);
            }
            SjSzfxjg jczg = sjSzfxjgs.stream().filter(it -> it.getFxfw().equals(sjJsjg1.getKc()) && it.getYxyj().equals("机速最快")).findFirst().orElse(null);
            if(jczg!=null){
                SjZtxx sjZtxx =new SjZtxx();
                sjZtxx.setJh(jh);
                sjZtxx.setKc(sjJsjg1.getKc());
                sjZtxx.setZtxh(jczg.getZyjy());
                sjZtxx.setLb("专家分析");
                sjZtxxMapper.deleteSjZtxxByZtxx(sjZtxx);
                sjZtxxMapper.insertSjZtxx(sjZtxx);
                SjZjcsxx sjZjcsxx = new SjZjcsxx();
                sjZjcsxx.setJh(sjDjjc.getJh());
                sjZjcsxx.setKc(sjJsjg1.getKc());
                List<SjZjcsxx> sjZjcsxxes = sjZjcsxxMapper.selectSjZjcsxxList(sjZjcsxx);
                if(sjZjcsxxes.size()>0){
                    SjZjcsxx sjZjcsxx1 = sjZjcsxxes.get(0);
                    sjZjcsxx1.setZtxh(jczg.getZyjy());
                    sjZjcsxxMapper.updateSjZjcsxx(sjZjcsxx1);
                }

            }

            SjZtxx sjZtxx =new SjZtxx();
            collect.forEach(it->{
                SjLjtjzt sjLjtjzt=new SjLjtjzt();
                sjLjtjzt.setJh(jh);
                sjLjtjzt.setLjjh(it.getLjjh());
                sjLjtjzt.setKc(sjJsjg1.getKc());
                sjLjtjzt.setCc(it.getZtcc());
                sjLjtjzt.setZtxh(it.getZtxh());
                sjLjtjzt.setSy(it.getPz());
                sjLjtjzt.setZjjd(it.getJd());
                sjLjtjzt.setCw(it.getCw());
                sjLjtjzt.setJxzs(it.getJxzs());
                //查询厂家
                Djjc djjc = new Djjc();
                djjc.setJh(it.getLjjh());
                djjc.setKc(kc+"");
                djjc.setJd(it.getJd());
                djjc.setJxzs(it.getJxzs());
                Djjc djjc1=djdcService.selectZtsj(djjc);
                if(djjc1!=null){
                    sjLjtjzt.setCj(djjc1.getCj());
                }
                sjLjtjztList.add(sjLjtjzt);
            });
//            SgfambKcSggy sgfambKcSggy=sggyList.stream().filter(it->it.getKc().equals(sjJsjg1.getKc())).findFirst().orElse(null);
//            if(sgfambKcSggy!=null){
//                //概要施工参数
//                SjSggyZjzhcs sjSggyZjzhcs=new SjSggyZjzhcs();
//                sjSggyZjzhcs.setJh(jh);
//                sjSggyZjzhcs.setKc(sjJsjg1.getKc());
//                sjSggyZjzhcs.setJd(ksjs+"-"+sjJsjg1.getJs());
//                sjSggyZjzhcs.setZtxh(sgfambKcSggy.getZtxh());
//                sjSggyZjzhcs.setCc(sgfambKcSggy.getCc());
//                sjSggyZjzhcs.setSy(sgfambKcSggy.getSy());
//                sjSggyZjzhcs.setZjymd(sgfambKcSggy.getZjymd());
//                sjSggyZjzhcs.setZjpl(StringUtils.isNotEmpty(sgfambKcSggy.getZjplsx())?sgfambKcSggy.getZjpl()+"-"+sgfambKcSggy.getZjplsx():sgfambKcSggy.getZjpl());
//                sjSggyZjzhcs.setZjby(StringUtils.isNotEmpty(sgfambKcSggy.getZjbysx())?sgfambKcSggy.getZjby()+"-"+sgfambKcSggy.getZjbysx():sgfambKcSggy.getZjby());
//                sjSggyZjzhcs.setZjjg(sgfambKcSggy.getZjzh());
//                sjSggyZjzhcs.setCj(sgfambKcSggy.getCj());
//                sjSggyZjzhcs.setYj(sgfambKcSggy.getYj());
//                sjSggyZjzhcs.setZjzy(StringUtils.isNotEmpty(sgfambKcSggy.getZjzysx())?sgfambKcSggy.getZjzy()+"-"+sgfambKcSggy.getZjzysx():sgfambKcSggy.getZjzy());
//                sjSggyZjzhcs.setZjzs(StringUtils.isNotEmpty(sgfambKcSggy.getZjzssx())?sgfambKcSggy.getZjzs()+"-"+sgfambKcSggy.getZjzssx():sgfambKcSggy.getZjzs());
//                sjSggyZjzhcsMapper.deleteSjSggyZjzhcsByZjzhcs(sjSggyZjzhcs);
//                sjSggyZjzhcsMapper.insertSjSggyZjzhcs(sjSggyZjzhcs);
//            }

            SjSggyZjzhcs sjSggyZjzhcs= new SjSggyZjzhcs();
            sjSggyZjzhcs.setJh(sjDjjc.getJh());
            sjSggyZjzhcs.setKc(sjJsjg1.getKc());
            SjSggyZjzhcs sjSggyZjzhcs1 = sjSggyZjzhcsMapper.selectSjSggyZjzhcsByZjzhcs(sjSggyZjzhcs);
            if(sjSggyZjzhcs1!=null){
                sjSggyZjzhcs1.setJd(ksjs+"-"+sjJsjg1.getJs());
                sjSggyZjzhcs1.setZtxh(jczg.getZyjy());
                sjSggyZjzhcsMapper.updateSjSggyZjzhcs(sjSggyZjzhcs1);
            }


            if(collect.size()>0){
                sjZtxx.setJh(jh);
                sjZtxx.setLb("邻井推荐");
                sjZtxx.setKc(sjJsjg1.getKc());
                sjZtxx.setZtxh(collect.get(0).getZtxh());
                sjZtxxMapper.deleteSjZtxxByZtxx(sjZtxx);
                sjZtxxMapper.insertSjZtxx(sjZtxx);
            }
        }
        if(sjLjtjztList.size()>0){
            sjLjtjztMapper.deleteSjLjtjztByJh(jh);
            sjLjtjztMapper.insertSjLjtjztBatch(sjLjtjztList);
        }

        return AjaxResult.success("计算成功");
    }

    @Override
    public AjaxResult saveZjzh(CommonParam param) {

        //查询邻井
        SjLjjw sjLjjw=new SjLjjw();
        sjLjjw.setJh(param.getJh());
        List<SjLjjw> sjLjjwList = sjLjjwMapper.selectSjLjjwList(sjLjjw);
        if(sjLjjwList.size()>0){
            CommonParam param1=new CommonParam();
            String[] collectArray = sjLjjwList.stream()
                    .map(SjLjjw::getLjjh)
                    .toArray(String[]::new);
            param1.setJhs(collectArray);
            List<DjZjzhfx> zjzhfxList = djdcService.getZjzhfxList(param1);
            zjzhfxList=zjzhfxList.stream().filter(it->it.getZb()!=null).sorted(Comparator.comparing(DjZjzhfx::getZb).reversed()).collect(Collectors.toList());
            if(zjzhfxList.size()>3){
                zjzhfxList=zjzhfxList.subList(0,3);
            }
            List<SjFdsgcsLjzjzh> sjFdsgcsLjzjzhList = new ArrayList<>();
            for (DjZjzhfx it:zjzhfxList) {
                SjFdsgcsLjzjzh sjFdsgcsLjzjzh = new SjFdsgcsLjzjzh();
                sjFdsgcsLjzjzh.setJh(param.getJh());
                String kc  =it.getKc();
                if(kc.equals("1")){
                    kc="一开";
                }else if(kc.equals("2")){
                    kc="二开";
                }else if(kc.equals("3")){
                    kc="三开";
                }else if(kc.equals("4")){
                    kc="四开";
                }else if(kc.equals("5")){
                    kc="五开";
                }
                sjFdsgcsLjzjzh.setKc(kc);
                sjFdsgcsLjzjzh.setLjjh(it.getJh());
                sjFdsgcsLjzjzh.setZjzh(it.getZjzh());
                sjFdsgcsLjzjzh.setSx(it.getZb());
                sjFdsgcsLjzjzh.setJc(it.getJc());
                sjFdsgcsLjzjzhList.add(sjFdsgcsLjzjzh);
            }
            if(sjFdsgcsLjzjzhList.size()>0){
                sjFdsgcsLjzjzhMapper.deleteSjFdsgcsLjzjzhByJh(param.getJh());
                sjFdsgcsLjzjzhMapper.insertSjFdsgcsLjzjzhBatch(sjFdsgcsLjzjzhList);
            }
        }

        return AjaxResult.success("计算成功");
    }

    @Override
    public AjaxResult jsljjz(SjDjjc sjDjjc)throws Exception {
        //查询附近邻井
        String jh = sjDjjc.getJh();
        SjDjjc sjDjjc1 = sjDjjcMapper.selectSjDjjcByJh(jh);
        SjJygjGdsjgdcs sjJygjGdsjgdcs=new SjJygjGdsjgdcs();
        sjJygjGdsjgdcs.setJh(jh);
        List<SjJygjGdsjgdcs> sjJygjGdsjgdcsList = sjJygjGdsjgdcsMapper.selectSjJygjGdsjgdcsList(sjJygjGdsjgdcs);
        if(sjDjjc1!=null){
            if(sjDjjc1.getJdhzb()!=null && sjDjjc1.getJdzzb()!=null){
                CommonParam param =new CommonParam();
                param.setJkhzb(sjDjjc1.getJkhzb());
                param.setJkzzb(sjDjjc1.getJkzzb());
                param.setJl(3000.0);
                param.setQk(sjDjjc1.getQk());
                // 获取当前日期
                LocalDate currentDate = LocalDate.now();

                // 获取四年前的日期
                LocalDate fourYearsAgo = currentDate.minusYears(4);

                // 定义格式化器
                DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy");

                // 格式化日期
                String formattedDate = fourYearsAgo.format(formatter);
                param.setWjsjks(formattedDate);
                param.setWjsjjs(DateUtils.parseDateToStr("yyyy", new Date()));
                List<Ljjw> ljjwList=djdcService.getLjjwList2(param);
                List<String> collect = ljjwList.stream().map(Ljjw::getJh).collect(Collectors.toList());
                if(collect.size()>0){
                    CommonParam param2=new CommonParam();
                    String jhs = String.join(",", collect);
                    param2.setJh(jhs);
                    List<DjZqsjfx> zqshfxList = djdcService.getZqshfxList(param2);
                    Map<String, List<DjZqsjfx>> result =new HashMap<>();
                    if(zqshfxList.size()>0){
                        result = zqshfxList.stream().filter(it->StringUtils.isNotEmpty(it.getKc()) && it.getZb()!=null)
                                .collect(Collectors.groupingBy(DjZqsjfx::getKc)) // 按开次(kc)分组
                                .entrySet().stream()
                                .collect(Collectors.toMap(
                                        Map.Entry::getKey, // 保持开次作为key
                                        entry -> entry.getValue().stream()
                                                .sorted(Comparator.comparingDouble(DjZqsjfx::getZb).reversed())
                                                .limit(5)
                                                .collect(Collectors.toList())
                                ));
                    }
                    List<String> list2 = new ArrayList<>();
                    for (Map.Entry<String, List<DjZqsjfx>> entry : result.entrySet()) {
                        List<DjZqsjfx> value = entry.getValue();
                        list2.addAll(value.stream().map(DjZqsjfx::getJh).collect(Collectors.toList()));
                    }
                    Map<String,Object> map =new HashMap<>();
                    if(list2.size()>0){
                        String[] collect2Array = list2.stream().distinct().limit(5).toArray(String[]::new);
                        param.setJhs(collect2Array);
                        param.setJdhzb(sjDjjc1.getJkhzb());
                        param.setJdzzb(sjDjjc1.getJkzzb());
                        List<Ljjw> ljjwList2=djdcService.getLjjwList3(param);
                        map.put("gzbjhList",ljjwList2.stream().map(Ljjw::getJh).collect(Collectors.toList()));
                        map.put("gzbjhJson",ljjwList2);
                    }else {
                        map.put("gzbjhList",new ArrayList<>());
                        map.put("gzbjhJson",new ArrayList<>());
                    }

                    //查询复杂井
                    List<Jsqa> jsqaList = djdcService.getJsqaList(param2);
                    if(jsqaList.size()>0){
                        List<String> collect1 = jsqaList.stream().map(Jsqa::getJh).collect(Collectors.toList());
                        String[] collect3Array = collect1.stream().distinct().limit(5).toArray(String[]::new);
                        param.setJhs(collect3Array);
                        List<Ljjw> ljjwList3=djdcService.getLjjwList3(param);
                        map.put("fzsgjhList",ljjwList3.stream().map(Ljjw::getJh).collect(Collectors.toList()));
                        map.put("fzsgjhJson",ljjwList3);
                    }else {
                        map.put("fzsgjhList",new ArrayList<>());
                        map.put("fzsgjhJson",new ArrayList<>());
                    }

                    //附近方位井
                    String[] strings = ljjwList.stream().map(Ljjw::getJh).toArray(String[]::new);
                    CommonParam commonParam = new CommonParam();
                    commonParam.setJhs(strings);
                    if(sjJygjGdsjgdcsList.size()>0){
                        commonParam.setFw(sjJygjGdsjgdcsList.get(0).getFw());
                        List<DjZqsjfx> djZqsjfxList = djdcInfoMapper.getjskd(commonParam);
                        List<DjZqsjfx> collect1 = djZqsjfxList.stream().filter(it -> it.getFw() != null).limit(10).collect(Collectors.toList());
                        if(collect1.size()>0){
                            String[] collect2Array = collect1.stream().map(DjZqsjfx::getJh).toArray(String[]::new);
                            param.setJhs(collect2Array);
                            param.setJdhzb(sjDjjc1.getJkhzb());
                            param.setJdzzb(sjDjjc1.getJkzzb());
                            List<Ljjw> ljjwList2=djdcService.getLjjwList3(param);
                            map.put("fwjhList",ljjwList2.stream().map(Ljjw::getJh).collect(Collectors.toList()));
                            map.put("fwJson",ljjwList2);
                        }else {
                            map.put("fwjhList",new ArrayList<>());
                            map.put("fwJson",new ArrayList<>());
                        }
                    }else {
                        map.put("fwjhList",new ArrayList<>());
                        map.put("fwJson",new ArrayList<>());
                    }

                    return AjaxResult.success(map);

                }else {
                    return AjaxResult.error("未匹配到邻井");
                }
            }else {
                return AjaxResult.error("未找到该井井底坐标");
            }
        }else {
            return AjaxResult.error("未找到该井");
        }
    }

    @Autowired
    private SjJygjGdsjgdcsMapper sjJygjGdsjgdcsMapper;

    @Autowired
    private DjdcInfoMapper djdcInfoMapper;

    @Autowired
    private JsqaMapper jsqaMapper;


    @Override
    public int getGzbjList(String jh) throws Exception {
        //查询附近邻井
        SjDjjc sjDjjc1 = sjDjjcMapper.selectSjDjjcByJh(jh);
        SjJygjGdsjgdcs sjJygjGdsjgdcs=new SjJygjGdsjgdcs();
        sjJygjGdsjgdcs.setJh(jh);
        List<SjJygjGdsjgdcs> sjJygjGdsjgdcsList = sjJygjGdsjgdcsMapper.selectSjJygjGdsjgdcsList(sjJygjGdsjgdcs);
        if(sjDjjc1!=null){
            if(sjDjjc1.getJkhzb()!=null && sjDjjc1.getJkzzb()!=null){
                CommonParam param =new CommonParam();
                param.setJkhzb(sjDjjc1.getJkhzb());
                param.setJkzzb(sjDjjc1.getJkzzb());
                param.setJl(3000.0);
                param.setQk(sjDjjc1.getQk());
                // 获取当前日期
                LocalDate currentDate = LocalDate.now();

                // 获取四年前的日期
                LocalDate fourYearsAgo = currentDate.minusYears(4);

                // 定义格式化器
                DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy");

                // 格式化日期
                String formattedDate = fourYearsAgo.format(formatter);
                param.setWjsjks(formattedDate);
                param.setWjsjjs(DateUtils.parseDateToStr("yyyy", new Date()));
                List<Ljjw> ljjwList=djdcService.getLjjwList2(param);
                List<String> collect = ljjwList.stream().map(Ljjw::getJh).collect(Collectors.toList());
                if(collect.size()>0){
                    CommonParam param2=new CommonParam();
                    String jhs = String.join(",", collect);
                    param2.setJh(jhs);
                    List<DjZqsjfx> zqshfxList = djdcService.getZqshfxList(param2);
                    Map<String, List<DjZqsjfx>> result =new HashMap<>();
                    if(zqshfxList.size()>0){
                        result = zqshfxList.stream().filter(it->StringUtils.isNotEmpty(it.getKc()) && it.getZb()!=null)
                                .collect(Collectors.groupingBy(DjZqsjfx::getKc)) // 按开次(kc)分组
                                .entrySet().stream()
                                .collect(Collectors.toMap(
                                        Map.Entry::getKey, // 保持开次作为key
                                        entry -> entry.getValue().stream()
                                                .sorted(Comparator.comparingDouble(DjZqsjfx::getZb).reversed())
                                                .limit(5)
                                                .collect(Collectors.toList())
                                ));
                    }
                    //附近高指标井
                    List<String> list2 = new ArrayList<>();
                    for (Map.Entry<String, List<DjZqsjfx>> entry : result.entrySet()) {
                        List<DjZqsjfx> value = entry.getValue();
                        list2.addAll(value.stream().map(DjZqsjfx::getJh).collect(Collectors.toList()));
                    }
                    List<SjLjjw> sjLjjwList=new ArrayList<>();
                    if(list2.size()>0){
                        //保存邻井
                        String[] collect2Array = list2.stream().distinct().limit(5).toArray(String[]::new);
                        param.setJhs(collect2Array);
                        param.setJdhzb(sjDjjc1.getJkhzb());
                        param.setJdzzb(sjDjjc1.getJkzzb());
                        List<Ljjw> ljjwList2=djdcService.getLjjwList3(param);
                        ljjwList2.forEach(item->{
                            SjLjjw sjLjjw=new SjLjjw();
                            BeanUtils.copyProperties(item,sjLjjw);
                            sjLjjw.setJh(jh);
                            sjLjjw.setLjjh(item.getJh());
                            sjLjjw.setLb1("附近高指标井");
                            sjLjjw.setLb2("推荐");
                            sjLjjwList.add(sjLjjw);
                        });

                        CommonParam commonParam=new CommonParam();
                        commonParam.setQk(sjDjjc1.getQk());
                        commonParam.setSjjh(jh);
                        commonParam.setJh(String.join(",",list2));
                        saveLjzl(commonParam);
                    }
                    //附近方位井
                    String[] strings = ljjwList.stream().map(Ljjw::getJh).toArray(String[]::new);
                    CommonParam commonParam = new CommonParam();
                    commonParam.setJhs(strings);
                    commonParam.setFw(sjJygjGdsjgdcsList.get(0).getFw());
                    List<DjZqsjfx> djZqsjfxList = djdcInfoMapper.getjskd(commonParam);
                    List<DjZqsjfx> collect1 = djZqsjfxList.stream().filter(it -> it.getFw() != null).limit(10).collect(Collectors.toList());
                    if(collect1.size()>0){
                        String[] collect2Array = collect1.stream().map(DjZqsjfx::getJh).toArray(String[]::new);
                        param.setJhs(collect2Array);
                        param.setJdhzb(sjDjjc1.getJkhzb());
                        param.setJdzzb(sjDjjc1.getJkzzb());
                        List<Ljjw> ljjwList2=djdcService.getLjjwList3(param);
                        ljjwList2.forEach(item->{
                            SjLjjw sjLjjw=new SjLjjw();
                            BeanUtils.copyProperties(item,sjLjjw);
                            sjLjjw.setJh(jh);
                            sjLjjw.setLjjh(item.getJh());
                            sjLjjw.setLb1("附近方位井");
                            sjLjjw.setLb2("推荐");
                            sjLjjwList.add(sjLjjw);
                        });
                    }
                    //附近复杂事故井
                    Jsqa jsqa=new Jsqa();
                    jsqa.setJhs(collect);
                    List<Jsqa> jsqaList=jsqaMapper.getJsqaByjhAndJs(jsqa);
                    if(jsqaList.size()>0){
                        String[] collect2Array = jsqaList.stream().map(Jsqa::getJh).toArray(String[]::new);
                        param.setJhs(collect2Array);
                        List<Ljjw> ljjwList2=djdcService.getLjjwList3(param);
                        ljjwList2.forEach(item->{
                            SjLjjw sjLjjw=new SjLjjw();
                            BeanUtils.copyProperties(item,sjLjjw);
                            sjLjjw.setJh(jh);
                            sjLjjw.setLjjh(item.getJh());
                            sjLjjw.setLb1("附近复杂故障井");
                            sjLjjw.setLb2("推荐");
                            sjLjjwList.add(sjLjjw);
                        });
                    }

                    //保存
                    if(sjLjjwList.size()>0){
                        sjLjjwMapper.deleteSjLjjwByJh(jh);
                        sjLjjwMapper.insertSjLjjwBatch(sjLjjwList);
                    }


                }
            }
        }

        return 1;
    }






}
