package com.zjsgfa.project.zjsgfa.service.impl;

import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.zjsgfa.project.zjsgfa.mapper.MxfxjgbTscMapper;
import com.zjsgfa.project.zjsgfa.domain.MxfxjgbTsc;
import com.zjsgfa.project.zjsgfa.service.IMxfxjgbTscService;

/**
 * 大模型分析-提示词Service业务层处理
 * 
 * @author ruoyi
 * @date 2025-12-11
 */
@Service
public class MxfxjgbTscServiceImpl implements IMxfxjgbTscService 
{
    @Autowired
    private MxfxjgbTscMapper mxfxjgbTscMapper;

    /**
     * 查询大模型分析-提示词
     * 
     * @param id 大模型分析-提示词主键
     * @return 大模型分析-提示词
     */
    @Override
    public MxfxjgbTsc selectMxfxjgbTscById(Long id)
    {
        return mxfxjgbTscMapper.selectMxfxjgbTscById(id);
    }

    /**
     * 查询大模型分析-提示词列表
     * 
     * @param mxfxjgbTsc 大模型分析-提示词
     * @return 大模型分析-提示词
     */
    @Override
    public List<MxfxjgbTsc> selectMxfxjgbTscList(MxfxjgbTsc mxfxjgbTsc)
    {
        return mxfxjgbTscMapper.selectMxfxjgbTscList(mxfxjgbTsc);
    }

    /**
     * 新增大模型分析-提示词
     * 
     * @param mxfxjgbTsc 大模型分析-提示词
     * @return 结果
     */
    @Override
    public int insertMxfxjgbTsc(MxfxjgbTsc mxfxjgbTsc)
    {
        return mxfxjgbTscMapper.insertMxfxjgbTsc(mxfxjgbTsc);
    }

    /**
     * 修改大模型分析-提示词
     * 
     * @param mxfxjgbTsc 大模型分析-提示词
     * @return 结果
     */
    @Override
    public int updateMxfxjgbTsc(MxfxjgbTsc mxfxjgbTsc)
    {
        return mxfxjgbTscMapper.updateMxfxjgbTsc(mxfxjgbTsc);
    }

    /**
     * 批量删除大模型分析-提示词
     * 
     * @param ids 需要删除的大模型分析-提示词主键
     * @return 结果
     */
    @Override
    public int deleteMxfxjgbTscByIds(Long[] ids)
    {
        return mxfxjgbTscMapper.deleteMxfxjgbTscByIds(ids);
    }

    /**
     * 删除大模型分析-提示词信息
     * 
     * @param id 大模型分析-提示词主键
     * @return 结果
     */
    @Override
    public int deleteMxfxjgbTscById(Long id)
    {
        return mxfxjgbTscMapper.deleteMxfxjgbTscById(id);
    }
}
