package com.zjsgfa.project.zjsgfa.service;

import java.util.List;
import com.zjsgfa.project.zjsgfa.domain.Sgfamb;

/**
 * 施工方案模板管理Service接口
 * 
 * @author ruoyi
 * @date 2025-09-23
 */
public interface ISgfambService 
{
    /**
     * 查询施工方案模板管理
     * 
     * @param id 施工方案模板管理主键
     * @return 施工方案模板管理
     */
    public Sgfamb selectSgfambById(Long id);

    /**
     * 查询施工方案模板管理列表
     * 
     * @param sgfamb 施工方案模板管理
     * @return 施工方案模板管理集合
     */
    public List<Sgfamb> selectSgfambList(Sgfamb sgfamb);

    /**
     * 新增施工方案模板管理
     * 
     * @param sgfamb 施工方案模板管理
     * @return 结果
     */
    public int insertSgfamb(Sgfamb sgfamb);

    /**
     * 修改施工方案模板管理
     * 
     * @param sgfamb 施工方案模板管理
     * @return 结果
     */
    public int updateSgfamb(Sgfamb sgfamb);

    /**
     * 批量删除施工方案模板管理
     * 
     * @param ids 需要删除的施工方案模板管理主键集合
     * @return 结果
     */
    public int deleteSgfambByIds(Long[] ids);

    /**
     * 删除施工方案模板管理信息
     * 
     * @param id 施工方案模板管理主键
     * @return 结果
     */
    public int deleteSgfambById(Long id);
}
