package com.zjsgfa.project.zjsgfa.domain;

import java.util.Date;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.zjsgfa.framework.aspectj.lang.annotation.Excel;
import com.zjsgfa.framework.web.domain.BaseEntity;

/**
 * 设计信息-井基础信息对象 sj_djjc
 * 
 * @author
 * @date 2025-06-23
 */
@Data
public class SjDjjc extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** 主键 */
    private Long id;

    /** 井号 */
    @Excel(name = "井号")
    private String jh;

    /** 井别 */
    @Excel(name = "井别")
    private String jb;

    /** 井型 */
    @Excel(name = "井型")
    private String jx;
    @Excel(name = "区块")
    private String qk;

    private String famc;

    /** 井口横坐标 */
    @Excel(name = "井口横坐标")
    private Double jkhzb;

    /** 井口纵坐标 */
    @Excel(name = "井口纵坐标")
    private Double jkzzb;

    /** 构造位置 */
    @Excel(name = "构造位置")
    private String gzwz;

    /** 完钻层位 */
    @Excel(name = "完钻层位")
    private String wzcw;

    /** 钻探目的 */
    @Excel(name = "钻探目的")
    private String ztmd;

    /** 完钻原则 */
    @Excel(name = "完钻原则")
    private String wzyz;

    /** 完井方法 */
    @Excel(name = "完井方法")
    private String wjfa;


    /** 创建人 */
    @Excel(name = "创建人")
    private String createdBy;



    /** 创建时间 */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "创建时间", width = 30, dateFormat = "yyyy-MM-dd")
    private Date createdTime;



    /** 钻井公司 */
    @Excel(name = "钻井公司")
    private String zjgs;

    /** 钻井队 */

    private String zjd;
    @Excel(name = "钻井队")
    private String zjdmc;

    /** 井底横坐标 */
    @Excel(name = "井底横坐标")
    private Double jdhzb;

    /** 井底纵坐标 */
    @Excel(name = "井底纵坐标")
    private Double jdzzb;

    /** 状态 */
    @Excel(name = "状态")
    private String zt;



    /** 设计状态（未定稿/定稿） */
    @Excel(name = "设计状态", readConverterExp = "未=定稿/定稿")
    private String sjzt;

    /** 邻井资料状态（未定稿/定稿） */
    @Excel(name = "邻井资料状态", readConverterExp = "未=定稿/定稿")
    private String ljzlzt;

    /** 工程地质分析状态（未定稿/定稿） */
    @Excel(name = "工程地质分析状态", readConverterExp = "未=定稿/定稿")
    private String dzfxzt;

    /** 施工风险提示状态（未定稿/定稿） */
    @Excel(name = "施工风险提示状态", readConverterExp = "未=定稿/定稿")
    private String fxtszt;

    /** 施工概要提示状态（未定稿/定稿） */
    @Excel(name = "施工概要提示状态", readConverterExp = "未=定稿/定稿")
    private String sggyzt;

    /** 分段施工措施状态（未定稿/定稿） */
    @Excel(name = "分段施工措施状态", readConverterExp = "未=定稿/定稿")
    private String fdsgzt;

    /** 井控状态（未定稿/定稿） */
    @Excel(name = "井控状态", readConverterExp = "未=定稿/定稿")
    private String jkzt;

    /** HSE状态（未定稿/定稿） */
    @Excel(name = "HSE状态", readConverterExp = "未=定稿/定稿")
    private String hsezt;

    /** 计划进度状态（未定稿/定稿） */
    @Excel(name = "计划进度状态", readConverterExp = "未=定稿/定稿")
    private String jhjdzt;

    /** 附录状态（未定稿/定稿） */
    @Excel(name = "附录状态", readConverterExp = "未=定稿/定稿")
    private String flzt;

    //方案id
    private Long faid;


}
