package com.zjsgfa.project.zjsgfa.controller;

import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.zjsgfa.framework.aspectj.lang.annotation.Log;
import com.zjsgfa.framework.aspectj.lang.enums.BusinessType;
import com.zjsgfa.project.zjsgfa.domain.JcxxJdxx;
import com.zjsgfa.project.zjsgfa.service.IJcxxJdxxService;
import com.zjsgfa.framework.web.controller.BaseController;
import com.zjsgfa.framework.web.domain.AjaxResult;
import com.zjsgfa.common.utils.poi.ExcelUtil;
import com.zjsgfa.framework.web.page.TableDataInfo;

/**
 * 基础信息-井队设置Controller
 * 
 * @author ruoyi
 * @date 2025-11-28
 */
@RestController
@RequestMapping("/system/jcxxJdxx")
public class JcxxJdxxController extends BaseController
{
    @Autowired
    private IJcxxJdxxService jcxxJdxxService;

    /**
     * 查询基础信息-井队设置列表
     */
    ////@PreAuthorize("@ss.hasPermi('system:jcxxJdxx:list')")
    @GetMapping("/list")
    public TableDataInfo list(JcxxJdxx jcxxJdxx)
    {
        startPage();
        List<JcxxJdxx> list = jcxxJdxxService.selectJcxxJdxxList(jcxxJdxx);
        return getDataTable(list);
    }

    /**
     * 导出基础信息-井队设置列表
     */
    //@PreAuthorize("@ss.hasPermi('system:jcxxJdxx:export')")
    @Log(title = "基础信息-井队设置", businessType = BusinessType.EXPORT)
    @PostMapping("/export")
    public void export(HttpServletResponse response, JcxxJdxx jcxxJdxx)
    {
        List<JcxxJdxx> list = jcxxJdxxService.selectJcxxJdxxList(jcxxJdxx);
        ExcelUtil<JcxxJdxx> util = new ExcelUtil<JcxxJdxx>(JcxxJdxx.class);
        util.exportExcel(response, list, "基础信息-井队设置数据");
    }

    /**
     * 获取基础信息-井队设置详细信息
     */
    //@PreAuthorize("@ss.hasPermi('system:jcxxJdxx:query')")
    @GetMapping(value = "/{id}")
    public AjaxResult getInfo(@PathVariable("id") Long id)
    {
        return success(jcxxJdxxService.selectJcxxJdxxById(id));
    }

    /**
     * 新增基础信息-井队设置
     */
    //@PreAuthorize("@ss.hasPermi('system:jcxxJdxx:add')")
    @Log(title = "基础信息-井队设置", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody JcxxJdxx jcxxJdxx)
    {
        return toAjax(jcxxJdxxService.insertJcxxJdxx(jcxxJdxx));
    }

    /**
     * 修改基础信息-井队设置
     */
    //@PreAuthorize("@ss.hasPermi('system:jcxxJdxx:edit')")
    @Log(title = "基础信息-井队设置", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody JcxxJdxx jcxxJdxx)
    {
        return toAjax(jcxxJdxxService.updateJcxxJdxx(jcxxJdxx));
    }

    /**
     * 删除基础信息-井队设置
     */
    //@PreAuthorize("@ss.hasPermi('system:jcxxJdxx:remove')")
    @Log(title = "基础信息-井队设置", businessType = BusinessType.DELETE)
	@DeleteMapping("/{ids}")
    public AjaxResult remove(@PathVariable Long[] ids)
    {
        return toAjax(jcxxJdxxService.deleteJcxxJdxxByIds(ids));
    }
}
