package com.zjsgfa.project.zt.service.impl;

import com.zjsgfa.project.zt.domain.Jsba;
import com.zjsgfa.project.zt.mapper.JsbaMapper;
import com.zjsgfa.project.zt.service.IJsbaService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * 地质简介基本数据Service业务层处理
 * 
 * @author
 * @date 2025-07-10
 */
@Service
public class JsbaServiceImpl implements IJsbaService 
{
    @Autowired
    private JsbaMapper jsbaMapper;

    /**
     * 查询地质简介基本数据
     * 
     * @param jh 地质简介基本数据主键
     * @return 地质简介基本数据
     */
    @Override
    public Jsba selectJsbaByJh(String jh)
    {
        return jsbaMapper.selectJsbaByJh(jh);
    }

    /**
     * 查询地质简介基本数据列表
     * 
     * @param jsba 地质简介基本数据
     * @return 地质简介基本数据
     */
    @Override
    public List<Jsba> selectJsbaList(Jsba jsba)
    {
        return jsbaMapper.selectJsbaList(jsba);
    }

    /**
     * 新增地质简介基本数据
     * 
     * @param jsba 地质简介基本数据
     * @return 结果
     */
    @Override
    public int insertJsba(Jsba jsba)
    {
        return jsbaMapper.insertJsba(jsba);
    }

    /**
     * 修改地质简介基本数据
     * 
     * @param jsba 地质简介基本数据
     * @return 结果
     */
    @Override
    public int updateJsba(Jsba jsba)
    {
        return jsbaMapper.updateJsba(jsba);
    }

    /**
     * 批量删除地质简介基本数据
     * 
     * @param jhs 需要删除的地质简介基本数据主键
     * @return 结果
     */
    @Override
    public int deleteJsbaByJhs(String[] jhs)
    {
        return jsbaMapper.deleteJsbaByJhs(jhs);
    }

    /**
     * 删除地质简介基本数据信息
     * 
     * @param jh 地质简介基本数据主键
     * @return 结果
     */
    @Override
    public int deleteJsbaByJh(String jh)
    {
        return jsbaMapper.deleteJsbaByJh(jh);
    }
}
