package com.zjsgfa.project.zjsgfa.controller;

import java.util.List;
import javax.servlet.http.HttpServletResponse;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.zjsgfa.framework.aspectj.lang.annotation.Log;
import com.zjsgfa.framework.aspectj.lang.enums.BusinessType;
import com.zjsgfa.project.zjsgfa.domain.SjZlyq;
import com.zjsgfa.project.zjsgfa.service.ISjZlyqService;
import com.zjsgfa.framework.web.controller.BaseController;
import com.zjsgfa.framework.web.domain.AjaxResult;
import com.zjsgfa.common.utils.poi.ExcelUtil;
import com.zjsgfa.framework.web.page.TableDataInfo;

/**
 * 设计信息-井身质量要求Controller
 * 
 * @author
 * @date 2025-07-17
 */
@RestController
@RequestMapping("/system/sjZlyq")
public class SjZlyqController extends BaseController
{
    @Autowired
    private ISjZlyqService sjZlyqService;

    /**
     * 查询设计信息-井身质量要求列表
     */
    //@PreAuthorize("@ss.hasPermi('system:sjZlyq:list')")
    @GetMapping("/list")
    public TableDataInfo list(SjZlyq sjZlyq)
    {
//        startPage();
        List<SjZlyq> list = sjZlyqService.selectSjZlyqList(sjZlyq);
        return getDataTable(list);
    }

    /**
     * 导出设计信息-井身质量要求列表
     */
    //@PreAuthorize("@ss.hasPermi('system:sjZlyq:export')")
    @Log(title = "设计信息-井身质量要求", businessType = BusinessType.EXPORT)
    @PostMapping("/export")
    public void export(HttpServletResponse response, SjZlyq sjZlyq)
    {
        List<SjZlyq> list = sjZlyqService.selectSjZlyqList(sjZlyq);
        ExcelUtil<SjZlyq> util = new ExcelUtil<SjZlyq>(SjZlyq.class);
        util.exportExcel(response, list, "设计信息-井身质量要求数据");
    }

    /**
     * 获取设计信息-井身质量要求详细信息
     */
    //@PreAuthorize("@ss.hasPermi('system:sjZlyq:query')")
    @GetMapping(value = "/{id}")
    public AjaxResult getInfo(@PathVariable("id") Long id)
    {
        return success(sjZlyqService.selectSjZlyqById(id));
    }

    /**
     * 新增设计信息-井身质量要求
     */
    //@PreAuthorize("@ss.hasPermi('system:sjZlyq:add')")
    @Log(title = "设计信息-井身质量要求", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody SjZlyq sjZlyq)
    {
        return toAjax(sjZlyqService.insertSjZlyq(sjZlyq));
    }

    /**
     * 修改设计信息-井身质量要求
     */
    //@PreAuthorize("@ss.hasPermi('system:sjZlyq:edit')")
    @Log(title = "设计信息-井身质量要求", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody SjZlyq sjZlyq)
    {
        return toAjax(sjZlyqService.updateSjZlyq(sjZlyq));
    }

    /**
     * 删除设计信息-井身质量要求
     */
    //@PreAuthorize("@ss.hasPermi('system:sjZlyq:remove')")
    @Log(title = "设计信息-井身质量要求", businessType = BusinessType.DELETE)
	@DeleteMapping("/{ids}")
    public AjaxResult remove(@PathVariable Long[] ids)
    {
        return toAjax(sjZlyqService.deleteSjZlyqByIds(ids));
    }
}
