package com.zjsgfa.project.zjsgfa.controller;

import java.util.List;
import javax.servlet.http.HttpServletResponse;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.zjsgfa.framework.aspectj.lang.annotation.Log;
import com.zjsgfa.framework.aspectj.lang.enums.BusinessType;
import com.zjsgfa.project.zjsgfa.domain.SjSggyZjyCljl;
import com.zjsgfa.project.zjsgfa.service.ISjSggyZjyCljlService;
import com.zjsgfa.framework.web.controller.BaseController;
import com.zjsgfa.framework.web.domain.AjaxResult;
import com.zjsgfa.common.utils.poi.ExcelUtil;
import com.zjsgfa.framework.web.page.TableDataInfo;

/**
 * 设计信息-施工概要-钻井液材料加量Controller
 * 
 * @author
 * @date 2025-08-20
 */
@RestController
@RequestMapping("/system/sjSggyZjyCljl")
public class SjSggyZjyCljlController extends BaseController
{
    @Autowired
    private ISjSggyZjyCljlService sjSggyZjyCljlService;

    /**
     * 查询设计信息-施工概要-钻井液材料加量列表
     */
    //@PreAuthorize("@ss.hasPermi('system:sjSggyZjyCljl:list')")
    @GetMapping("/list")
    public TableDataInfo list(SjSggyZjyCljl sjSggyZjyCljl)
    {
//        startPage();
        List<SjSggyZjyCljl> list = sjSggyZjyCljlService.selectSjSggyZjyCljlList(sjSggyZjyCljl);
        return getDataTable(list);
    }

    /**
     * 导出设计信息-施工概要-钻井液材料加量列表
     */
    //@PreAuthorize("@ss.hasPermi('system:sjSggyZjyCljl:export')")
    @Log(title = "设计信息-施工概要-钻井液材料加量", businessType = BusinessType.EXPORT)
    @PostMapping("/export")
    public void export(HttpServletResponse response, SjSggyZjyCljl sjSggyZjyCljl)
    {
        List<SjSggyZjyCljl> list = sjSggyZjyCljlService.selectSjSggyZjyCljlList(sjSggyZjyCljl);
        ExcelUtil<SjSggyZjyCljl> util = new ExcelUtil<SjSggyZjyCljl>(SjSggyZjyCljl.class);
        util.exportExcel(response, list, "设计信息-施工概要-钻井液材料加量数据");
    }

    /**
     * 获取设计信息-施工概要-钻井液材料加量详细信息
     */
    //@PreAuthorize("@ss.hasPermi('system:sjSggyZjyCljl:query')")
    @GetMapping(value = "/{id}")
    public AjaxResult getInfo(@PathVariable("id") Long id)
    {
        return success(sjSggyZjyCljlService.selectSjSggyZjyCljlById(id));
    }

    /**
     * 新增设计信息-施工概要-钻井液材料加量
     */
    //@PreAuthorize("@ss.hasPermi('system:sjSggyZjyCljl:add')")
    @Log(title = "设计信息-施工概要-钻井液材料加量", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody SjSggyZjyCljl sjSggyZjyCljl)
    {
        return toAjax(sjSggyZjyCljlService.insertSjSggyZjyCljl(sjSggyZjyCljl));
    }

    /**
     * 修改设计信息-施工概要-钻井液材料加量
     */
    //@PreAuthorize("@ss.hasPermi('system:sjSggyZjyCljl:edit')")
    @Log(title = "设计信息-施工概要-钻井液材料加量", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody SjSggyZjyCljl sjSggyZjyCljl)
    {
        return toAjax(sjSggyZjyCljlService.updateSjSggyZjyCljl(sjSggyZjyCljl));
    }

    /**
     * 删除设计信息-施工概要-钻井液材料加量
     */
    //@PreAuthorize("@ss.hasPermi('system:sjSggyZjyCljl:remove')")
    @Log(title = "设计信息-施工概要-钻井液材料加量", businessType = BusinessType.DELETE)
	@DeleteMapping("/{ids}")
    public AjaxResult remove(@PathVariable Long[] ids)
    {
        return toAjax(sjSggyZjyCljlService.deleteSjSggyZjyCljlByIds(ids));
    }
}
