package com.ruoyi.project.zjsgfa.service.impl;

import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ruoyi.project.zjsgfa.mapper.SjZtcsxxMapper;
import com.ruoyi.project.zjsgfa.domain.SjZtcsxx;
import com.ruoyi.project.zjsgfa.service.ISjZtcsxxService;

/**
 * 设计-钻头参数信息Service业务层处理
 * 
 * @author ruoyi
 * @date 2025-08-18
 */
@Service
public class SjZtcsxxServiceImpl implements ISjZtcsxxService 
{
    @Autowired
    private SjZtcsxxMapper sjZtcsxxMapper;

    /**
     * 查询设计-钻头参数信息
     * 
     * @param id 设计-钻头参数信息主键
     * @return 设计-钻头参数信息
     */
    @Override
    public SjZtcsxx selectSjZtcsxxById(Long id)
    {
        return sjZtcsxxMapper.selectSjZtcsxxById(id);
    }

    /**
     * 查询设计-钻头参数信息列表
     * 
     * @param sjZtcsxx 设计-钻头参数信息
     * @return 设计-钻头参数信息
     */
    @Override
    public List<SjZtcsxx> selectSjZtcsxxList(SjZtcsxx sjZtcsxx)
    {
        return sjZtcsxxMapper.selectSjZtcsxxList(sjZtcsxx);
    }

    /**
     * 新增设计-钻头参数信息
     * 
     * @param sjZtcsxx 设计-钻头参数信息
     * @return 结果
     */
    @Override
    public int insertSjZtcsxx(SjZtcsxx sjZtcsxx)
    {
        return sjZtcsxxMapper.insertSjZtcsxx(sjZtcsxx);
    }

    /**
     * 修改设计-钻头参数信息
     * 
     * @param sjZtcsxx 设计-钻头参数信息
     * @return 结果
     */
    @Override
    public int updateSjZtcsxx(SjZtcsxx sjZtcsxx)
    {
        return sjZtcsxxMapper.updateSjZtcsxx(sjZtcsxx);
    }

    /**
     * 批量删除设计-钻头参数信息
     * 
     * @param ids 需要删除的设计-钻头参数信息主键
     * @return 结果
     */
    @Override
    public int deleteSjZtcsxxByIds(Long[] ids)
    {
        return sjZtcsxxMapper.deleteSjZtcsxxByIds(ids);
    }

    /**
     * 删除设计-钻头参数信息信息
     * 
     * @param id 设计-钻头参数信息主键
     * @return 结果
     */
    @Override
    public int deleteSjZtcsxxById(Long id)
    {
        return sjZtcsxxMapper.deleteSjZtcsxxById(id);
    }
}
