package com.ruoyi.project.zjsgfa.domain;

import java.util.Date;
import com.fasterxml.jackson.annotation.JsonFormat;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.ruoyi.framework.aspectj.lang.annotation.Excel;
import com.ruoyi.framework.web.domain.BaseEntity;

/**
 * 设计信息-施工概要-分段钻井液性能设计对象 sj_sggy_zjy_fdxnb
 * 
 * @author ruoyi
 * @date 2025-08-20
 */
public class SjSggyZjyFdxnb extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** 主键 */
    private Long id;

    /** 井号 */
    @Excel(name = "井号")
    private String jh;

    /** 井段 */
    @Excel(name = "井段")
    private String jd;

    /** 密度(g/cm3) */
    @Excel(name = "密度(g/cm3)")
    private String md;

    /** 马氏漏斗黏度(s) */
    @Excel(name = "马氏漏斗黏度(s)")
    private String msldnd;

    /** API 滤失量(ml) */
    @Excel(name = "API 滤失量(ml)")
    private String apilsl;

    /** API 泥饼(mm) */
    @Excel(name = "API 泥饼(mm)")
    private String apinb;

    /** 静切力(Pa) */
    @Excel(name = "静切力(Pa)")
    private String jql;

    /** pH值 */
    @Excel(name = "pH值")
    private String ph;

    /** 含砂量(％) */
    @Excel(name = "含砂量(％)")
    private String hsl;

    /** 总固含(％) */
    @Excel(name = "总固含(％)")
    private String zgh;

    /** 摩阻系数 */
    @Excel(name = "摩阻系数")
    private String mzxs;

    /** 动切力 */
    @Excel(name = "动切力")
    private String dql;

    /** 塑性黏度 */
    @Excel(name = "塑性黏度")
    private String sxnd;

    /** 备注 */
    @Excel(name = "备注")
    private String bz;

    /** 创建人 */
    @Excel(name = "创建人")
    private String createdBy;

    /** 创建时间 */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "创建时间", width = 30, dateFormat = "yyyy-MM-dd")
    private Date createdTime;

    public void setId(Long id) 
    {
        this.id = id;
    }

    public Long getId() 
    {
        return id;
    }

    public void setJh(String jh) 
    {
        this.jh = jh;
    }

    public String getJh() 
    {
        return jh;
    }

    public void setJd(String jd) 
    {
        this.jd = jd;
    }

    public String getJd() 
    {
        return jd;
    }

    public void setMd(String md) 
    {
        this.md = md;
    }

    public String getMd() 
    {
        return md;
    }

    public void setMsldnd(String msldnd) 
    {
        this.msldnd = msldnd;
    }

    public String getMsldnd() 
    {
        return msldnd;
    }

    public void setApilsl(String apilsl) 
    {
        this.apilsl = apilsl;
    }

    public String getApilsl() 
    {
        return apilsl;
    }

    public void setApinb(String apinb) 
    {
        this.apinb = apinb;
    }

    public String getApinb() 
    {
        return apinb;
    }

    public void setJql(String jql) 
    {
        this.jql = jql;
    }

    public String getJql() 
    {
        return jql;
    }

    public void setPh(String ph) 
    {
        this.ph = ph;
    }

    public String getPh() 
    {
        return ph;
    }

    public void setHsl(String hsl) 
    {
        this.hsl = hsl;
    }

    public String getHsl() 
    {
        return hsl;
    }

    public void setZgh(String zgh) 
    {
        this.zgh = zgh;
    }

    public String getZgh() 
    {
        return zgh;
    }

    public void setMzxs(String mzxs) 
    {
        this.mzxs = mzxs;
    }

    public String getMzxs() 
    {
        return mzxs;
    }

    public void setDql(String dql) 
    {
        this.dql = dql;
    }

    public String getDql() 
    {
        return dql;
    }

    public void setSxnd(String sxnd) 
    {
        this.sxnd = sxnd;
    }

    public String getSxnd() 
    {
        return sxnd;
    }

    public void setBz(String bz) 
    {
        this.bz = bz;
    }

    public String getBz() 
    {
        return bz;
    }

    public void setCreatedBy(String createdBy) 
    {
        this.createdBy = createdBy;
    }

    public String getCreatedBy() 
    {
        return createdBy;
    }

    public void setCreatedTime(Date createdTime) 
    {
        this.createdTime = createdTime;
    }

    public Date getCreatedTime() 
    {
        return createdTime;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this,ToStringStyle.MULTI_LINE_STYLE)
            .append("id", getId())
            .append("jh", getJh())
            .append("jd", getJd())
            .append("md", getMd())
            .append("msldnd", getMsldnd())
            .append("apilsl", getApilsl())
            .append("apinb", getApinb())
            .append("jql", getJql())
            .append("ph", getPh())
            .append("hsl", getHsl())
            .append("zgh", getZgh())
            .append("mzxs", getMzxs())
            .append("dql", getDql())
            .append("sxnd", getSxnd())
            .append("bz", getBz())
            .append("createdBy", getCreatedBy())
            .append("createdTime", getCreatedTime())
            .append("updateBy", getUpdateBy())
            .append("updateTime", getUpdateTime())
            .toString();
    }
}
