package com.ruoyi.project.zjsgfa.domain;

import java.util.Date;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.ruoyi.framework.aspectj.lang.annotation.Excel;
import com.ruoyi.framework.web.domain.BaseEntity;

/**
 * 设计信息-井眼轨迹_轨道设计各点参数对象 sj_jygj_gdsjgdcs
 * 
 * @author ruoyi
 * @date 2025-06-26
 */
@Data
public class SjJygjGdsjgdcs extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** 主键 */
    private Long id;

    /** 井号 */
    @Excel(name = "井号")
    private String jh;

    /** 井深 */
    @Excel(name = "井深")
    private Double js;

    /** 井斜 */
    @Excel(name = "井斜")
    private Double jx;

    /** 方位 */
    @Excel(name = "方位")
    private Double fw;

    /** 闭合方位 */
    @Excel(name = "闭合方位")
    private Double bhfw;

    /** 垂深 */
    @Excel(name = "垂深")
    private Double cs;

    /** 闭合距 */
    @Excel(name = "闭合距")
    private Double bhj;

    /** 南北位移 */
    @Excel(name = "南北位移")
    private Double nbwy;

    /** 东西位移 */
    @Excel(name = "东西位移")
    private Double dxwy;

    /** 造斜率 */
    @Excel(name = "造斜率")
    private Double zxl;

    /** 方位变化率 */
    @Excel(name = "方位变化率")
    private Double fwbhl;

    /** 全角变化率 */
    @Excel(name = "全角变化率")
    private Double qjbhl;

    /** 工具面 */
    @Excel(name = "工具面")
    private Double gjm;

    @Excel(name = "视平移")
    private Double spy;


    /** 备注 */
    @Excel(name = "备注")
    private String bz;

    /** 创建人 */
    @Excel(name = "创建人")
    private String createdBy;

    /** 创建时间 */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "创建时间", width = 30, dateFormat = "yyyy-MM-dd")
    private Date createdTime;

    public void setId(Long id) 
    {
        this.id = id;
    }

    public Long getId() 
    {
        return id;
    }

    public void setJh(String jh) 
    {
        this.jh = jh;
    }

    public String getJh() 
    {
        return jh;
    }

    public void setJs(Double js) 
    {
        this.js = js;
    }

    public Double getJs() 
    {
        return js;
    }

    public void setJx(Double jx) 
    {
        this.jx = jx;
    }

    public Double getJx() 
    {
        return jx;
    }

    public void setFw(Double fw) 
    {
        this.fw = fw;
    }

    public Double getFw() 
    {
        return fw;
    }

    public void setBhfw(Double bhfw) 
    {
        this.bhfw = bhfw;
    }

    public Double getBhfw() 
    {
        return bhfw;
    }

    public void setCs(Double cs) 
    {
        this.cs = cs;
    }

    public Double getCs() 
    {
        return cs;
    }

    public void setBhj(Double bhj) 
    {
        this.bhj = bhj;
    }

    public Double getBhj() 
    {
        return bhj;
    }

    public void setNbwy(Double nbwy) 
    {
        this.nbwy = nbwy;
    }

    public Double getNbwy() 
    {
        return nbwy;
    }

    public void setDxwy(Double dxwy) 
    {
        this.dxwy = dxwy;
    }

    public Double getDxwy() 
    {
        return dxwy;
    }

    public void setZxl(Double zxl) 
    {
        this.zxl = zxl;
    }

    public Double getZxl() 
    {
        return zxl;
    }

    public void setFwbhl(Double fwbhl) 
    {
        this.fwbhl = fwbhl;
    }

    public Double getFwbhl() 
    {
        return fwbhl;
    }

    public void setQjbhl(Double qjbhl) 
    {
        this.qjbhl = qjbhl;
    }

    public Double getQjbhl() 
    {
        return qjbhl;
    }

    public void setGjm(Double gjm) 
    {
        this.gjm = gjm;
    }

    public Double getGjm() 
    {
        return gjm;
    }

    public void setBz(String bz) 
    {
        this.bz = bz;
    }

    public String getBz() 
    {
        return bz;
    }

    public void setCreatedBy(String createdBy) 
    {
        this.createdBy = createdBy;
    }

    public String getCreatedBy() 
    {
        return createdBy;
    }

    public void setCreatedTime(Date createdTime) 
    {
        this.createdTime = createdTime;
    }

    public Date getCreatedTime() 
    {
        return createdTime;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this,ToStringStyle.MULTI_LINE_STYLE)
            .append("id", getId())
            .append("jh", getJh())
            .append("js", getJs())
            .append("jx", getJx())
            .append("fw", getFw())
            .append("bhfw", getBhfw())
            .append("cs", getCs())
            .append("bhj", getBhj())
            .append("nbwy", getNbwy())
            .append("dxwy", getDxwy())
            .append("zxl", getZxl())
            .append("fwbhl", getFwbhl())
            .append("qjbhl", getQjbhl())
            .append("gjm", getGjm())
            .append("bz", getBz())
            .append("createdBy", getCreatedBy())
            .append("createdTime", getCreatedTime())
            .append("updateBy", getUpdateBy())
            .append("updateTime", getUpdateTime())
            .toString();
    }
}
