package com.ruoyi.project.zjsgfa.domain;

import lombok.Data;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.ruoyi.framework.aspectj.lang.annotation.Excel;
import com.ruoyi.framework.web.domain.BaseEntity;

/**
 * 设计-地层分析-特殊岩性提示对象 sj_dcfx_tsyx
 * 
 * @author ruoyi
 * @date 2025-08-08
 */
@Data
public class SjDcfxTsyx extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** 主键 */
    private Long id;

    /** 井号 */
    @Excel(name = "井号")
    private String jh;

    /** 特殊岩性 */
    @Excel(name = "特殊岩性")
    private String tsyx;

    /** 层位 */
    @Excel(name = "层位")
    private String cw;

    /** 距顶深 */
    @Excel(name = "距顶深")
    private Double jds;

    private String wt;

    public void setId(Long id) 
    {
        this.id = id;
    }

    public Long getId() 
    {
        return id;
    }

    public void setJh(String jh) 
    {
        this.jh = jh;
    }

    public String getJh() 
    {
        return jh;
    }

    public void setTsyx(String tsyx) 
    {
        this.tsyx = tsyx;
    }

    public String getTsyx() 
    {
        return tsyx;
    }

    public void setCw(String cw) 
    {
        this.cw = cw;
    }

    public String getCw() 
    {
        return cw;
    }

    public void setJds(Double jds) 
    {
        this.jds = jds;
    }

    public Double getJds() 
    {
        return jds;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this,ToStringStyle.MULTI_LINE_STYLE)
            .append("id", getId())
            .append("jh", getJh())
            .append("tsyx", getTsyx())
            .append("cw", getCw())
            .append("jds", getJds())
            .toString();
    }
}
